/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.reporter.plain;

import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.Reporter;
import com.pinterest.ktlint.reporter.plain.Color;
import com.pinterest.ktlint.reporter.plain.PlainReporter;
import com.pinterest.ktlint.reporter.plain.PlainReporterKt;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0002J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\f\u0010\u001b\u001a\u00020\r*\u00020\u000fH\u0002J\f\u0010\u001c\u001a\u00020\r*\u00020\rH\u0002J \u0010\u001d\u001a\u00020\u0013*\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u001e\u001a\u00020\rH\u0002R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/pinterest/ktlint/reporter/plain/PlainReporter;", "Lcom/pinterest/ktlint/core/Reporter;", "out", "Ljava/io/PrintStream;", "groupByFile", "", "shouldColorOutput", "outputColor", "Lcom/pinterest/ktlint/reporter/plain/Color;", "pad", "(Ljava/io/PrintStream;ZZLcom/pinterest/ktlint/reporter/plain/Color;Z)V", "acc", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "Lcom/pinterest/ktlint/core/LintError;", "ruleViolationCount", "", "after", "", "file", "afterAll", "colorFileName", "fileName", "onLintError", "err", "corrected", "causedBy", "colored", "printSummary", "header", "Companion", "ktlint-reporter-plain"})
@SourceDebugExtension(value={"SMAP\nPlainReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainReporter.kt\ncom/pinterest/ktlint/reporter/plain/PlainReporter\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n73#2,2:112\n1#3:114\n1#3:119\n1549#4:115\n1620#4,3:116\n*S KotlinDebug\n*F\n+ 1 PlainReporter.kt\ncom/pinterest/ktlint/reporter/plain/PlainReporter\n*L\n26#1:112,2\n26#1:114\n73#1:115\n73#1:116,3\n*E\n"})
public final class PlainReporter
implements Reporter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PrintStream out;
    private final boolean groupByFile;
    private final boolean shouldColorOutput;
    @NotNull
    private final Color outputColor;
    private final boolean pad;
    @NotNull
    private final ConcurrentHashMap<String, List<LintError>> acc;
    @NotNull
    private final ConcurrentHashMap<String, Long> ruleViolationCount;
    @Deprecated
    @NotNull
    private static final Comparator<Pair<String, Long>> COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR;
    @Deprecated
    @NotNull
    public static final String NOT_A_VALID_KOTLIN_FILE = "Not a valid Kotlin file";

    public PlainReporter(@NotNull PrintStream out, boolean groupByFile, boolean shouldColorOutput, @NotNull Color outputColor, boolean pad) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)((Object)outputColor), (String)"outputColor");
        this.out = out;
        this.groupByFile = groupByFile;
        this.shouldColorOutput = shouldColorOutput;
        this.outputColor = outputColor;
        this.pad = pad;
        this.acc = new ConcurrentHashMap();
        this.ruleViolationCount = new ConcurrentHashMap();
    }

    public /* synthetic */ PlainReporter(PrintStream printStream, boolean bl, boolean bl2, Color color, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            color = Color.DARK_GRAY;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        this(printStream, bl, bl2, color, bl3);
    }

    public void onLintError(@NotNull String file, @NotNull LintError err, boolean corrected) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        if (!corrected) {
            if (this.groupByFile) {
                ConcurrentMap $this$getOrPut$iv = this.acc;
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(file);
                if (object == null) {
                    boolean bl = false;
                    List default$iv = new ArrayList();
                    boolean bl2 = false;
                    object = $this$getOrPut$iv.putIfAbsent(file, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                ((List)object).add(err);
            } else {
                Object object;
                if (this.pad) {
                    String string = "%-4s";
                    Object[] objectArray = new Object[]{err.getCol()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    object = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                } else {
                    object = err.getCol();
                }
                Integer column = object;
                this.out.println(this.colorFileName(file) + this.colored(":") + err.getLine() + this.colored("" + ':' + column + ':') + ' ' + err.getDetail() + ' ' + this.colored('(' + err.getRuleId() + ')'));
            }
            this.ruleViolationCount.merge(this.causedBy(err), 1L, (arg_0, arg_1) -> PlainReporter.onLintError$lambda$1(onLintError.2.INSTANCE, arg_0, arg_1));
        }
    }

    public void after(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.groupByFile) {
            List<LintError> list = this.acc.get(file);
            if (list == null) {
                return;
            }
            List<LintError> errList = list;
            this.out.println(this.colorFileName(file));
            for (LintError lintError : errList) {
                Object object;
                int line = lintError.component1();
                int col = lintError.component2();
                String ruleId = lintError.component3();
                String detail = lintError.component4();
                if (this.pad) {
                    String string = "%-3s";
                    Object[] objectArray = new Object[]{col};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    object = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                } else {
                    object = col;
                }
                Integer column = object;
                this.out.println("  " + line + this.colored("" + ':' + column) + ' ' + detail + ' ' + this.colored('(' + ruleId + ')'));
            }
        }
    }

    public void afterAll() {
        if (!((Map)this.ruleViolationCount).isEmpty()) {
            this.out.println("");
            this.printSummary(this.ruleViolationCount, "Summary error count (descending) by rule:");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void printSummary(ConcurrentHashMap<String, Long> $this$printSummary, String header) {
        void $this$mapTo$iv$iv;
        this.out.println(header);
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)MapsKt.toList((Map)$this$printSummary), COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.out.println("  " + (String)it.getFirst() + ": " + ((Number)it.getSecond()).longValue());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final String colorFileName(String fileName) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String name = StringsKt.substringAfterLast$default((String)fileName, (String)string, null, (int)2, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = fileName.substring(0, fileName.length() - name.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(this.colored(string2)).append(name).toString();
    }

    private final String colored(String $this$colored) {
        return this.shouldColorOutput ? PlainReporterKt.color($this$colored, this.outputColor) : $this$colored;
    }

    private final String causedBy(LintError $this$causedBy) {
        return ((CharSequence)$this$causedBy.getRuleId()).length() > 0 ? $this$causedBy.getRuleId() : (StringsKt.startsWith$default((String)$this$causedBy.getDetail(), (String)NOT_A_VALID_KOTLIN_FILE, (boolean)false, (int)2, null) ? NOT_A_VALID_KOTLIN_FILE : "Unknown");
    }

    public void before(@NotNull String file) {
        Reporter.DefaultImpls.before((Reporter)this, (String)file);
    }

    public void beforeAll() {
        Reporter.DefaultImpls.beforeAll((Reporter)this);
    }

    private static final Long onLintError$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0, p1);
    }

    private static final int COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR$lambda$4(Pair left, Pair right) {
        Pair it = left;
        boolean bl = false;
        Comparable comparable = (Comparable)it.getSecond();
        it = right;
        Comparable comparable2 = comparable;
        bl = false;
        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getSecond()));
    }

    static {
        Comparator comparator = ((Comparator)PlainReporter::COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR$lambda$4).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"{ left, right ->\n       \u2026             }.reversed()");
        Comparator comparator2 = comparator;
        COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR = new Comparator(comparator2){
            final /* synthetic */ Comparator $this_thenComparator;
            {
                this.$this_thenComparator = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenComparator.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    void right;
                    Pair pair = (Pair)b;
                    Pair left = (Pair)a;
                    boolean bl = false;
                    Pair it = left;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)it.getFirst();
                    it = right;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getFirst()));
                }
                return n;
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Ra\u0010\u0003\u001aR\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u00050\u0004j(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007 \b*\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00050\u0005`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/pinterest/ktlint/reporter/plain/PlainReporter$Companion;", "", "()V", "COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR", "Ljava/util/Comparator;", "Lkotlin/Pair;", "", "", "kotlin.jvm.PlatformType", "Lkotlin/Comparator;", "getCOUNT_DESC_AND_RULE_ID_ASC_COMPARATOR", "()Ljava/util/Comparator;", "NOT_A_VALID_KOTLIN_FILE", "ktlint-reporter-plain"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<Pair<String, Long>> getCOUNT_DESC_AND_RULE_ID_ASC_COMPARATOR() {
            return COUNT_DESC_AND_RULE_ID_ASC_COMPARATOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

