/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.api;

import java.io.File;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/pinterest/ktlint/rule/engine/api/Code;", "", "content", "", "fileName", "filePath", "Ljava/nio/file/Path;", "script", "", "isStdIn", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;ZZ)V", "getContent", "()Ljava/lang/String;", "getFileName", "getFilePath", "()Ljava/nio/file/Path;", "()Z", "getScript", "fileNameOrStdin", "filePathOrStdin", "Companion", "ktlint-rule-engine"})
public final class Code {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    @Nullable
    private final String fileName;
    @Nullable
    private final Path filePath;
    private final boolean script;
    private final boolean isStdIn;

    private Code(String content, String fileName, Path filePath, boolean script, boolean isStdIn) {
        this.content = content;
        this.fileName = fileName;
        this.filePath = filePath;
        this.script = script;
        this.isStdIn = isStdIn;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @Nullable
    public final String getFileName() {
        return this.fileName;
    }

    @Nullable
    public final Path getFilePath() {
        return this.filePath;
    }

    public final boolean getScript() {
        return this.script;
    }

    public final boolean isStdIn() {
        return this.isStdIn;
    }

    @NotNull
    public final String fileNameOrStdin() {
        String string;
        if (this.isStdIn) {
            string = "<stdin>";
        } else {
            string = this.fileName;
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    @NotNull
    public final String filePathOrStdin() {
        String string;
        if (this.isStdIn) {
            string = "<stdin>";
        } else {
            Path path = this.filePath;
            string = path != null ? ((Object)path).toString() : null;
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    public /* synthetic */ Code(String content, String fileName, Path filePath, boolean script, boolean isStdIn, DefaultConstructorMarker $constructor_marker) {
        this(content, fileName, filePath, script, isStdIn);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0004\u00a8\u0006\u0010"}, d2={"Lcom/pinterest/ktlint/rule/engine/api/Code$Companion;", "", "()V", "fromFile", "Lcom/pinterest/ktlint/rule/engine/api/Code;", "file", "Ljava/io/File;", "fromPath", "path", "Ljava/nio/file/Path;", "fromSnippet", "content", "", "script", "", "fromStdin", "ktlint-rule-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Code fromFile(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = FilesKt.readText$default((File)file, null, (int)1, null);
            String string2 = file.getName();
            Path path = file.toPath();
            String string3 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
            return new Code(string, string2, path, StringsKt.endsWith((String)string3, (String)".kts", (boolean)true), false, null);
        }

        @NotNull
        public final Code fromPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            FileSystem fileSystem = path.getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"path\n                    .fileSystem");
            org.jetbrains.kotlin.konan.file.File file = ZipUtilKt.file((FileSystem)fileSystem, (String)((Object)path).toString());
            return new Code(CollectionsKt.joinToString$default((Iterable)file.readStrings(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), file.getName(), path, StringsKt.endsWith((String)file.getName(), (String)".kts", (boolean)true), false, null);
        }

        @NotNull
        public final Code fromSnippet(@NotNull String content, boolean script) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new Code(content, null, null, script, true, null);
        }

        public static /* synthetic */ Code fromSnippet$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.fromSnippet(string, bl);
        }

        @NotNull
        public final Code fromStdin() {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"`in`");
            byte[] byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
            return com.pinterest.ktlint.rule.engine.api.Code$Companion.fromSnippet$default(this, new String(byArray, Charsets.UTF_8), false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

