/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.internal.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.internal.rules.KtlintSuppressionRuleKt;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\b\u0018\u00002\u00020\u0001:\u0002*+B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001e\u0010 \u001a\u0004\u0018\u00010\u00032\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\"H\u0002J\u001a\u0010#\u001a\u00020\u001e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\"J\t\u0010$\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010%\u001a\u00020\u001eJ\u001a\u0010&\u001a\u00020\u001e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001e0\"J\t\u0010'\u001a\u00020\u0007H\u00d6\u0001J\f\u0010(\u001a\u00020\u001e*\u00020\u0003H\u0002J\f\u0010)\u001a\u00020\u001e*\u00020\u0003H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006,"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective;", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "ktlintDirectiveType", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$KtlintDirectiveType;", "ktlintDirectives", "", "suppressionIdChanges", "", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange;", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$KtlintDirectiveType;Ljava/lang/String;Ljava/util/Set;)V", "getKtlintDirectiveType", "()Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$KtlintDirectiveType;", "getKtlintDirectives", "()Ljava/lang/String;", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "offset", "", "getOffset", "()I", "getSuppressionIdChanges", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "findMatchingKtlintEnableDirective", "ruleIdValidator", "Lkotlin/Function1;", "hasNoMatchingKtlintEnableDirective", "hashCode", "shouldBeConvertedToFileAnnotation", "shouldBePromotedToParentDeclaration", "toString", "isSuppressibleDeclaration", "isTopLevel", "KtlintDirectiveType", "SuppressionIdChange", "ktlint-rule-engine"})
@SourceDebugExtension(value={"SMAP\nKtlintSuppressionRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtlintSuppressionRule.kt\ncom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ASTNodeExtension.kt\ncom/pinterest/ktlint/rule/engine/core/api/ASTNodeExtensionKt\n*L\n1#1,721:1\n259#2:722\n179#3:723\n180#3:725\n1#4:724\n144#5,8:726\n*S KotlinDebug\n*F\n+ 1 KtlintSuppressionRule.kt\ncom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective\n*L\n587#1:722\n589#1:723\n589#1:725\n627#1:726,8\n*E\n"})
final class KtLintDirective {
    @NotNull
    private final ASTNode node;
    @NotNull
    private final KtlintDirectiveType ktlintDirectiveType;
    @NotNull
    private final String ktlintDirectives;
    @NotNull
    private final Set<SuppressionIdChange> suppressionIdChanges;
    private final int offset;

    public KtLintDirective(@NotNull ASTNode node, @NotNull KtlintDirectiveType ktlintDirectiveType, @NotNull String ktlintDirectives, @NotNull Set<? extends SuppressionIdChange> suppressionIdChanges) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)ktlintDirectiveType), (String)"ktlintDirectiveType");
        Intrinsics.checkNotNullParameter((Object)ktlintDirectives, (String)"ktlintDirectives");
        Intrinsics.checkNotNullParameter(suppressionIdChanges, (String)"suppressionIdChanges");
        this.node = node;
        this.ktlintDirectiveType = ktlintDirectiveType;
        this.ktlintDirectives = ktlintDirectives;
        this.suppressionIdChanges = suppressionIdChanges;
        int n = this.node.getStartOffset();
        String string = this.node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        this.offset = n + StringsKt.indexOf$default((CharSequence)string, (String)this.ktlintDirectiveType.getId(), (int)0, (boolean)false, (int)6, null);
    }

    @NotNull
    public final ASTNode getNode() {
        return this.node;
    }

    @NotNull
    public final KtlintDirectiveType getKtlintDirectiveType() {
        return this.ktlintDirectiveType;
    }

    @NotNull
    public final String getKtlintDirectives() {
        return this.ktlintDirectives;
    }

    @NotNull
    public final Set<SuppressionIdChange> getSuppressionIdChanges() {
        return this.suppressionIdChanges;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final boolean hasNoMatchingKtlintEnableDirective(@NotNull Function1<? super String, Boolean> ruleIdValidator2) {
        Intrinsics.checkNotNullParameter(ruleIdValidator2, (String)"ruleIdValidator");
        if (!(this.ktlintDirectiveType == KtlintDirectiveType.KTLINT_DISABLE && Intrinsics.areEqual((Object)this.node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.shouldBeConvertedToFileAnnotation() ? false : this.findMatchingKtlintEnableDirective(ruleIdValidator2) == null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final ASTNode findMatchingKtlintEnableDirective(Function1<? super String, Boolean> ruleIdValidator2) {
        Object element$iv;
        Object v1;
        String string;
        ASTNode aSTNode;
        void $this$applyIf$iv;
        ASTNode aSTNode2 = this.node;
        boolean if$iv = this.isSuppressibleDeclaration(this.node);
        boolean $i$f$applyIf = false;
        if (if$iv) {
            void $this$findMatchingKtlintEnableDirective_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            aSTNode = this.node.getTreeParent();
        } else {
            aSTNode = $this$applyIf$iv;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node\n            .applyI\u2026on()) { node.treeParent }");
        Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings$default((ASTNode)aSTNode, (boolean)false, (int)1, null);
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v1 = null;
                return v1;
            }
            element$iv = iterator.next();
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            KtLintDirective ktLintDirective = KtlintSuppressionRuleKt.access$ktlintDirectiveOrNull(it, ruleIdValidator2);
            if (ktLintDirective != null) {
                KtLintDirective ktLintDirective2;
                KtLintDirective ktLintDirective3;
                KtLintDirective it2 = ktLintDirective3 = ktLintDirective;
                boolean bl2 = false;
                KtLintDirective ktLintDirective4 = ktLintDirective2 = it2.ktlintDirectiveType == KtlintDirectiveType.KTLINT_ENABLE ? ktLintDirective3 : null;
                if (ktLintDirective2 != null) {
                    string = ktLintDirective2.ktlintDirectives;
                    continue;
                }
            }
            string = null;
        } while (!Intrinsics.areEqual(string, (Object)this.ktlintDirectives));
        v1 = element$iv;
        return v1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldBeConvertedToFileAnnotation() {
        if (this.isTopLevel(this.node)) return true;
        if (!Intrinsics.areEqual((Object)this.node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) return false;
        if (!this.isSuppressibleDeclaration(this.node)) return false;
        ASTNode aSTNode = this.node.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
        if (!this.isTopLevel(aSTNode)) return false;
        return true;
    }

    private final boolean isSuppressibleDeclaration(ASTNode $this$isSuppressibleDeclaration) {
        IElementType iElementType = $this$isSuppressibleDeclaration.getTreeParent().getElementType();
        return (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUN())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPROPERTY());
    }

    private final boolean isTopLevel(ASTNode $this$isTopLevel) {
        return Intrinsics.areEqual((Object)ElementType.INSTANCE.getFILE(), (Object)$this$isTopLevel.getTreeParent().getElementType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldBePromotedToParentDeclaration(@NotNull Function1<? super String, Boolean> ruleIdValidator2) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        block3: {
            ASTNode aSTNode3;
            Intrinsics.checkNotNullParameter(ruleIdValidator2, (String)"ruleIdValidator");
            if (!(this.ktlintDirectiveType == KtlintDirectiveType.KTLINT_DISABLE && Intrinsics.areEqual((Object)this.node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.shouldBeConvertedToFileAnnotation()) {
                return false;
            }
            ASTNode it = aSTNode3 = this.node;
            boolean bl = false;
            if (!this.isSuppressibleDeclaration(it)) return false;
            ASTNode aSTNode4 = aSTNode3;
            ASTNode aSTNode5 = aSTNode4;
            if (aSTNode5 == null) return false;
            ASTNode it2 = aSTNode5;
            boolean bl2 = false;
            aSTNode3 = this.findMatchingKtlintEnableDirective(ruleIdValidator2);
            if (aSTNode3 == null) return false;
            ASTNode matchingKtlintEnabledDirective = aSTNode3;
            boolean bl3 = false;
            ASTNode aSTNode6 = this.node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode6, (String)"node\n                            .treeParent");
            ASTNode aSTNode7 = aSTNode6;
            aSTNode2 = matchingKtlintEnabledDirective;
            boolean $i$f$nextSibling = false;
            for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                ASTNode it3 = n$iv;
                boolean bl4 = false;
                if (!(!ASTNodeExtensionKt.isWhiteSpace((ASTNode)it3))) continue;
                aSTNode = n$iv;
                break block3;
            }
            aSTNode = null;
        }
        if (Intrinsics.areEqual((Object)aSTNode2, aSTNode)) return false;
        return true;
    }

    @NotNull
    public final ASTNode component1() {
        return this.node;
    }

    @NotNull
    public final KtlintDirectiveType component2() {
        return this.ktlintDirectiveType;
    }

    @NotNull
    public final String component3() {
        return this.ktlintDirectives;
    }

    @NotNull
    public final Set<SuppressionIdChange> component4() {
        return this.suppressionIdChanges;
    }

    @NotNull
    public final KtLintDirective copy(@NotNull ASTNode node, @NotNull KtlintDirectiveType ktlintDirectiveType, @NotNull String ktlintDirectives, @NotNull Set<? extends SuppressionIdChange> suppressionIdChanges) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)ktlintDirectiveType), (String)"ktlintDirectiveType");
        Intrinsics.checkNotNullParameter((Object)ktlintDirectives, (String)"ktlintDirectives");
        Intrinsics.checkNotNullParameter(suppressionIdChanges, (String)"suppressionIdChanges");
        return new KtLintDirective(node, ktlintDirectiveType, ktlintDirectives, suppressionIdChanges);
    }

    public static /* synthetic */ KtLintDirective copy$default(KtLintDirective ktLintDirective, ASTNode aSTNode, KtlintDirectiveType ktlintDirectiveType, String string, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            aSTNode = ktLintDirective.node;
        }
        if ((n & 2) != 0) {
            ktlintDirectiveType = ktLintDirective.ktlintDirectiveType;
        }
        if ((n & 4) != 0) {
            string = ktLintDirective.ktlintDirectives;
        }
        if ((n & 8) != 0) {
            set = ktLintDirective.suppressionIdChanges;
        }
        return ktLintDirective.copy(aSTNode, ktlintDirectiveType, string, set);
    }

    @NotNull
    public String toString() {
        return "KtLintDirective(node=" + this.node + ", ktlintDirectiveType=" + (Object)((Object)this.ktlintDirectiveType) + ", ktlintDirectives=" + this.ktlintDirectives + ", suppressionIdChanges=" + this.suppressionIdChanges + ')';
    }

    public int hashCode() {
        int result = this.node.hashCode();
        result = result * 31 + this.ktlintDirectiveType.hashCode();
        result = result * 31 + this.ktlintDirectives.hashCode();
        result = result * 31 + ((Object)this.suppressionIdChanges).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KtLintDirective)) {
            return false;
        }
        KtLintDirective ktLintDirective = (KtLintDirective)other;
        if (!Intrinsics.areEqual((Object)this.node, (Object)ktLintDirective.node)) {
            return false;
        }
        if (this.ktlintDirectiveType != ktLintDirective.ktlintDirectiveType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ktlintDirectives, (Object)ktLintDirective.ktlintDirectives)) {
            return false;
        }
        return Intrinsics.areEqual(this.suppressionIdChanges, ktLintDirective.suppressionIdChanges);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$KtlintDirectiveType;", "", "id", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getId", "()Ljava/lang/String;", "KTLINT_DISABLE", "KTLINT_ENABLE", "ktlint-rule-engine"})
    public static final class KtlintDirectiveType
    extends Enum<KtlintDirectiveType> {
        @NotNull
        private final String id;
        public static final /* enum */ KtlintDirectiveType KTLINT_DISABLE = new KtlintDirectiveType("ktlint-disable");
        public static final /* enum */ KtlintDirectiveType KTLINT_ENABLE = new KtlintDirectiveType("ktlint-enable");
        private static final /* synthetic */ KtlintDirectiveType[] $VALUES;

        private KtlintDirectiveType(String id) {
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public static KtlintDirectiveType[] values() {
            return (KtlintDirectiveType[])$VALUES.clone();
        }

        public static KtlintDirectiveType valueOf(String value) {
            return Enum.valueOf(KtlintDirectiveType.class, value);
        }

        static {
            $VALUES = ktlintDirectiveTypeArray = new KtlintDirectiveType[]{KtlintDirectiveType.KTLINT_DISABLE, KtlintDirectiveType.KTLINT_ENABLE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange;", "", "()V", "InvalidSuppressionId", "ValidSuppressionId", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$InvalidSuppressionId;", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$ValidSuppressionId;", "ktlint-rule-engine"})
    public static abstract class SuppressionIdChange {
        private SuppressionIdChange() {
        }

        public /* synthetic */ SuppressionIdChange(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$InvalidSuppressionId;", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange;", "originalRuleId", "", "offsetOriginalRuleId", "", "(Ljava/lang/String;I)V", "getOffsetOriginalRuleId", "()I", "getOriginalRuleId", "()Ljava/lang/String;", "ktlint-rule-engine"})
        public static final class InvalidSuppressionId
        extends SuppressionIdChange {
            @NotNull
            private final String originalRuleId;
            private final int offsetOriginalRuleId;

            public InvalidSuppressionId(@NotNull String originalRuleId, int offsetOriginalRuleId) {
                Intrinsics.checkNotNullParameter((Object)originalRuleId, (String)"originalRuleId");
                super(null);
                this.originalRuleId = originalRuleId;
                this.offsetOriginalRuleId = offsetOriginalRuleId;
            }

            @NotNull
            public final String getOriginalRuleId() {
                return this.originalRuleId;
            }

            public final int getOffsetOriginalRuleId() {
                return this.offsetOriginalRuleId;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$ValidSuppressionId;", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange;", "suppressionId", "", "(Ljava/lang/String;)V", "getSuppressionId", "()Ljava/lang/String;", "ktlint-rule-engine"})
        public static final class ValidSuppressionId
        extends SuppressionIdChange {
            @NotNull
            private final String suppressionId;

            public ValidSuppressionId(@NotNull String suppressionId) {
                Intrinsics.checkNotNullParameter((Object)suppressionId, (String)"suppressionId");
                super(null);
                this.suppressionId = suppressionId;
            }

            @NotNull
            public final String getSuppressionId() {
                return this.suppressionId;
            }
        }
    }
}

