/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.internal.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.internal.rules.KtlintSuppressionRuleKt;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001:\u0002%&B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010!\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\u001a\u0010\"\u001a\u00020\u00072\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u001a\u0010#\u001a\u00020\u00072\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\f\u0010$\u001a\u00020\u0007*\u00020\u0003H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006'"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective;", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "ruleIdValidator", "Lkotlin/Function1;", "", "", "ktlintDirectiveType", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$KtlintDirectiveType;", "ktlintDirectives", "suppressionIdChanges", "", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange;", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Lkotlin/jvm/functions/Function1;Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$KtlintDirectiveType;Ljava/lang/String;Ljava/util/Set;)V", "getKtlintDirectiveType", "()Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$KtlintDirectiveType;", "getKtlintDirectives", "()Ljava/lang/String;", "listElementTypeTokenSet", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "listTypeTokenSet", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "offset", "", "getOffset", "()I", "getRuleIdValidator", "()Lkotlin/jvm/functions/Function1;", "getSuppressionIdChanges", "()Ljava/util/Set;", "findMatchingKtlintEnableDirective", "hasNoMatchingKtlintEnableDirective", "shouldBePromotedToParentDeclaration", "surroundsMultipleListElements", "KtlintDirectiveType", "SuppressionIdChange", "ktlint-rule-engine"})
@SourceDebugExtension(value={"SMAP\nKtlintSuppressionRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtlintSuppressionRule.kt\ncom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ASTNodeExtension.kt\ncom/pinterest/ktlint/rule/engine/core/api/ASTNodeExtensionKt\n*L\n1#1,418:1\n271#2:419\n179#3:420\n180#3:422\n1268#3,3:439\n1#4:421\n144#5,8:423\n144#5,8:431\n*S KotlinDebug\n*F\n+ 1 KtlintSuppressionRule.kt\ncom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective\n*L\n266#1:419\n268#1:420\n268#1:422\n305#1:439,3\n290#1:423,8\n301#1:431,8\n*E\n"})
final class KtLintDirective {
    @NotNull
    private final ASTNode node;
    @NotNull
    private final Function1<String, Boolean> ruleIdValidator;
    @NotNull
    private final KtlintDirectiveType ktlintDirectiveType;
    @NotNull
    private final String ktlintDirectives;
    @NotNull
    private final Set<SuppressionIdChange> suppressionIdChanges;
    private final int offset;
    @NotNull
    private final TokenSet listTypeTokenSet;
    @NotNull
    private final TokenSet listElementTypeTokenSet;

    public KtLintDirective(@NotNull ASTNode node, @NotNull Function1<? super String, Boolean> ruleIdValidator2, @NotNull KtlintDirectiveType ktlintDirectiveType, @NotNull String ktlintDirectives, @NotNull Set<? extends SuppressionIdChange> suppressionIdChanges) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(ruleIdValidator2, (String)"ruleIdValidator");
        Intrinsics.checkNotNullParameter((Object)((Object)ktlintDirectiveType), (String)"ktlintDirectiveType");
        Intrinsics.checkNotNullParameter((Object)ktlintDirectives, (String)"ktlintDirectives");
        Intrinsics.checkNotNullParameter(suppressionIdChanges, (String)"suppressionIdChanges");
        this.node = node;
        this.ruleIdValidator = ruleIdValidator2;
        this.ktlintDirectiveType = ktlintDirectiveType;
        this.ktlintDirectives = ktlintDirectives;
        this.suppressionIdChanges = suppressionIdChanges;
        int n = this.node.getStartOffset();
        String string = this.node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.offset = n + StringsKt.indexOf$default((CharSequence)string, (String)this.ktlintDirectiveType.getId(), (int)0, (boolean)false, (int)6, null);
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getTYPE_ARGUMENT_LIST(), ElementType.INSTANCE.getTYPE_PARAMETER_LIST(), ElementType.INSTANCE.getVALUE_ARGUMENT_LIST(), ElementType.INSTANCE.getVALUE_PARAMETER_LIST()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.listTypeTokenSet = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getTYPE_PROJECTION(), ElementType.INSTANCE.getTYPE_PARAMETER(), ElementType.INSTANCE.getVALUE_ARGUMENT(), ElementType.INSTANCE.getVALUE_PARAMETER()};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        this.listElementTypeTokenSet = tokenSet2;
    }

    @NotNull
    public final ASTNode getNode() {
        return this.node;
    }

    @NotNull
    public final Function1<String, Boolean> getRuleIdValidator() {
        return this.ruleIdValidator;
    }

    @NotNull
    public final KtlintDirectiveType getKtlintDirectiveType() {
        return this.ktlintDirectiveType;
    }

    @NotNull
    public final String getKtlintDirectives() {
        return this.ktlintDirectives;
    }

    @NotNull
    public final Set<SuppressionIdChange> getSuppressionIdChanges() {
        return this.suppressionIdChanges;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final boolean hasNoMatchingKtlintEnableDirective(@NotNull Function1<? super String, Boolean> ruleIdValidator2) {
        Intrinsics.checkNotNullParameter(ruleIdValidator2, (String)"ruleIdValidator");
        if (!(this.ktlintDirectiveType == KtlintDirectiveType.KTLINT_DISABLE && Intrinsics.areEqual((Object)this.node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return KtlintSuppressionRuleKt.access$shouldBeConvertedToFileAnnotation(this.node) ? false : this.findMatchingKtlintEnableDirective(ruleIdValidator2) == null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final ASTNode findMatchingKtlintEnableDirective(Function1<? super String, Boolean> ruleIdValidator2) {
        Object element$iv;
        Object v1;
        String string;
        ASTNode aSTNode;
        void $this$applyIf$iv;
        ASTNode aSTNode2 = this.node;
        boolean if$iv = KtlintSuppressionRuleKt.access$isSuppressibleDeclaration(this.node);
        boolean $i$f$applyIf = false;
        if (if$iv) {
            void $this$findMatchingKtlintEnableDirective_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            aSTNode = this.node.getTreeParent();
        } else {
            aSTNode = $this$applyIf$iv;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"applyIf(...)");
        Sequence $this$firstOrNull$iv = PsiUtilsKt.siblings$default((ASTNode)aSTNode, (boolean)false, (int)1, null);
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v1 = null;
                return v1;
            }
            element$iv = iterator.next();
            ASTNode node = (ASTNode)element$iv;
            boolean bl = false;
            KtLintDirective ktLintDirective = KtlintSuppressionRuleKt.access$ktlintDirectiveOrNull(node, ruleIdValidator2);
            if (ktLintDirective != null) {
                KtLintDirective ktLintDirective2;
                KtLintDirective ktLintDirective3;
                KtLintDirective it = ktLintDirective3 = ktLintDirective;
                boolean bl2 = false;
                KtLintDirective ktLintDirective4 = ktLintDirective2 = it.ktlintDirectiveType == KtlintDirectiveType.KTLINT_ENABLE ? ktLintDirective3 : null;
                if (ktLintDirective2 != null) {
                    string = ktLintDirective2.ktlintDirectives;
                    continue;
                }
            }
            string = null;
        } while (!Intrinsics.areEqual(string, (Object)this.ktlintDirectives));
        v1 = element$iv;
        return v1;
    }

    public final boolean shouldBePromotedToParentDeclaration(@NotNull Function1<? super String, Boolean> ruleIdValidator2) {
        Intrinsics.checkNotNullParameter(ruleIdValidator2, (String)"ruleIdValidator");
        if (!(this.ktlintDirectiveType == KtlintDirectiveType.KTLINT_DISABLE && Intrinsics.areEqual((Object)this.node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (KtlintSuppressionRuleKt.access$shouldBeConvertedToFileAnnotation(this.node)) {
            return false;
        }
        if (KtlintSuppressionRuleKt.access$isSuppressibleDeclaration(this.node)) {
            boolean bl;
            ASTNode aSTNode = this.findMatchingKtlintEnableDirective(ruleIdValidator2);
            if (aSTNode != null) {
                ASTNode aSTNode2;
                ASTNode aSTNode3;
                block6: {
                    ASTNode matchingKtlintEnabledDirective = aSTNode;
                    boolean bl2 = false;
                    ASTNode aSTNode4 = this.node.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"getTreeParent(...)");
                    ASTNode aSTNode5 = aSTNode4;
                    aSTNode3 = matchingKtlintEnabledDirective;
                    boolean $i$f$nextSibling = false;
                    for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                        ASTNode it = n$iv;
                        boolean bl3 = false;
                        if (!(!ASTNodeExtensionKt.isWhiteSpace((ASTNode)it))) continue;
                        aSTNode2 = n$iv;
                        break block6;
                    }
                    aSTNode2 = null;
                }
                bl = !Intrinsics.areEqual((Object)aSTNode3, aSTNode2);
            } else {
                bl = false;
            }
            return bl;
        }
        return this.surroundsMultipleListElements(this.node);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean surroundsMultipleListElements(ASTNode $this$surroundsMultipleListElements) {
        boolean bl;
        if (!(this.ktlintDirectiveType == KtlintDirectiveType.KTLINT_DISABLE && Intrinsics.areEqual((Object)$this$surroundsMultipleListElements.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.listTypeTokenSet.contains($this$surroundsMultipleListElements.getTreeParent().getElementType())) {
            Sequence sequence;
            Sequence sequence2;
            ASTNode aSTNode;
            block7: {
                ASTNode $this$nextSibling$iv = $this$surroundsMultipleListElements;
                boolean $i$f$nextSibling = false;
                for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                    ASTNode it = n$iv;
                    boolean bl2 = false;
                    if (!this.listElementTypeTokenSet.contains(it.getElementType())) continue;
                    aSTNode = n$iv;
                    break block7;
                }
                aSTNode = null;
            }
            ASTNode firstElementAfterEnableDirective = aSTNode;
            ASTNode aSTNode2 = this.findMatchingKtlintEnableDirective(this.ruleIdValidator);
            if (aSTNode2 != null && (sequence2 = PsiUtilsKt.siblings((ASTNode)aSTNode2, (boolean)false)) != null && (sequence = SequencesKt.takeWhile((Sequence)sequence2, (Function1)((Function1)new Function1<ASTNode, Boolean>($this$surroundsMultipleListElements){
                final /* synthetic */ ASTNode $this_surroundsMultipleListElements;
                {
                    this.$this_surroundsMultipleListElements = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$this_surroundsMultipleListElements);
                }
            }))) != null) {
                void $this$count$iv;
                Sequence bl2 = sequence;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl3 = false;
                    if (!this.listElementTypeTokenSet.contains(it.getElementType()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int it = count$iv;
                boolean bl4 = false;
                bl = it > 1;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$KtlintDirectiveType;", "", "id", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getId", "()Ljava/lang/String;", "KTLINT_DISABLE", "KTLINT_ENABLE", "ktlint-rule-engine"})
    public static final class KtlintDirectiveType
    extends Enum<KtlintDirectiveType> {
        @NotNull
        private final String id;
        public static final /* enum */ KtlintDirectiveType KTLINT_DISABLE = new KtlintDirectiveType("ktlint-disable");
        public static final /* enum */ KtlintDirectiveType KTLINT_ENABLE = new KtlintDirectiveType("ktlint-enable");
        private static final /* synthetic */ KtlintDirectiveType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private KtlintDirectiveType(String id) {
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public static KtlintDirectiveType[] values() {
            return (KtlintDirectiveType[])$VALUES.clone();
        }

        public static KtlintDirectiveType valueOf(String value) {
            return Enum.valueOf(KtlintDirectiveType.class, value);
        }

        @NotNull
        public static EnumEntries<KtlintDirectiveType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = ktlintDirectiveTypeArray = new KtlintDirectiveType[]{KtlintDirectiveType.KTLINT_DISABLE, KtlintDirectiveType.KTLINT_ENABLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange;", "", "()V", "InvalidSuppressionId", "ValidSuppressionId", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$InvalidSuppressionId;", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$ValidSuppressionId;", "ktlint-rule-engine"})
    public static abstract class SuppressionIdChange {
        private SuppressionIdChange() {
        }

        public /* synthetic */ SuppressionIdChange(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$InvalidSuppressionId;", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange;", "originalRuleId", "", "offsetOriginalRuleId", "", "(Ljava/lang/String;I)V", "getOffsetOriginalRuleId", "()I", "getOriginalRuleId", "()Ljava/lang/String;", "ktlint-rule-engine"})
        public static final class InvalidSuppressionId
        extends SuppressionIdChange {
            @NotNull
            private final String originalRuleId;
            private final int offsetOriginalRuleId;

            public InvalidSuppressionId(@NotNull String originalRuleId, int offsetOriginalRuleId) {
                Intrinsics.checkNotNullParameter((Object)originalRuleId, (String)"originalRuleId");
                super(null);
                this.originalRuleId = originalRuleId;
                this.offsetOriginalRuleId = offsetOriginalRuleId;
            }

            @NotNull
            public final String getOriginalRuleId() {
                return this.originalRuleId;
            }

            public final int getOffsetOriginalRuleId() {
                return this.offsetOriginalRuleId;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$ValidSuppressionId;", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange;", "suppressionId", "", "(Ljava/lang/String;)V", "getSuppressionId", "()Ljava/lang/String;", "Companion", "ktlint-rule-engine"})
        public static final class ValidSuppressionId
        extends SuppressionIdChange {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String suppressionId;
            @NotNull
            private static final ValidSuppressionId KTLINT_SUPPRESSION_ALL = new ValidSuppressionId("\"ktlint\"");

            public ValidSuppressionId(@NotNull String suppressionId) {
                Intrinsics.checkNotNullParameter((Object)suppressionId, (String)"suppressionId");
                super(null);
                this.suppressionId = suppressionId;
            }

            @NotNull
            public final String getSuppressionId() {
                return this.suppressionId;
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$ValidSuppressionId$Companion;", "", "()V", "KTLINT_SUPPRESSION_ALL", "Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$ValidSuppressionId;", "getKTLINT_SUPPRESSION_ALL", "()Lcom/pinterest/ktlint/rule/engine/internal/rules/KtLintDirective$SuppressionIdChange$ValidSuppressionId;", "ktlint-rule-engine"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final ValidSuppressionId getKTLINT_SUPPRESSION_ALL() {
                    return KTLINT_SUPPRESSION_ALL;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

