/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.api;

import com.pinterest.ktlint.rule.engine.api.Code;
import com.pinterest.ktlint.rule.engine.api.EditorConfigDefaults;
import com.pinterest.ktlint.rule.engine.api.EditorConfigOverride;
import com.pinterest.ktlint.rule.engine.api.LintError;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.RuleId;
import com.pinterest.ktlint.rule.engine.core.api.RuleProvider;
import com.pinterest.ktlint.rule.engine.core.api.RuleProviderKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.rule.engine.internal.AllAutocorrectHandler;
import com.pinterest.ktlint.rule.engine.internal.CodeFormatter;
import com.pinterest.ktlint.rule.engine.internal.EditorConfigFinder;
import com.pinterest.ktlint.rule.engine.internal.EditorConfigGenerator;
import com.pinterest.ktlint.rule.engine.internal.EditorConfigLoader;
import com.pinterest.ktlint.rule.engine.internal.EditorConfigLoaderEc4j;
import com.pinterest.ktlint.rule.engine.internal.LintErrorAutocorrectHandler;
import com.pinterest.ktlint.rule.engine.internal.NoneAutocorrectHandler;
import com.pinterest.ktlint.rule.engine.internal.RuleExecutionContext;
import com.pinterest.ktlint.rule.engine.internal.ThreadSafeEditorConfigCache;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ec4j.core.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 92\u00020\u0001:\u00019B?\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ$\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0014\b\u0002\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020#0'J,\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020%2\u001a\b\u0002\u0010&\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020#0+H\u0007J6\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010,\u001a\u00020\n2\b\b\u0002\u0010-\u001a\u00020\n2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020.0'J\u000e\u0010/\u001a\u00020*2\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020#J\u0014\u00103\u001a\b\u0012\u0004\u0012\u000201042\u0006\u00105\u001a\u000201J\u000e\u00106\u001a\u00020#2\u0006\u00105\u001a\u000201J\u000e\u00107\u001a\u0002082\u0006\u0010$\u001a\u00020%R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine;", "", "ruleProviders", "", "Lcom/pinterest/ktlint/rule/engine/core/api/RuleProvider;", "editorConfigDefaults", "Lcom/pinterest/ktlint/rule/engine/api/EditorConfigDefaults;", "editorConfigOverride", "Lcom/pinterest/ktlint/rule/engine/api/EditorConfigOverride;", "isInvokedFromCli", "", "fileSystem", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/util/Set;Lcom/pinterest/ktlint/rule/engine/api/EditorConfigDefaults;Lcom/pinterest/ktlint/rule/engine/api/EditorConfigOverride;ZLjava/nio/file/FileSystem;)V", "getRuleProviders", "()Ljava/util/Set;", "getEditorConfigDefaults", "()Lcom/pinterest/ktlint/rule/engine/api/EditorConfigDefaults;", "getEditorConfigOverride", "()Lcom/pinterest/ktlint/rule/engine/api/EditorConfigOverride;", "()Z", "getFileSystem", "()Ljava/nio/file/FileSystem;", "editorConfigLoaderEc4j", "Lcom/pinterest/ktlint/rule/engine/internal/EditorConfigLoaderEc4j;", "getEditorConfigLoaderEc4j$ktlint_rule_engine", "()Lcom/pinterest/ktlint/rule/engine/internal/EditorConfigLoaderEc4j;", "editorConfigLoader", "Lcom/pinterest/ktlint/rule/engine/internal/EditorConfigLoader;", "getEditorConfigLoader$ktlint_rule_engine", "()Lcom/pinterest/ktlint/rule/engine/internal/EditorConfigLoader;", "codeFormatter", "Lcom/pinterest/ktlint/rule/engine/internal/CodeFormatter;", "lint", "", "code", "Lcom/pinterest/ktlint/rule/engine/api/Code;", "callback", "Lkotlin/Function1;", "Lcom/pinterest/ktlint/rule/engine/api/LintError;", "format", "", "Lkotlin/Function2;", "rerunAfterAutocorrect", "defaultAutocorrect", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "generateKotlinEditorConfigSection", "filePath", "Ljava/nio/file/Path;", "trimMemory", "editorConfigFilePaths", "", "path", "reloadEditorConfigFile", "transformToAst", "Lorg/jetbrains/kotlin/com/intellij/lang/FileASTNode;", "Companion", "ktlint-rule-engine"})
@SourceDebugExtension(value={"SMAP\nKtLintRuleEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtLintRuleEngine.kt\ncom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine\n+ 2 Any.kt\ncom/pinterest/ktlint/rule/engine/core/util/AnyKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n7#2:225\n1557#3:226\n1628#3,3:227\n1663#3,8:230\n*S KotlinDebug\n*F\n+ 1 KtLintRuleEngine.kt\ncom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine\n*L\n171#1:225\n175#1:226\n175#1:227,3\n176#1:230,8\n*E\n"})
public final class KtLintRuleEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<RuleProvider> ruleProviders;
    @NotNull
    private final EditorConfigDefaults editorConfigDefaults;
    @NotNull
    private final EditorConfigOverride editorConfigOverride;
    private final boolean isInvokedFromCli;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final EditorConfigLoaderEc4j editorConfigLoaderEc4j;
    @NotNull
    private final EditorConfigLoader editorConfigLoader;
    @NotNull
    private final CodeFormatter codeFormatter;
    @NotNull
    public static final String UTF8_BOM = "\ufeff";
    @NotNull
    public static final String STDIN_FILE = "<stdin>";
    private static final int MAX_FORMAT_RUNS_PER_FILE = 3;

    public KtLintRuleEngine(@NotNull Set<RuleProvider> ruleProviders, @NotNull EditorConfigDefaults editorConfigDefaults, @NotNull EditorConfigOverride editorConfigOverride, boolean isInvokedFromCli, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter(ruleProviders, (String)"ruleProviders");
        Intrinsics.checkNotNullParameter((Object)editorConfigDefaults, (String)"editorConfigDefaults");
        Intrinsics.checkNotNullParameter((Object)editorConfigOverride, (String)"editorConfigOverride");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.ruleProviders = ruleProviders;
        this.editorConfigDefaults = editorConfigDefaults;
        this.editorConfigOverride = editorConfigOverride;
        this.isInvokedFromCli = isInvokedFromCli;
        this.fileSystem = fileSystem;
        if (!CollectionsKt.any((Iterable)this.ruleProviders)) {
            boolean bl = false;
            String string = "A non-empty set of 'ruleProviders' need to be provided";
            throw new IllegalArgumentException(string.toString());
        }
        this.editorConfigLoaderEc4j = new EditorConfigLoaderEc4j(RuleProviderKt.propertyTypes((Collection)this.ruleProviders));
        this.editorConfigLoader = new EditorConfigLoader(this.fileSystem, this.editorConfigLoaderEc4j, this.editorConfigDefaults, this.editorConfigOverride);
        this.codeFormatter = new CodeFormatter(this);
    }

    public /* synthetic */ KtLintRuleEngine(Set set, EditorConfigDefaults editorConfigDefaults, EditorConfigOverride editorConfigOverride, boolean bl, FileSystem fileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            editorConfigDefaults = EditorConfigDefaults.Companion.getEMPTY_EDITOR_CONFIG_DEFAULTS();
        }
        if ((n & 4) != 0) {
            editorConfigOverride = EditorConfigOverride.Companion.getEMPTY_EDITOR_CONFIG_OVERRIDE();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            fileSystem = FileSystems.getDefault();
        }
        this(set, editorConfigDefaults, editorConfigOverride, bl, fileSystem);
    }

    @NotNull
    public final Set<RuleProvider> getRuleProviders() {
        return this.ruleProviders;
    }

    @NotNull
    public final EditorConfigDefaults getEditorConfigDefaults() {
        return this.editorConfigDefaults;
    }

    @NotNull
    public final EditorConfigOverride getEditorConfigOverride() {
        return this.editorConfigOverride;
    }

    public final boolean isInvokedFromCli() {
        return this.isInvokedFromCli;
    }

    @NotNull
    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @NotNull
    public final EditorConfigLoaderEc4j getEditorConfigLoaderEc4j$ktlint_rule_engine() {
        return this.editorConfigLoaderEc4j;
    }

    @NotNull
    public final EditorConfigLoader getEditorConfigLoader$ktlint_rule_engine() {
        return this.editorConfigLoader;
    }

    public final void lint(@NotNull Code code, @NotNull Function1<? super LintError, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.codeFormatter.format(code, NoneAutocorrectHandler.INSTANCE, (Function2<? super LintError, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> KtLintRuleEngine.lint$lambda$2(callback, arg_0, arg_1)), 1);
    }

    public static /* synthetic */ void lint$default(KtLintRuleEngine ktLintRuleEngine, Code code, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = KtLintRuleEngine::lint$lambda$1;
        }
        ktLintRuleEngine.lint(code, (Function1<? super LintError, Unit>)function1);
    }

    @Deprecated(message="Marked for removal in Ktlint 2.0")
    @NotNull
    public final String format(@NotNull Code code, @NotNull Function2<? super LintError, ? super Boolean, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.codeFormatter.format(code, AllAutocorrectHandler.INSTANCE, callback, 3);
    }

    public static /* synthetic */ String format$default(KtLintRuleEngine ktLintRuleEngine, Code code, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = KtLintRuleEngine::format$lambda$3;
        }
        return ktLintRuleEngine.format(code, (Function2<? super LintError, ? super Boolean, Unit>)function2);
    }

    @NotNull
    public final String format(@NotNull Code code, boolean rerunAfterAutocorrect, boolean defaultAutocorrect, @NotNull Function1<? super LintError, ? extends AutocorrectDecision> callback) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return CodeFormatter.format$default(this.codeFormatter, code, new LintErrorAutocorrectHandler(defaultAutocorrect, callback), null, rerunAfterAutocorrect ? 3 : 1, 4, null);
    }

    public static /* synthetic */ String format$default(KtLintRuleEngine ktLintRuleEngine, Code code, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return ktLintRuleEngine.format(code, bl, bl2, (Function1<? super LintError, ? extends AutocorrectDecision>)function1);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String generateKotlinEditorConfigSection(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        var3_2 = this.editorConfigOverride.getProperties().get(CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY());
        if (var3_2 == null || (var4_3 = var3_2.getParsed()) == null) ** GOTO lbl-1000
        var6_4 = var4_3;
        $i$f$safeAs = false;
        v0 = $this$safeAs$iv;
        if (!(v0 instanceof CodeStyleValue)) {
            v0 = null;
        }
        if ((var5_7 = (CodeStyleValue)v0) != null) {
            v1 = var5_7;
        } else lbl-1000:
        // 2 sources

        {
            v1 = (CodeStyleValue)CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY().getDefaultValue();
        }
        codeStyle = v1;
        var4_3 = this.ruleProviders;
        $i$f$map = false;
        $this$safeAs$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_14 = (RuleProvider)item$iv$iv;
            var13_17 = destination$iv$iv;
            $i$a$-map-KtLintRuleEngine$generateKotlinEditorConfigSection$rules$1 = false;
            var13_17.add(it.createNewRuleInstance());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$distinctBy = false;
        set$iv = new HashSet<RuleId>();
        list$iv = new ArrayList<T>();
        for (T e$iv : $this$distinctBy$iv) {
            it = (Rule)e$iv;
            $i$a$-distinctBy-KtLintRuleEngine$generateKotlinEditorConfigSection$rules$2 = false;
            key$iv = it.getRuleId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        rules = CollectionsKt.toSet((Iterable)list$iv);
        return new EditorConfigGenerator(this.fileSystem, this.editorConfigLoaderEc4j).generateEditorconfig(rules, codeStyle, filePath);
    }

    public final void trimMemory() {
        ThreadSafeEditorConfigCache.Companion.getTHREAD_SAFE_EDITOR_CONFIG_CACHE().clear();
    }

    @NotNull
    public final List<Path> editorConfigFilePaths(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new EditorConfigFinder(this.editorConfigLoaderEc4j).findEditorConfigs(path);
    }

    public final void reloadEditorConfigFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ThreadSafeEditorConfigCache threadSafeEditorConfigCache = ThreadSafeEditorConfigCache.Companion.getTHREAD_SAFE_EDITOR_CONFIG_CACHE();
        Resource resource = Resource.Resources.ofPath((Path)path, (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)resource, (String)"ofPath(...)");
        threadSafeEditorConfigCache.reloadIfExists(resource);
    }

    @NotNull
    public final FileASTNode transformToAst(@NotNull Code code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return RuleExecutionContext.Companion.createRuleExecutionContext$ktlint_rule_engine(this, code).getRootNode();
    }

    private static final Unit lint$lambda$1(LintError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit lint$lambda$2(Function1 $callback, LintError lintError, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lintError, (String)"lintError");
        $callback.invoke((Object)lintError);
        return Unit.INSTANCE;
    }

    private static final Unit format$lambda$3(LintError lintError, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lintError, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    public KtLintRuleEngine() {
        this(null, null, null, false, null, 31, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine$Companion;", "", "<init>", "()V", "UTF8_BOM", "", "STDIN_FILE", "MAX_FORMAT_RUNS_PER_FILE", "", "ktlint-rule-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

