/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.internal;

import com.pinterest.ktlint.rule.engine.api.Code;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleEngine;
import com.pinterest.ktlint.rule.engine.api.LintError;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EndOfLinePropertyKt;
import com.pinterest.ktlint.rule.engine.internal.AutocorrectHandler;
import com.pinterest.ktlint.rule.engine.internal.CodeFormatterKt;
import com.pinterest.ktlint.rule.engine.internal.NoneAutocorrectHandler;
import com.pinterest.ktlint.rule.engine.internal.RuleExecutionContext;
import com.pinterest.ktlint.rule.engine.internal.VisitorProvider;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u001a\b\u0002\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\t*\u00020\u000bH\u0002J>\u0010\b\u001a \u0012\u0004\u0012\u00020\t\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u00160\u00170\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0018\u001a\u00020\t*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0002J.\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u00160\u0017*\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u001b\u001a\u00020\u0011*\u00020\u0019H\u0002J6\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u00160\u0017*\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u001f\u001a\u00020\t*\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\u0011*\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J2\u0010%\u001a\u0012\u0012\u0004\u0012\u0002H'0&j\b\u0012\u0004\u0012\u0002H'`(\"\u0004\b\u0000\u0010'2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020\u00100*H\u0002J\u0014\u0010+\u001a\u00020\t*\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006,"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/CodeFormatter;", "", "ktLintRuleEngine", "Lcom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine;", "<init>", "(Lcom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine;)V", "getKtLintRuleEngine", "()Lcom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine;", "format", "", "code", "Lcom/pinterest/ktlint/rule/engine/api/Code;", "autocorrectHandler", "Lcom/pinterest/ktlint/rule/engine/internal/AutocorrectHandler;", "callback", "Lkotlin/Function2;", "Lcom/pinterest/ktlint/rule/engine/api/LintError;", "", "", "maxFormatRunsPerFile", "", "utf8Bom", "Lkotlin/Pair;", "", "formattedCode", "Lcom/pinterest/ktlint/rule/engine/internal/RuleExecutionContext;", "lineSeparator", "lintAfterFormat", "executeRule", "rule", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule;", "determineLineSeparator", "eolEditorConfigProperty", "Lorg/ec4j/core/model/PropertyType$EndOfLineValue;", "doesNotContain", "char", "", "lintErrorLineAndColumnComparator", "Ljava/util/Comparator;", "T", "Lkotlin/Comparator;", "transformer", "Lkotlin/Function1;", "logMessage", "ktlint-rule-engine"})
@SourceDebugExtension(value={"SMAP\nCodeFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFormatter.kt\ncom/pinterest/ktlint/rule/engine/internal/CodeFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1863#2,2:195\n2632#2,3:197\n1863#2:200\n1864#2:202\n1863#2,2:203\n1#3:201\n*S KotlinDebug\n*F\n+ 1 CodeFormatter.kt\ncom/pinterest/ktlint/rule/engine/internal/CodeFormatter\n*L\n32#1:195,2\n60#1:197,3\n108#1:200\n108#1:202\n118#1:203,2\n*E\n"})
public final class CodeFormatter {
    @NotNull
    private final KtLintRuleEngine ktLintRuleEngine;

    public CodeFormatter(@NotNull KtLintRuleEngine ktLintRuleEngine) {
        Intrinsics.checkNotNullParameter((Object)ktLintRuleEngine, (String)"ktLintRuleEngine");
        this.ktLintRuleEngine = ktLintRuleEngine;
    }

    @NotNull
    public final KtLintRuleEngine getKtLintRuleEngine() {
        return this.ktLintRuleEngine;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String format(@NotNull Code code, @NotNull AutocorrectHandler autocorrectHandler, @NotNull Function2<? super LintError, ? super Boolean, Unit> callback, int maxFormatRunsPerFile) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)autocorrectHandler, (String)"autocorrectHandler");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        CodeFormatterKt.access$getLOGGER$p().debug(() -> CodeFormatter.format$lambda$1(code));
        Pair<String, Set<Pair<LintError, Boolean>>> pair = this.format(code, autocorrectHandler, maxFormatRunsPerFile);
        String formattedCode = (String)pair.component1();
        Set errors = (Set)pair.component2();
        Object object = CollectionsKt.sortedWith((Iterable)errors, this.lintErrorLineAndColumnComparator(CodeFormatter::format$lambda$2));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair2 = (Pair)element$iv;
            boolean bl = false;
            LintError e = (LintError)pair2.component1();
            boolean corrected = (Boolean)pair2.component2();
            callback.invoke((Object)e, (Object)corrected);
        }
        Object it = object = UtilKt.prefixIfNot((String)formattedCode, (String)this.utf8Bom(code));
        boolean bl = false;
        CodeFormatterKt.access$getLOGGER$p().debug(() -> CodeFormatter.format$lambda$5$lambda$4(code));
        return object;
    }

    public static /* synthetic */ String format$default(CodeFormatter codeFormatter, Code code, AutocorrectHandler autocorrectHandler, Function2 function2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function2 = CodeFormatter::format$lambda$0;
        }
        return codeFormatter.format(code, autocorrectHandler, (Function2<? super LintError, ? super Boolean, Unit>)function2, n);
    }

    private final String utf8Bom(Code $this$utf8Bom) {
        return StringsKt.startsWith$default((String)$this$utf8Bom.getContent(), (String)"\ufeff", (boolean)false, (int)2, null) ? "\ufeff" : "";
    }

    private final Pair<String, Set<Pair<LintError, Boolean>>> format(Code code, AutocorrectHandler autocorrectHandler, int maxFormatRunsPerFile) {
        RuleExecutionContext $this$format_u24lambda_u2410 = RuleExecutionContext.Companion.createRuleExecutionContext$ktlint_rule_engine(this.ktLintRuleEngine, code);
        boolean bl = false;
        String lineSeparator = this.determineLineSeparator(code, (PropertyType.EndOfLineValue)$this$format_u24lambda_u2410.getEditorConfig().get(EndOfLinePropertyKt.getEND_OF_LINE_PROPERTY()));
        String codeContent = this.formattedCode($this$format_u24lambda_u2410, lineSeparator);
        Set errors = new LinkedHashSet();
        int formatRunCount = 0;
        boolean mutated = false;
        do {
            boolean bl2;
            block6: {
                Set<Pair<LintError, Boolean>> newErrors = this.format($this$format_u24lambda_u2410, autocorrectHandler, code);
                errors.addAll((Collection)newErrors);
                Iterable $this$none$iv = newErrors;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl3 = false;
                        if (!(((LintError)it.getFirst()).getCanBeAutoCorrected() && (Boolean)it.getSecond() != false)) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            if (bl2) break;
            String updatedCodeContent = this.formattedCode($this$format_u24lambda_u2410, lineSeparator);
            if (Intrinsics.areEqual((Object)updatedCodeContent, (Object)codeContent)) {
                CodeFormatterKt.access$getLOGGER$p().warn(() -> CodeFormatter.format$lambda$10$lambda$7(code));
                break;
            }
            codeContent = updatedCodeContent;
            mutated = true;
        } while (++formatRunCount < maxFormatRunsPerFile);
        if (mutated && formatRunCount == maxFormatRunsPerFile && !(autocorrectHandler instanceof NoneAutocorrectHandler)) {
            boolean bl4;
            boolean it = bl4 = this.lintAfterFormat($this$format_u24lambda_u2410);
            boolean bl5 = false;
            CodeFormatterKt.access$getLOGGER$p().warn(() -> CodeFormatter.format$lambda$10$lambda$9$lambda$8(code, maxFormatRunsPerFile));
        }
        return mutated ? new Pair((Object)this.formattedCode($this$format_u24lambda_u2410, lineSeparator), (Object)errors) : new Pair((Object)code.getContent(), (Object)errors);
    }

    private final String formattedCode(RuleExecutionContext $this$formattedCode, String lineSeparator) {
        String string = $this$formattedCode.getRootNode().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.replace$default((String)string, (String)"\n", (String)lineSeparator, (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Pair<LintError, Boolean>> format(RuleExecutionContext $this$format, AutocorrectHandler autocorrectHandler, Code code) {
        void $this$forEach$iv;
        Set errors = new LinkedHashSet();
        Iterable iterable = new VisitorProvider($this$format.getRuleProviders(), false, 2, null).getRules$ktlint_rule_engine();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rule rule = (Rule)element$iv;
            boolean bl = false;
            Set<Pair<LintError, Boolean>> ruleErrors = this.executeRule($this$format, rule, autocorrectHandler, code);
            boolean bl2 = false;
            errors.addAll((Collection)ruleErrors);
        }
        return errors;
    }

    private final boolean lintAfterFormat(RuleExecutionContext $this$lintAfterFormat) {
        Ref.BooleanRef hasErrorsWhichCanBeAutocorrected = new Ref.BooleanRef();
        Iterable $this$forEach$iv = new VisitorProvider($this$lintAfterFormat.getRuleProviders(), false, 2, null).getRules$ktlint_rule_engine();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Rule rule = (Rule)element$iv;
            boolean bl = false;
            if (hasErrorsWhichCanBeAutocorrected.element) continue;
            $this$lintAfterFormat.executeRule(rule, NoneAutocorrectHandler.INSTANCE, (Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision>)((Function3)(arg_0, arg_1, arg_2) -> CodeFormatter.lintAfterFormat$lambda$14$lambda$13(hasErrorsWhichCanBeAutocorrected, arg_0, arg_1, arg_2)));
        }
        return hasErrorsWhichCanBeAutocorrected.element;
    }

    private final Set<Pair<LintError, Boolean>> executeRule(RuleExecutionContext $this$executeRule, Rule rule, AutocorrectHandler autocorrectHandler, Code code) {
        Set errors = new LinkedHashSet();
        $this$executeRule.executeRule(rule, autocorrectHandler, (Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision>)((Function3)(arg_0, arg_1, arg_2) -> CodeFormatter.executeRule$lambda$17($this$executeRule, rule, autocorrectHandler, errors, this, code, arg_0, arg_1, arg_2)));
        return errors;
    }

    private final String determineLineSeparator(Code $this$determineLineSeparator, PropertyType.EndOfLineValue eolEditorConfigProperty) {
        String string;
        if (eolEditorConfigProperty == PropertyType.EndOfLineValue.crlf || eolEditorConfigProperty != PropertyType.EndOfLineValue.lf && this.doesNotContain($this$determineLineSeparator, '\r')) {
            String string2;
            String it = string2 = "\r\n";
            boolean bl = false;
            CodeFormatterKt.access$getLOGGER$p().trace(() -> CodeFormatter.determineLineSeparator$lambda$19$lambda$18(eolEditorConfigProperty));
            string = string2;
        } else {
            String string3;
            String it = string3 = "\n";
            boolean bl = false;
            CodeFormatterKt.access$getLOGGER$p().trace(() -> CodeFormatter.determineLineSeparator$lambda$21$lambda$20(eolEditorConfigProperty));
            string = string3;
        }
        return string;
    }

    private final boolean doesNotContain(Code $this$doesNotContain, char c) {
        return StringsKt.lastIndexOf$default((CharSequence)$this$doesNotContain.getContent(), (char)c, (int)0, (boolean)false, (int)6, null) != -1;
    }

    private final <T> Comparator<T> lintErrorLineAndColumnComparator(Function1<? super T, LintError> transformer) {
        return ComparisonsKt.then((Comparator)new Comparator(transformer){
            final /* synthetic */ Function1 $transformer$inlined;
            {
                this.$transformer$inlined = function1;
            }

            public final int compare(T a, T b) {
                T it = a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((LintError)this.$transformer$inlined.invoke(it)).getLine());
                it = b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((LintError)this.$transformer$inlined.invoke(it)).getLine()));
            }
        }, (Comparator)new Comparator(transformer){
            final /* synthetic */ Function1 $transformer$inlined;
            {
                this.$transformer$inlined = function1;
            }

            public final int compare(T a, T b) {
                T it = a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((LintError)this.$transformer$inlined.invoke(it)).getCol());
                it = b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((LintError)this.$transformer$inlined.invoke(it)).getCol()));
            }
        });
    }

    private final String logMessage(LintError $this$logMessage, Code code) {
        return code.fileNameOrStdin() + ':' + $this$logMessage.getLine() + ':' + $this$logMessage.getCol() + ": " + $this$logMessage.getDetail() + " (" + $this$logMessage.getRuleId() + ')' + ($this$logMessage.getCanBeAutoCorrected() ? "" : " [cannot be autocorrected]");
    }

    private static final Unit format$lambda$0(LintError lintError, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lintError, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Object format$lambda$1(Code $code) {
        return "Starting with processing file '" + $code.fileNameOrStdin() + '\'';
    }

    private static final LintError format$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LintError)it.getFirst();
    }

    private static final Object format$lambda$5$lambda$4(Code $code) {
        return "Finished with processing file '" + $code.fileNameOrStdin() + '\'';
    }

    private static final Object format$lambda$10$lambda$7(Code $code) {
        return "Format was not able to resolve all violations which (theoretically) can be autocorrected in file " + $code.filePathOrStdin();
    }

    private static final Object format$lambda$10$lambda$9$lambda$8(Code $code, int $maxFormatRunsPerFile) {
        return "Format was not able to resolve all violations which (theoretically) can be autocorrected in file " + $code.filePathOrStdin() + " in " + $maxFormatRunsPerFile + " consecutive runs of format.";
    }

    private static final AutocorrectDecision lintAfterFormat$lambda$14$lambda$13(Ref.BooleanRef $hasErrorsWhichCanBeAutocorrected, int n, String string, boolean canBeAutoCorrected) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        if (canBeAutoCorrected) {
            $hasErrorsWhichCanBeAutocorrected.element = true;
        }
        return AutocorrectDecision.NO_AUTOCORRECT;
    }

    private static final Object executeRule$lambda$17$lambda$16$lambda$15(CodeFormatter this$0, LintError $lintError, Code $code) {
        return "Format violation: " + this$0.logMessage($lintError, $code);
    }

    private static final AutocorrectDecision executeRule$lambda$17(RuleExecutionContext $this_executeRule, Rule $rule, AutocorrectHandler $autocorrectHandler, Set $errors, CodeFormatter this$0, Code $code, int offset, String errorMessage, boolean canBeAutoCorrected) {
        boolean autocorrect;
        AutocorrectDecision autocorrectDecision;
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Pair pair = (Pair)$this_executeRule.getPositionInTextLocator().invoke((Object)offset);
        int line = ((Number)pair.component1()).intValue();
        int col = ((Number)pair.component2()).intValue();
        LintError lintError = new LintError(line, col, $rule.getRuleId(), errorMessage, canBeAutoCorrected);
        AutocorrectDecision autocorrectDecision2 = autocorrectDecision = $autocorrectHandler.autocorrectDecision(lintError);
        boolean bl = false;
        boolean bl2 = autocorrect = autocorrectDecision2 == AutocorrectDecision.ALLOW_AUTOCORRECT && canBeAutoCorrected;
        if (autocorrect) {
            CodeFormatterKt.access$getLOGGER$p().trace(() -> CodeFormatter.executeRule$lambda$17$lambda$16$lambda$15(this$0, lintError, $code));
        }
        $errors.add(new Pair((Object)lintError, (Object)autocorrect));
        return autocorrectDecision;
    }

    private static final Object determineLineSeparator$lambda$19$lambda$18(PropertyType.EndOfLineValue $eolEditorConfigProperty) {
        return "line separator: " + $eolEditorConfigProperty.name() + " --> CRLF";
    }

    private static final Object determineLineSeparator$lambda$21$lambda$20(PropertyType.EndOfLineValue $eolEditorConfigProperty) {
        return "line separator: " + $eolEditorConfigProperty.name() + " --> LF";
    }
}

