/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.rule.engine.internal.rulefilter;

import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.RuleId;
import com.pinterest.ktlint.rule.engine.core.api.RuleProvider;
import com.pinterest.ktlint.rule.engine.core.api.RuleSetId;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecution;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecutionEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.internal.rulefilter.RuleExecutionRuleFilterKt;
import com.pinterest.ktlint.rule.engine.internal.rules.KtlintSuppressionRuleKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/pinterest/ktlint/rule/engine/internal/rulefilter/RuleExecutionFilter;", "", "ruleExecutionProperties", "", "", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/RuleExecution;", "codeStyleValue", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "<init>", "(Ljava/util/Map;Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;)V", "getRuleExecutionProperties", "()Ljava/util/Map;", "getCodeStyleValue", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "isEnabled", "", "ruleProvider", "Lcom/pinterest/ktlint/rule/engine/core/api/RuleProvider;", "isRuleEnabled", "rule", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule;", "isRuleConditionallyEnabled", "isExperimentalEnabled", "isOfficialCodeStyleEnabled", "isRuleSetEnabled", "ruleExecution", "ruleExecutionPropertyName", "ktlint-rule-engine"})
final class RuleExecutionFilter {
    @NotNull
    private final Map<String, RuleExecution> ruleExecutionProperties;
    @NotNull
    private final CodeStyleValue codeStyleValue;

    public RuleExecutionFilter(@NotNull Map<String, ? extends RuleExecution> ruleExecutionProperties, @NotNull CodeStyleValue codeStyleValue) {
        Intrinsics.checkNotNullParameter(ruleExecutionProperties, (String)"ruleExecutionProperties");
        Intrinsics.checkNotNullParameter((Object)codeStyleValue, (String)"codeStyleValue");
        this.ruleExecutionProperties = ruleExecutionProperties;
        this.codeStyleValue = codeStyleValue;
    }

    @NotNull
    public final Map<String, RuleExecution> getRuleExecutionProperties() {
        return this.ruleExecutionProperties;
    }

    @NotNull
    public final CodeStyleValue getCodeStyleValue() {
        return this.codeStyleValue;
    }

    public final boolean isEnabled(@NotNull RuleProvider ruleProvider) {
        Intrinsics.checkNotNullParameter((Object)ruleProvider, (String)"ruleProvider");
        return this.isRuleEnabled(ruleProvider.createNewRuleInstance());
    }

    private final boolean isRuleEnabled(Rule rule) {
        boolean bl;
        RuleExecution ruleExecution = this.ruleExecution(RuleExecutionEditorConfigPropertyKt.ktLintRuleExecutionPropertyName((RuleId)rule.getRuleId()));
        if (ruleExecution != null) {
            RuleExecution it = ruleExecution;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)rule.getRuleId(), (Object)KtlintSuppressionRuleKt.getKTLINT_SUPPRESSION_RULE_ID()) && it == RuleExecution.disabled) {
                RuleExecutionRuleFilterKt.access$getLOGGER$p().warn(() -> RuleExecutionFilter.isRuleEnabled$lambda$1$lambda$0(rule));
                bl = true;
            } else {
                bl = it == RuleExecution.enabled;
            }
        } else {
            bl = this.isRuleConditionallyEnabled(rule);
        }
        return bl;
    }

    private final boolean isRuleConditionallyEnabled(Rule rule) {
        return rule instanceof Rule.Experimental && rule instanceof Rule.OfficialCodeStyle ? this.isExperimentalEnabled(rule) && this.isOfficialCodeStyleEnabled(rule) : (rule instanceof Rule.Experimental ? this.isExperimentalEnabled(rule) : (rule instanceof Rule.OfficialCodeStyle ? this.isOfficialCodeStyleEnabled(rule) : this.isRuleSetEnabled(rule)));
    }

    private final boolean isExperimentalEnabled(Rule rule) {
        return this.ruleExecution(RuleExecutionEditorConfigPropertyKt.getEXPERIMENTAL_RULES_EXECUTION_PROPERTY().getName()) == RuleExecution.enabled && this.ruleExecution(RuleExecutionEditorConfigPropertyKt.ktLintRuleSetExecutionPropertyName((RuleSetId)rule.getRuleId().getRuleSetId())) != RuleExecution.disabled && this.ruleExecution(RuleExecutionEditorConfigPropertyKt.ktLintRuleExecutionPropertyName((RuleId)rule.getRuleId())) != RuleExecution.disabled;
    }

    private final boolean isOfficialCodeStyleEnabled(Rule rule) {
        return this.codeStyleValue == CodeStyleValue.ktlint_official && this.ruleExecution(RuleExecutionEditorConfigPropertyKt.ktLintRuleSetExecutionPropertyName((RuleSetId)rule.getRuleId().getRuleSetId())) != RuleExecution.disabled && this.ruleExecution(RuleExecutionEditorConfigPropertyKt.ktLintRuleExecutionPropertyName((RuleId)rule.getRuleId())) != RuleExecution.disabled;
    }

    private final boolean isRuleSetEnabled(Rule rule) {
        RuleExecution ruleSetExecution = this.ruleExecution(RuleExecutionEditorConfigPropertyKt.ktLintRuleSetExecutionPropertyName((RuleSetId)rule.getRuleId().getRuleSetId()));
        boolean bl = false;
        RuleExecution ruleExecution = ruleSetExecution;
        return Intrinsics.areEqual((Object)(ruleExecution != null ? ruleExecution.name() : null), (Object)RuleExecutionEditorConfigPropertyKt.getEXPERIMENTAL_RULES_EXECUTION_PROPERTY().getName()) ? ruleSetExecution == RuleExecution.enabled : ruleSetExecution != RuleExecution.disabled;
    }

    private final RuleExecution ruleExecution(String ruleExecutionPropertyName) {
        return this.ruleExecutionProperties.get(ruleExecutionPropertyName);
    }

    private static final Object isRuleEnabled$lambda$1$lambda$0(Rule $rule) {
        return "Rule '" + $rule.getRuleId().getValue() + "' can not be disabled via the '.editorconfig'";
    }
}

