/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.experimental;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.DefaultEditorConfigProperties;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiCommentImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;

@Metadata(mv={1, 7, 1}, k=1, xi=80, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004Ji\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u000e\u0010\u0014\u001a\u00020\u0011*\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0007H\u0002Ji\u0010\u0017\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\f\u0010\u0018\u001a\u00020\u0006*\u00020\u0007H\u0002Jc\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00112K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00060\nR\u001b\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/pinterest/ktlint/ruleset/experimental/CommentWrappingRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "<init>", "()V", "followsBlockCommentOnSameLine", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "blockCommentNode", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "autoCorrect", "isLastElementOnLine", "isNonIndentLeafOnSameLine", "it", "precedesBlockCommentOnSameLine", "replaceWithEndOfLineComment", "visit", "node", "editorConfigProperties", "", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "ktlint-ruleset-experimental"})
public final class CommentWrappingRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    private final List<UsesEditorConfigProperties.EditorConfigProperty<?>> editorConfigProperties;

    public CommentWrappingRule() {
        super("experimental:comment-wrapping", null, 2, null);
        Object[] objectArray = new UsesEditorConfigProperties.EditorConfigProperty[]{DefaultEditorConfigProperties.INSTANCE.getIndentSizeProperty(), DefaultEditorConfigProperties.INSTANCE.getIndentStyleProperty()};
        this.editorConfigProperties = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<UsesEditorConfigProperties.EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    public final void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) {
            ASTNode nonIndentLeafOnSameLineFollowingBlockComment;
            Object object;
            Object object2;
            ASTNode aSTNode;
            ASTNode aSTNode2 = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
            if (aSTNode2 != null) {
                ASTNode it = aSTNode = aSTNode2;
                boolean bl = false;
                object2 = this.isNonIndentLeafOnSameLine(it) ? aSTNode : null;
            } else {
                object2 = null;
            }
            ASTNode nonIndentLeafOnSameLinePrecedingBlockComment = object2;
            aSTNode = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
            if (aSTNode != null) {
                ASTNode aSTNode3;
                ASTNode it = aSTNode3 = aSTNode;
                boolean bl = false;
                object = this.isNonIndentLeafOnSameLine(it) ? aSTNode3 : null;
            } else {
                object = nonIndentLeafOnSameLineFollowingBlockComment = null;
            }
            if (nonIndentLeafOnSameLinePrecedingBlockComment != null && nonIndentLeafOnSameLineFollowingBlockComment != null) {
                if (Intrinsics.areEqual((Object)PackageKt.lineNumber((ASTNode)nonIndentLeafOnSameLinePrecedingBlockComment), (Object)PackageKt.lineNumber(nonIndentLeafOnSameLineFollowingBlockComment))) {
                    emit.invoke((Object)node.getStartOffset(), (Object)"A block comment in between other elements on the same line is disallowed", (Object)false);
                } else {
                    emit.invoke((Object)node.getStartOffset(), (Object)"A block comment starting on same line as another element and ending on another line before another element is disallowed", (Object)false);
                }
                return;
            }
            if (nonIndentLeafOnSameLinePrecedingBlockComment != null) {
                this.precedesBlockCommentOnSameLine(nonIndentLeafOnSameLinePrecedingBlockComment, node, emit, autoCorrect);
            }
            if (nonIndentLeafOnSameLineFollowingBlockComment != null) {
                this.followsBlockCommentOnSameLine(nonIndentLeafOnSameLineFollowingBlockComment, node, emit, autoCorrect);
            }
        }
    }

    private final void precedesBlockCommentOnSameLine(ASTNode $this$precedesBlockCommentOnSameLine, ASTNode blockCommentNode, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        ASTNode leafAfterBlockComment = PackageKt.nextLeaf$default((ASTNode)blockCommentNode, (boolean)false, (boolean)false, (int)3, null);
        if (!blockCommentNode.textContains('\n') && this.isLastElementOnLine(leafAfterBlockComment)) {
            emit.invoke((Object)$this$precedesBlockCommentOnSameLine.getStartOffset(), (Object)"A single line block comment after a code element on the same line must be replaced with an EOL comment", (Object)true);
            if (autoCorrect) {
                this.replaceWithEndOfLineComment(blockCommentNode);
            }
        } else {
            emit.invoke((Object)blockCommentNode.getStartOffset(), (Object)"A block comment after any other element on the same line must be separated by a new line", (Object)false);
        }
    }

    private final void replaceWithEndOfLineComment(ASTNode $this$replaceWithEndOfLineComment) {
        String string = $this$replaceWithEndOfLineComment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String content = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSurrounding((String)string, (CharSequence)"/*", (CharSequence)"*/"))).toString();
        PsiCommentImpl eolComment = new PsiCommentImpl(ElementType.INSTANCE.getEOL_COMMENT(), (CharSequence)("// " + content));
        Intrinsics.checkNotNull((Object)$this$replaceWithEndOfLineComment, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        ((LeafPsiElement)$this$replaceWithEndOfLineComment).rawInsertBeforeMe((TreeElement)eolComment);
        ((LeafPsiElement)$this$replaceWithEndOfLineComment).rawRemove();
    }

    private final void followsBlockCommentOnSameLine(ASTNode $this$followsBlockCommentOnSameLine, ASTNode blockCommentNode, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        emit.invoke((Object)$this$followsBlockCommentOnSameLine.getStartOffset(), (Object)"A block comment may not be followed by any other element on that same line", (Object)true);
        if (autoCorrect) {
            LeafElement leafElement;
            if (Intrinsics.areEqual((Object)$this$followsBlockCommentOnSameLine.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                Intrinsics.checkNotNull((Object)$this$followsBlockCommentOnSameLine, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                leafElement = ((LeafPsiElement)$this$followsBlockCommentOnSameLine).rawReplaceWithText('\n' + PackageKt.lineIndent((ASTNode)blockCommentNode));
            } else {
                Intrinsics.checkNotNull((Object)$this$followsBlockCommentOnSameLine, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                leafElement = PackageKt.upsertWhitespaceBeforeMe((LeafElement)((LeafElement)((LeafPsiElement)$this$followsBlockCommentOnSameLine)), (String)('\n' + PackageKt.lineIndent((ASTNode)blockCommentNode)));
            }
        }
    }

    private final boolean isNonIndentLeafOnSameLine(ASTNode it) {
        return !Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || !it.textContains('\n');
    }

    private final boolean isLastElementOnLine(ASTNode $this$isLastElementOnLine) {
        return $this$isLastElementOnLine == null || Intrinsics.areEqual((Object)$this$isLastElementOnLine.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && $this$isLastElementOnLine.textContains('\n');
    }

    public <T> T getEditorConfigValue(@NotNull ASTNode $this$getEditorConfigValue, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, (ASTNode)$this$getEditorConfigValue, editorConfigProperty);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty, @NotNull DefaultEditorConfigProperties.CodeStyleValue codeStyleValue) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, editorConfigProperty, (DefaultEditorConfigProperties.CodeStyleValue)codeStyleValue);
    }
}

