/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.experimental;

import com.pinterest.ktlint.core.IndentConfig;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.experimental.ContextReceiverWrappingRule;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u0011H\u0016Je\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162K\u0010\u0017\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0002Je\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162K\u0010\u0017\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002Je\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162K\u0010\u0017\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u000e0\u0018H\u0002R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/pinterest/ktlint/ruleset/experimental/ContextReceiverWrappingRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "()V", "editorConfigProperties", "", "Lcom/pinterest/ktlint/core/api/editorconfig/EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "indent", "", "maxLineLength", "", "beforeFirstNode", "", "", "Lorg/ec4j/core/model/Property;", "Lcom/pinterest/ktlint/core/api/EditorConfigProperties;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "canBeAutoCorrected", "isMaxLineLengthSet", "visitContextReceiverList", "visitContextReceiverTypeArgumentList", "ktlint-ruleset-experimental"})
@SourceDebugExtension(value={"SMAP\nContextReceiverWrappingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextReceiverWrappingRule.kt\ncom/pinterest/ktlint/ruleset/experimental/ContextReceiverWrappingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,173:1\n1#2:174\n1295#3,2:175\n1295#3,2:177\n*S KotlinDebug\n*F\n+ 1 ContextReceiverWrappingRule.kt\ncom/pinterest/ktlint/ruleset/experimental/ContextReceiverWrappingRule\n*L\n100#1:175,2\n142#1:177,2\n*E\n"})
public final class ContextReceiverWrappingRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    private final List<EditorConfigProperty<?>> editorConfigProperties;
    private String indent;
    private int maxLineLength;

    public ContextReceiverWrappingRule() {
        super("experimental:context-receiver-wrapping", null, 2, null);
        Object[] objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY(), MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY()};
        this.editorConfigProperties = CollectionsKt.listOf((Object[])objectArray);
        this.maxLineLength = -1;
    }

    @NotNull
    public List<EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    public void beforeFirstNode(@NotNull Map<String, ? extends Property> editorConfigProperties) {
        Intrinsics.checkNotNullParameter(editorConfigProperties, (String)"editorConfigProperties");
        Map<String, ? extends Property> $this$beforeFirstNode_u24lambda_u240 = editorConfigProperties;
        boolean bl = false;
        IndentConfig indentConfig = new IndentConfig((PropertyType.IndentStyleValue)this.getEditorConfigValue($this$beforeFirstNode_u24lambda_u240, IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)this.getEditorConfigValue($this$beforeFirstNode_u24lambda_u240, IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
        this.indent = indentConfig.getIndent();
        this.maxLineLength = ((Number)this.getEditorConfigValue($this$beforeFirstNode_u24lambda_u240, MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY())).intValue();
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCONTEXT_RECEIVER_LIST())) {
            this.visitContextReceiverList(node, autoCorrect, emit);
        } else if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getTYPE_ARGUMENT_LIST()) && PackageKt.isPartOf((ASTNode)node, (IElementType)ElementType.INSTANCE.getCONTEXT_RECEIVER())) {
            this.visitContextReceiverTypeArgumentList(node, autoCorrect, emit);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitContextReceiverList(ASTNode node, boolean autoCorrect, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block7: {
            void $this$forEach$iv;
            ASTNode aSTNode = PackageKt.nextLeaf((ASTNode)PackageKt.lastChildLeafOrSelf((ASTNode)node), (Function1)visitContextReceiverList.1.INSTANCE);
            if (aSTNode != null) {
                ASTNode aSTNode2;
                ASTNode aSTNode3 = aSTNode;
                ASTNode it = aSTNode3;
                boolean bl = false;
                Object object = aSTNode2 = !PackageKt.isWhiteSpaceWithNewline((ASTNode)it) ? aSTNode3 : null;
                if (aSTNode2 != null) {
                    ASTNode nodeAfterContextReceiver = aSTNode2;
                    boolean bl2 = false;
                    emit.invoke((Object)nodeAfterContextReceiver.getStartOffset(), (Object)"Expected a newline after the context receiver", (Object)true);
                    if (autoCorrect) {
                        ASTNode aSTNode4 = PackageKt.firstChildLeafOrSelf((ASTNode)nodeAfterContextReceiver);
                        StringBuilder stringBuilder = new StringBuilder().append('\n');
                        ASTNode aSTNode5 = node.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"node.treeParent");
                        PackageKt.upsertWhitespaceBeforeMe((ASTNode)aSTNode4, (String)stringBuilder.append(PackageKt.lineIndent((ASTNode)aSTNode5)).toString());
                    }
                }
            }
            if (!this.isMaxLineLengthSet() || node.textContains('\n') || PackageKt.lineIndent((ASTNode)node).length() + node.getTextLength() <= this.maxLineLength) break block7;
            aSTNode = SequencesKt.filter((Sequence)PackageKt.children((ASTNode)node), (Function1)visitContextReceiverList.4.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode aSTNode6;
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                emit.invoke((Object)it.getStartOffset(), (Object)"Newline expected before context receiver as max line length is violated", (Object)true);
                if (!autoCorrect || (aSTNode6 = PackageKt.prevLeaf((ASTNode)it, (boolean)true)) == null) continue;
                StringBuilder stringBuilder = new StringBuilder().append('\n').append(PackageKt.lineIndent((ASTNode)node));
                String string = this.indent;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indent");
                    string = null;
                }
                PackageKt.upsertWhitespaceAfterMe((ASTNode)aSTNode6, (String)stringBuilder.append(string).toString());
            }
            aSTNode = node.findChildByType(ElementType.INSTANCE.getRPAR());
            if (aSTNode != null) {
                ASTNode rpar = aSTNode;
                boolean bl = false;
                emit.invoke((Object)rpar.getStartOffset(), (Object)"Newline expected before closing parenthesis as max line length is violated", (Object)true);
                if (autoCorrect) {
                    PackageKt.upsertWhitespaceBeforeMe((ASTNode)rpar, (String)('\n' + PackageKt.lineIndent((ASTNode)node)));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitContextReceiverTypeArgumentList(ASTNode node, boolean autoCorrect, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block5: {
            void $this$forEach$iv;
            String string = node.getTreeParent().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treeParent.text");
            String contextReceiver = string;
            if (!this.isMaxLineLengthSet() || StringsKt.contains$default((CharSequence)contextReceiver, (char)'\n', (boolean)false, (int)2, null) || PackageKt.lineIndent((ASTNode)node).length() + contextReceiver.length() <= this.maxLineLength) break block5;
            Sequence sequence = SequencesKt.filter((Sequence)PackageKt.children((ASTNode)node), (Function1)visitContextReceiverTypeArgumentList.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                emit.invoke((Object)it.getStartOffset(), (Object)"Newline expected before context receiver type projection as max line length is violated", (Object)true);
                if (!autoCorrect) continue;
                StringBuilder stringBuilder = new StringBuilder().append('\n').append(PackageKt.lineIndent((ASTNode)node));
                String string2 = this.indent;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"indent");
                    string2 = null;
                }
                PackageKt.upsertWhitespaceBeforeMe((ASTNode)it, (String)stringBuilder.append(string2).toString());
            }
            sequence = node.findChildByType(ElementType.INSTANCE.getGT());
            if (sequence != null) {
                Sequence gt = sequence;
                boolean bl = false;
                emit.invoke((Object)gt.getStartOffset(), (Object)"Newline expected before closing angle bracket as max line length is violated", (Object)true);
                if (autoCorrect) {
                    StringBuilder stringBuilder = new StringBuilder().append('\n').append(PackageKt.lineIndent((ASTNode)node));
                    String string3 = this.indent;
                    if (string3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"indent");
                        string3 = null;
                    }
                    PackageKt.upsertWhitespaceBeforeMe((ASTNode)gt, (String)stringBuilder.append(string3).toString());
                }
            }
        }
    }

    private final boolean isMaxLineLengthSet() {
        return this.maxLineLength > -1;
    }

    public <T> T getEditorConfigValue(@NotNull Map<String, ? extends Property> $this$getEditorConfigValue, @NotNull EditorConfigProperty<T> editorConfigProperty) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, $this$getEditorConfigValue, editorConfigProperty);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull EditorConfigProperty<T> editorConfigProperty, @NotNull CodeStyleValue codeStyleValue) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, editorConfigProperty, (CodeStyleValue)codeStyleValue);
    }
}

