/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003Je\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2K\u0010\r\u001aG\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\b0\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/FilenameRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/Rule$Modifier$RestrictToRoot;", "()V", "ignoreSet", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class FilenameRule
extends Rule
implements Rule.Modifier.RestrictToRoot {
    private final Set<IElementType> ignoreSet = SetsKt.setOf((Object[])new IElementType[]{ElementType.INSTANCE.getFILE_ANNOTATION_LIST(), ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getIMPORT_LIST(), ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getEOL_COMMENT(), ElementType.INSTANCE.getBLOCK_COMMENT(), ElementType.INSTANCE.getKDOC(), ElementType.INSTANCE.getSHEBANG_COMMENT()});

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        String filePath;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        String string = filePath = (String)node.getUserData(KtLint.INSTANCE.getFILE_PATH_USER_DATA_KEY());
        if (string == null || !StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) {
            return;
        }
        String type = null;
        String className = null;
        ASTNode[] aSTNodeArray = node.getChildren(null);
        int n = aSTNodeArray.length;
        for (int i = 0; i < n; ++i) {
            ASTNode el;
            ASTNode aSTNode = el = aSTNodeArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"el");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getCLASS()) || Intrinsics.areEqual((Object)el.getElementType(), (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) || Intrinsics.areEqual((Object)el.getElementType(), (Object)ElementType.INSTANCE.getTYPEALIAS())) {
                if (className != null) {
                    return;
                }
                ASTNode id = el.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
                ASTNode aSTNode2 = id;
                type = aSTNode2 != null && (aSTNode2 = PackageKt.prevCodeSibling((ASTNode)aSTNode2)) != null ? aSTNode2.getText() : null;
                ASTNode aSTNode3 = id;
                className = aSTNode3 != null ? aSTNode3.getText() : null;
                continue;
            }
            if (this.ignoreSet.contains(el.getElementType())) continue;
            return;
        }
        if (className != null) {
            String unescapedClassName = StringsKt.replace$default((String)className, (String)"`", (String)"", (boolean)false, (int)4, null);
            Path path = Paths.get(filePath, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(filePath)");
            String name = StringsKt.substringBefore$default((String)((Object)path.getFileName()).toString(), (String)".", null, (int)2, null);
            if (Intrinsics.areEqual((Object)name, (Object)"package") ^ true && Intrinsics.areEqual((Object)name, (Object)unescapedClassName) ^ true) {
                emit.invoke((Object)0, (Object)(type + ' ' + className + " should be declared in a file named " + unescapedClassName + ".kt"), (Object)false);
            }
        }
    }

    public FilenameRule() {
        super("filename");
    }
}

