/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u000f\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\n0\u0010H\u0016J\f\u0010\u0018\u001a\u00020\u000e*\u00020\fH\u0002J\f\u0010\u0019\u001a\u00020\u000e*\u00020\fH\u0002J\f\u0010\u001a\u001a\u00020\u000e*\u00020\fH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ChainWrappingRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "nextLineTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "noSpaceAroundTokens", "prefixTokens", "sameLineTokens", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isInPrefixPosition", "isPartOfSpread", "isPartOfWhenCondition", "ktlint-ruleset-standard"})
public final class ChainWrappingRule
extends Rule {
    @NotNull
    private final TokenSet sameLineTokens;
    @NotNull
    private final TokenSet prefixTokens;
    @NotNull
    private final TokenSet nextLineTokens;
    @NotNull
    private final TokenSet noSpaceAroundTokens;

    public ChainWrappingRule() {
        super("chain-wrapping");
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getMUL(), ElementType.INSTANCE.getDIV(), ElementType.INSTANCE.getPERC(), ElementType.INSTANCE.getANDAND(), ElementType.INSTANCE.getOROR()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"create(MUL, DIV, PERC, ANDAND, OROR)");
        this.sameLineTokens = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getPLUS(), ElementType.INSTANCE.getMINUS()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"create(PLUS, MINUS)");
        this.prefixTokens = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS(), ElementType.INSTANCE.getELVIS()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"create(DOT, SAFE_ACCESS, ELVIS)");
        this.nextLineTokens = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"create(DOT, SAFE_ACCESS)");
        this.noSpaceAroundTokens = tokenSet;
    }

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType elementType = iElementType;
        if (this.nextLineTokens.contains(elementType)) {
            if (PackageKt.isPartOfComment((ASTNode)node)) {
                return;
            }
            ASTNode aSTNode = PackageKt.nextCodeLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
            ASTNode nextLeaf = aSTNode == null ? null : PackageKt.prevLeaf$default((ASTNode)aSTNode, (boolean)false, (int)1, null);
            aSTNode = nextLeaf;
            if (Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && nextLeaf.textContains('\n')) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not end with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNode prevLeaf2 = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
                    if (prevLeaf2 instanceof PsiWhiteSpace) {
                        ((PsiWhiteSpace)prevLeaf2).getNode().getTreeParent().removeChild(((PsiWhiteSpace)prevLeaf2).getNode());
                    }
                    if (!this.noSpaceAroundTokens.contains(elementType)) {
                        if (nextLeaf == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                        }
                        PackageKt.upsertWhitespaceAfterMe((LeafElement)((LeafElement)nextLeaf), (String)" ");
                    }
                    node.getTreeParent().removeChild(node);
                    if (nextLeaf == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                    }
                    ((LeafElement)nextLeaf).rawInsertAfterMe((TreeElement)((LeafElement)node));
                }
            }
        } else if (this.sameLineTokens.contains(elementType) || this.prefixTokens.contains(elementType)) {
            if (PackageKt.isPartOfComment((ASTNode)node)) {
                return;
            }
            ASTNode prevLeaf3 = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
            ASTNode prevLeaf2 = prevLeaf3;
            if (!(!Intrinsics.areEqual((Object)(prevLeaf2 == null ? null : prevLeaf2.getElementType()), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || !prevLeaf3.textContains('\n') || Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getMUL()) && this.isPartOfSpread(prevLeaf3) || this.prefixTokens.contains(elementType) && this.isInPrefixPosition(node) || this.isPartOfWhenCondition(node))) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not begin with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNode aSTNode;
                    ASTNode nextLeaf = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
                    if (nextLeaf instanceof PsiWhiteSpace) {
                        ((PsiWhiteSpace)nextLeaf).getNode().getTreeParent().removeChild(((PsiWhiteSpace)nextLeaf).getNode());
                    }
                    if ((aSTNode = PackageKt.prevCodeLeaf$default((ASTNode)prevLeaf3, (boolean)false, (int)1, null)) == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement insertionPoint = (LeafPsiElement)aSTNode;
                    node.getTreeParent().removeChild(node);
                    insertionPoint.rawInsertAfterMe((TreeElement)((LeafPsiElement)node));
                    if (!this.noSpaceAroundTokens.contains(elementType)) {
                        PackageKt.upsertWhitespaceAfterMe((LeafElement)((LeafElement)insertionPoint), (String)" ");
                    }
                }
            }
        }
    }

    private final boolean isPartOfSpread(ASTNode $this$isPartOfSpread) {
        Boolean bl;
        ASTNode aSTNode = PackageKt.prevCodeLeaf$default((ASTNode)$this$isPartOfSpread, (boolean)false, (int)1, null);
        if (aSTNode == null) {
            bl = null;
        } else {
            ASTNode aSTNode2 = aSTNode;
            boolean bl2 = false;
            boolean bl3 = false;
            ASTNode leaf = aSTNode2;
            boolean bl4 = false;
            IElementType iElementType = leaf.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"leaf.elementType");
            IElementType type = iElementType;
            bl = Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getLPAR()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getCOMMA()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getLBRACE()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getELSE_KEYWORD()) || KtTokens.OPERATIONS.contains(type);
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    private final boolean isInPrefixPosition(ASTNode $this$isInPrefixPosition) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = $this$isInPrefixPosition.getTreeParent();
        return Intrinsics.areEqual(aSTNode2 == null ? null : ((aSTNode = aSTNode2.getTreeParent()) == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getPREFIX_EXPRESSION());
    }

    private final boolean isPartOfWhenCondition(ASTNode $this$isPartOfWhenCondition) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = $this$isPartOfWhenCondition.getTreeParent();
        ASTNode aSTNode3 = aSTNode = aSTNode2 == null ? null : aSTNode2.getTreeParent();
        return Intrinsics.areEqual(aSTNode == null ? null : ((aSTNode2 = aSTNode.getTreeParent()) == null ? null : aSTNode2.getElementType()), (Object)ElementType.INSTANCE.getWHEN_CONDITION_WITH_EXPRESSION());
    }
}

