/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.PackageKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/CommentSpacingRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class CommentSpacingRule
extends Rule {
    public CommentSpacingRule() {
        super("comment-spacing");
    }

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (node instanceof PsiComment && node instanceof LeafPsiElement) {
            String string = node.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.getText()");
            if (StringsKt.startsWith$default((String)string, (String)"//", (boolean)false, (int)2, null)) {
                ASTNode prevLeaf2 = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
                if (!(prevLeaf2 instanceof PsiWhiteSpace) && prevLeaf2 instanceof LeafPsiElement) {
                    emit.invoke((Object)((LeafPsiElement)node).getStartOffset(), (Object)"Missing space before //", (Object)true);
                    if (autoCorrect) {
                        PackageKt.upsertWhitespaceBeforeMe((LeafElement)((LeafElement)node), (String)" ");
                    }
                }
                String string2 = node.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.getText()");
                String text = string2;
                if (!(text.length() == 2 || StringsKt.startsWith$default((String)text, (String)"// ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"//noinspection", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"//region", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"//endregion", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"//language=", (boolean)false, (int)2, null))) {
                    emit.invoke((Object)((LeafPsiElement)node).getStartOffset(), (Object)"Missing space after //", (Object)true);
                    if (autoCorrect) {
                        ((LeafPsiElement)node).rawReplaceWithText(Intrinsics.stringPlus((String)"// ", (Object)StringsKt.removePrefix((String)text, (CharSequence)"//")));
                    }
                }
            }
        }
    }
}

