/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.ImportOrderingRule;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.ImportLayoutParserKt;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.ImportSorter;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.PatternEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002Je\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000e2K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110!\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\"\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\u00180\u001cH\u0016J*\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u0005*\u0012\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020&0%j\u0002`'2\u0006\u0010(\u001a\u00020\u000eH\u0002R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ImportOrderingRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "()V", "editorConfigProperties", "", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "importSorter", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/ImportSorter;", "importsLayout", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/PatternEntry;", "hasTooMuchWhitespace", "", "nodes", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "([Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)Z", "importsAreEqual", "actual", "expected", "isCustomLayout", "visit", "", "node", "autoCorrect", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "resolveImportsLayout", "", "Lorg/ec4j/core/model/Property;", "Lcom/pinterest/ktlint/core/api/EditorConfigProperties;", "android", "Companion", "ktlint-ruleset-standard"})
public final class ImportOrderingRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private List<PatternEntry> importsLayout;
    private ImportSorter importSorter;
    @NotNull
    private final List<UsesEditorConfigProperties.EditorConfigProperty<?>> editorConfigProperties;
    @NotNull
    public static final String KTLINT_CUSTOM_IMPORTS_LAYOUT_PROPERTY_NAME = "kotlin_imports_layout";
    @NotNull
    public static final String IDEA_IMPORTS_LAYOUT_PROPERTY_NAME = "ij_kotlin_imports_layout";
    @NotNull
    private static final String PROPERTY_DESCRIPTION = "Defines imports order layout for Kotlin files";
    @NotNull
    private static final List<PatternEntry> ASCII_PATTERN = ImportLayoutParserKt.parseImportsLayout("*");
    @NotNull
    private static final List<PatternEntry> IDEA_PATTERN = ImportLayoutParserKt.parseImportsLayout("*,java.**,javax.**,kotlin.**,^");
    @NotNull
    private static final String IDEA_ERROR_MESSAGE = "Imports must be ordered in lexicographic order without any empty lines in-between with \"java\", \"javax\", \"kotlin\" and aliases in the end";
    @NotNull
    private static final String ASCII_ERROR_MESSAGE = "Imports must be ordered in lexicographic order without any empty lines in-between";
    @NotNull
    private static final String CUSTOM_ERROR_MESSAGE = "Imports must be ordered according to the pattern specified in .editorconfig";
    @NotNull
    private static final Map<List<PatternEntry>, String> errorMessages;
    @NotNull
    private static final Function2<String, String, PropertyType.PropertyValue<List<PatternEntry>>> editorConfigPropertyParser;
    @NotNull
    private static final UsesEditorConfigProperties.EditorConfigProperty<List<PatternEntry>> ktlintCustomImportsLayoutProperty;
    @NotNull
    private static final UsesEditorConfigProperties.EditorConfigProperty<List<PatternEntry>> ideaImportsLayoutProperty;

    public ImportOrderingRule() {
        super("import-ordering");
        Object[] objectArray = new UsesEditorConfigProperties.EditorConfigProperty[]{Companion.getKtlintCustomImportsLayoutProperty$ktlint_ruleset_standard(), Companion.getIdeaImportsLayoutProperty()};
        this.editorConfigProperties = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<UsesEditorConfigProperties.EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (PackageKt.isRoot((ASTNode)node)) {
            List<PatternEntry> editorConfig;
            Object object = (Boolean)node.getUserData(KtLint.INSTANCE.getANDROID_USER_DATA_KEY());
            Boolean bl = object == null ? Boolean.valueOf(false) : object;
            boolean android = bl;
            Map map = (Map)node.getUserData(KtLint.INSTANCE.getEDITOR_CONFIG_PROPERTIES_USER_DATA_KEY());
            if (map == null) {
                Intrinsics.throwNpe();
            }
            if ((object = (this.importsLayout = this.resolveImportsLayout((Map<String, ? extends Property>)((Object)(editorConfig = (object = map))), android))) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
                throw null;
            }
            this.importSorter = new ImportSorter((List<PatternEntry>)object);
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_LIST())) {
            ASTNode[] children = node.getChildren(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)children, (String)"children");
            ASTNode[] editorConfig = children;
            boolean bl = false;
            ASTNode[] aSTNodeArray = editorConfig;
            boolean bl2 = false;
            if (!(aSTNodeArray.length == 0)) {
                boolean canAutoCorrect;
                ASTNode current;
                void $this$fold$iv;
                ASTNode aSTNode;
                List imports;
                ASTNode it;
                block27: {
                    ASTNode element$iv$iv;
                    int n;
                    void $this$filterTo$iv$iv22;
                    ASTNode[] $this$filter$iv = children;
                    boolean $i$f$filter22 = false;
                    ASTNode[] aSTNodeArray2 = $this$filter$iv;
                    ASTNode[] destination$iv$iv22 = (ASTNode[])new ArrayList();
                    boolean $i$f$filterTo = false;
                    ASTNode[] aSTNodeArray3 = $this$filterTo$iv$iv22;
                    int n2 = aSTNodeArray3.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv$iv = aSTNodeArray3[n];
                        boolean bl3 = false;
                        boolean bl4 = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_DIRECTIVE()) || it.getPsi() instanceof PsiWhiteSpace && it.getTextLength() > 1;
                        if (!bl4) continue;
                        destination$iv$iv22.add(element$iv$iv);
                    }
                    imports = (List)destination$iv$iv22;
                    ASTNode[] $i$f$filter22 = children;
                    boolean $this$filterTo$iv$iv22 = false;
                    destination$iv$iv22 = $i$f$filter22;
                    $i$f$filterTo = false;
                    aSTNodeArray3 = destination$iv$iv22;
                    n2 = aSTNodeArray3.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv$iv = aSTNodeArray3[n];
                        boolean bl5 = false;
                        if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT()))) continue;
                        aSTNode = element$iv$iv;
                        break block27;
                    }
                    aSTNode = null;
                }
                boolean hasComments = aSTNode != null;
                ImportSorter $this$filterTo$iv$iv22 = this.importSorter;
                if ($this$filterTo$iv$iv22 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                    throw null;
                }
                Sequence sortedImports2 = SequencesKt.map((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)imports), (Function1)visit.sortedImports.1.INSTANCE), (Function1)visit.sortedImports.2.INSTANCE), (Comparator)$this$filterTo$iv$iv22), (Function1)visit.sortedImports.3.INSTANCE), (Function1)visit.sortedImports.4.INSTANCE);
                boolean destination$iv$iv22 = false;
                List sortedImportsWithSpaces = new ArrayList();
                Sequence destination$iv$iv22 = sortedImports2;
                ASTNode initial$iv = null;
                boolean $i$f$fold2 = false;
                ASTNode accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    ImportSorter importSorter;
                    Object object;
                    int n;
                    it = (ASTNode)element$iv;
                    ASTNode prev = accumulator$iv;
                    boolean bl6 = false;
                    if (prev == null) {
                        n = -1;
                    } else {
                        ImportSorter importSorter2 = this.importSorter;
                        if (importSorter2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                            throw null;
                        }
                        ImportSorter importSorter3 = importSorter2;
                        object = prev.getPsi();
                        if (object == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                        }
                        importSorter = ((KtImportDirective)object).getImportPath();
                        if (importSorter == null) {
                            Intrinsics.throwNpe();
                        }
                        importSorter2 = importSorter;
                        n = importSorter3.findImportIndex((ImportPath)importSorter2);
                    }
                    int index1 = n;
                    importSorter = this.importSorter;
                    if (importSorter == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                        throw null;
                    }
                    ImportSorter importSorter4 = importSorter;
                    PsiElement psiElement = current.getPsi();
                    if (psiElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                    }
                    object = ((KtImportDirective)psiElement).getImportPath();
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    importSorter = object;
                    int index2 = importSorter4.findImportIndex((ImportPath)importSorter);
                    boolean hasBlankLines = false;
                    int n3 = index1 + 1;
                    if (n3 < index2) {
                        do {
                            int i = n3++;
                            ImportSorter importSorter5 = this.importSorter;
                            if (importSorter5 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                                throw null;
                            }
                            if (!Intrinsics.areEqual((Object)importSorter5.getPatterns().get(i), (Object)PatternEntry.Companion.getBLANK_LINE_ENTRY())) continue;
                            hasBlankLines = true;
                            break;
                        } while (n3 < index2);
                    }
                    if (hasBlankLines) {
                        Collection collection = sortedImportsWithSpaces;
                        psiElement = new PsiWhiteSpaceImpl((CharSequence)"\n\n");
                        boolean bl7 = false;
                        collection.add(psiElement);
                    }
                    object = sortedImportsWithSpaces;
                    boolean bl8 = false;
                    object.add(current);
                    accumulator$iv = current;
                }
                boolean bl9 = canAutoCorrect = !hasComments;
                if (!this.importsAreEqual(imports, sortedImportsWithSpaces) || this.hasTooMuchWhitespace(children) && !this.isCustomLayout()) {
                    String additionalMessage = !canAutoCorrect ? " -- no autocorrection due to comments in the import list" : "";
                    List<PatternEntry> $i$f$fold2 = this.importsLayout;
                    if ($i$f$fold2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
                        throw null;
                    }
                    emit.invoke((Object)node.getStartOffset(), (Object)Intrinsics.stringPlus((String)errorMessages.getOrDefault($i$f$fold2, CUSTOM_ERROR_MESSAGE), (Object)additionalMessage), (Object)canAutoCorrect);
                    if (autoCorrect && canAutoCorrect) {
                        node.removeRange(node.getFirstChildNode(), node.getLastChildNode().getTreeNext());
                        Iterable $this$reduce$iv = sortedImportsWithSpaces;
                        boolean $i$f$reduce = false;
                        Iterator iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object accumulator$iv2 = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void next;
                            current = (ASTNode)iterator$iv.next();
                            ASTNode current2 = (ASTNode)accumulator$iv2;
                            boolean bl10 = false;
                            node.addChild(current2, null);
                            if (!(current2 instanceof PsiWhiteSpace) && !(next instanceof PsiWhiteSpace)) {
                                node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
                            }
                            accumulator$iv2 = next;
                        }
                        node.addChild((ASTNode)CollectionsKt.last((List)sortedImportsWithSpaces), null);
                    }
                }
            }
        }
    }

    private final List<PatternEntry> resolveImportsLayout(Map<String, ? extends Property> $this$resolveImportsLayout, boolean android) {
        List<PatternEntry> list;
        if ($this$resolveImportsLayout.containsKey(KTLINT_CUSTOM_IMPORTS_LAYOUT_PROPERTY_NAME)) {
            String string = "[WARNING] `kotlin_imports_layout` is deprecated! Please use `ij_kotlin_imports_layout` to ensure that the Kotlin IDE plugin and ktlint use same imports layout";
            boolean bl = false;
            System.out.println((Object)string);
            list = this.getEditorConfigValue($this$resolveImportsLayout, Companion.getKtlintCustomImportsLayoutProperty$ktlint_ruleset_standard(), android);
        } else {
            list = this.getEditorConfigValue($this$resolveImportsLayout, Companion.getIdeaImportsLayoutProperty(), android);
        }
        return list;
    }

    private final boolean importsAreEqual(List<? extends ASTNode> actual, List<? extends ASTNode> expected) {
        boolean bl;
        block4: {
            if (actual.size() != expected.size()) {
                return false;
            }
            List combined = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
            Iterable $this$all$iv = combined;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair $dstr$first$second = (Pair)element$iv;
                    boolean bl2 = false;
                    ASTNode first = (ASTNode)$dstr$first$second.component1();
                    ASTNode second = (ASTNode)$dstr$first$second.component2();
                    if (first instanceof PsiWhiteSpace && second instanceof PsiWhiteSpace ? Intrinsics.areEqual((Object)((PsiWhiteSpace)first).getText(), (Object)((PsiWhiteSpace)second).getText()) : Intrinsics.areEqual((Object)first, (Object)second)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCustomLayout() {
        List<PatternEntry> list = this.importsLayout;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
            throw null;
        }
        if (Intrinsics.areEqual(list, IDEA_PATTERN)) return false;
        list = this.importsLayout;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
            throw null;
        }
        if (Intrinsics.areEqual(list, ASCII_PATTERN)) return false;
        return true;
    }

    private final boolean hasTooMuchWhitespace(ASTNode[] nodes) {
        boolean bl;
        block1: {
            ASTNode[] $this$any$iv = nodes;
            boolean $i$f$any = false;
            ASTNode[] aSTNodeArray = $this$any$iv;
            int n = aSTNodeArray.length;
            for (int i = 0; i < n; ++i) {
                ASTNode element$iv;
                ASTNode it = element$iv = aSTNodeArray[i];
                boolean bl2 = false;
                if (!(it instanceof PsiWhiteSpace && !Intrinsics.areEqual((Object)((PsiWhiteSpace)it).getText(), (Object)"\n"))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public <T> T getEditorConfigValue(@NotNull Map<String, ? extends Property> $this$getEditorConfigValue, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> property, boolean isAndroidCodeStyle) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, $this$getEditorConfigValue, property, (boolean)isAndroidCodeStyle);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> property, boolean isAndroidCodeStyle) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, property, (boolean)isAndroidCodeStyle);
    }

    public static final /* synthetic */ List access$getIDEA_PATTERN$cp() {
        return IDEA_PATTERN;
    }

    public static final /* synthetic */ List access$getASCII_PATTERN$cp() {
        return ASCII_PATTERN;
    }

    static {
        Function2<String, String, PropertyType.PropertyValue<List<PatternEntry>>> function2 = new Function2<String, String, PropertyType.PropertyValue<List<PatternEntry>>>[]{TuplesKt.to(IDEA_PATTERN, (Object)IDEA_ERROR_MESSAGE), TuplesKt.to(ASCII_PATTERN, (Object)ASCII_ERROR_MESSAGE)};
        errorMessages = MapsKt.mapOf((Pair[])function2);
        editorConfigPropertyParser = Companion.editorConfigPropertyParser.1.INSTANCE;
        function2 = editorConfigPropertyParser;
        ktlintCustomImportsLayoutProperty = new UsesEditorConfigProperties.EditorConfigProperty(new PropertyType(KTLINT_CUSTOM_IMPORTS_LAYOUT_PROPERTY_NAME, PROPERTY_DESCRIPTION, (PropertyType.PropertyValueParser)new sam.org_ec4j_core_model_PropertyType_PropertyValueParser.0(function2), new String[0]), IDEA_PATTERN, ASCII_PATTERN, (Function1)Companion.ktlintCustomImportsLayoutProperty.1.INSTANCE);
        function2 = editorConfigPropertyParser;
        ideaImportsLayoutProperty = new UsesEditorConfigProperties.EditorConfigProperty(new PropertyType(IDEA_IMPORTS_LAYOUT_PROPERTY_NAME, PROPERTY_DESCRIPTION, (PropertyType.PropertyValueParser)new sam.org_ec4j_core_model_PropertyType_PropertyValueParser.0(function2), new String[0]), IDEA_PATTERN, ASCII_PATTERN, (Function1)Companion.ideaImportsLayoutProperty.1.INSTANCE);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R(\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00148\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ImportOrderingRule$Companion;", "", "()V", "ASCII_ERROR_MESSAGE", "", "ASCII_PATTERN", "", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/PatternEntry;", "CUSTOM_ERROR_MESSAGE", "IDEA_ERROR_MESSAGE", "IDEA_IMPORTS_LAYOUT_PROPERTY_NAME", "IDEA_PATTERN", "KTLINT_CUSTOM_IMPORTS_LAYOUT_PROPERTY_NAME", "PROPERTY_DESCRIPTION", "editorConfigPropertyParser", "Lkotlin/Function2;", "Lorg/ec4j/core/model/PropertyType$PropertyValue;", "errorMessages", "", "ideaImportsLayoutProperty", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "getIdeaImportsLayoutProperty", "()Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "ktlintCustomImportsLayoutProperty", "getKtlintCustomImportsLayoutProperty$ktlint_ruleset_standard$annotations", "getKtlintCustomImportsLayoutProperty$ktlint_ruleset_standard", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UsesEditorConfigProperties.EditorConfigProperty<List<PatternEntry>> getKtlintCustomImportsLayoutProperty$ktlint_ruleset_standard() {
            return ktlintCustomImportsLayoutProperty;
        }

        @Deprecated(message="This custom property is deprecated in favor of IDEA's default ideaImportsLayoutProperty")
        public static /* synthetic */ void getKtlintCustomImportsLayoutProperty$ktlint_ruleset_standard$annotations() {
        }

        @NotNull
        public final UsesEditorConfigProperties.EditorConfigProperty<List<PatternEntry>> getIdeaImportsLayoutProperty() {
            return ideaImportsLayoutProperty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

