/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.EditorConfig;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.IndentationRuleKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0001H\u0002\u001a\f\u0010\t\u001a\u00020\b*\u00020\u0001H\u0002\u001a\f\u0010\n\u001a\u00020\b*\u00020\u0001H\u0002\u001a\f\u0010\u000b\u001a\u00020\b*\u00020\u0001H\u0002\u001a\f\u0010\f\u001a\u00020\b*\u00020\u0001H\u0002\u001a\f\u0010\r\u001a\u00020\b*\u00020\u0001H\u0002\u001a\f\u0010\u000e\u001a\u00020\b*\u00020\u0004H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0002\u001a \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0013*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0013*\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"getFirstElementOnSameLine", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "indexOfFirst", "", "", "char", "", "isClosingQuote", "", "isFirstNonBlankElementOnLine", "isIndentBeforeClosingQuote", "isKDocIndent", "isLiteralStringTemplateEntry", "isVariableStringTemplateEntry", "isWhitespace", "repeatIndent", "Lcom/pinterest/ktlint/core/EditorConfig;", "indentLevel", "splitIndentAt", "Lkotlin/Pair;", "index", "wrongIndentChar", "ktlint-ruleset-standard"})
public final class IndentationRuleKt {
    private static final boolean isKDocIndent(ASTNode $this$isKDocIndent) {
        ASTNode aSTNode;
        String string = $this$isKDocIndent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        Character c = StringsKt.lastOrNull((CharSequence)string);
        char c2 = ' ';
        return c != null && c.charValue() == c2 ? Intrinsics.areEqual((Object)((aSTNode = PackageKt.nextLeaf$default((ASTNode)$this$isKDocIndent, (boolean)false, (boolean)false, (int)3, null)) == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK()) || Intrinsics.areEqual((Object)((aSTNode = PackageKt.nextLeaf$default((ASTNode)$this$isKDocIndent, (boolean)false, (boolean)false, (int)3, null)) == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getKDOC_END()) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIndentBeforeClosingQuote(ASTNode $this$isIndentBeforeClosingQuote) {
        if (Intrinsics.areEqual((Object)$this$isIndentBeforeClosingQuote.getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return true;
        String string = $this$isIndentBeforeClosingQuote.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        if (!StringsKt.isBlank((CharSequence)string)) return false;
        string = PackageKt.nextCodeSibling((ASTNode)$this$isIndentBeforeClosingQuote);
        if (!Intrinsics.areEqual((Object)(string == null ? null : string.getElementType()), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return false;
        return true;
    }

    private static final String repeatIndent(EditorConfig $this$repeatIndent, int indentLevel) {
        String string;
        EditorConfig.IndentStyle indentStyle = $this$repeatIndent.getIndentStyle();
        int n = WhenMappings.$EnumSwitchMapping$0[indentStyle.ordinal()];
        switch (n) {
            case 1: {
                string = StringsKt.repeat((CharSequence)" ", (int)(indentLevel * $this$repeatIndent.getIndentSize()));
                break;
            }
            case 2: {
                string = StringsKt.repeat((CharSequence)"\t", (int)indentLevel);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final Pair<Character, String> wrongIndentChar(EditorConfig $this$wrongIndentChar) {
        Pair pair;
        EditorConfig.IndentStyle indentStyle = $this$wrongIndentChar.getIndentStyle();
        int n = WhenMappings.$EnumSwitchMapping$0[indentStyle.ordinal()];
        switch (n) {
            case 1: {
                pair = new Pair((Object)Character.valueOf('\t'), (Object)"tab");
                break;
            }
            case 2: {
                pair = new Pair((Object)Character.valueOf(' '), (Object)"space");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    private static final boolean isLiteralStringTemplateEntry(ASTNode $this$isLiteralStringTemplateEntry) {
        return Intrinsics.areEqual((Object)$this$isLiteralStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY()) && !Intrinsics.areEqual((Object)$this$isLiteralStringTemplateEntry.getText(), (Object)"\n");
    }

    private static final boolean isVariableStringTemplateEntry(ASTNode $this$isVariableStringTemplateEntry) {
        return Intrinsics.areEqual((Object)$this$isVariableStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY()) || Intrinsics.areEqual((Object)$this$isVariableStringTemplateEntry.getElementType(), (Object)ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY());
    }

    private static final boolean isClosingQuote(ASTNode $this$isClosingQuote) {
        return Intrinsics.areEqual((Object)$this$isClosingQuote.getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE());
    }

    private static final boolean isFirstNonBlankElementOnLine(ASTNode $this$isFirstNonBlankElementOnLine) {
        ASTNode node = IndentationRuleKt.getFirstElementOnSameLine($this$isFirstNonBlankElementOnLine);
        while (node != null && !Intrinsics.areEqual((Object)node, (Object)$this$isFirstNonBlankElementOnLine)) {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            if (!IndentationRuleKt.isWhitespace(string)) break;
            node = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
        }
        return !Intrinsics.areEqual((Object)node, (Object)$this$isFirstNonBlankElementOnLine);
    }

    private static final boolean isWhitespace(String $this$isWhitespace) {
        boolean bl;
        block1: {
            CharSequence $this$none$iv = $this$isWhitespace;
            boolean $i$f$none = false;
            CharSequence charSequence = $this$none$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final ASTNode getFirstElementOnSameLine(ASTNode $this$getFirstElementOnSameLine) {
        ASTNode aSTNode;
        ASTNode firstLeafOnLine2 = PackageKt.prevLeaf((ASTNode)$this$getFirstElementOnSameLine, (Function1)getFirstElementOnSameLine.firstLeafOnLine.1.INSTANCE);
        return firstLeafOnLine2 == null ? $this$getFirstElementOnSameLine : ((aSTNode = PackageKt.nextLeaf$default((ASTNode)firstLeafOnLine2, (boolean)true, (boolean)false, (int)2, null)) == null ? $this$getFirstElementOnSameLine : aSTNode);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<String, String> splitIndentAt(String $this$splitIndentAt, int index) {
        int n;
        int n2;
        boolean bl;
        block4: {
            boolean bl2 = index >= 0;
            boolean bl3 = false;
            bl = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            CharSequence $this$indexOfFirst$iv = $this$splitIndentAt;
            boolean $i$f$indexOfFirst = false;
            n2 = 0;
            int n3 = $this$indexOfFirst$iv.length();
            while (n2 < n3) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl5 = false;
                if (!CharsKt.isWhitespace((char)it)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int $this$indexOfFirst$iv = n;
        bl = false;
        n2 = 0;
        int it = $this$indexOfFirst$iv;
        boolean bl6 = false;
        int firstNonWhitespaceIndex = it == -1 ? $this$splitIndentAt.length() : it;
        bl = false;
        int safeIndex = Math.min(firstNonWhitespaceIndex, index);
        String string = StringsKt.take((String)$this$splitIndentAt, (int)safeIndex);
        String string2 = $this$splitIndentAt;
        n2 = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(safeIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        return new Pair((Object)string, (Object)string4);
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfFirst(String $this$indexOfFirst, char c) {
        int n;
        block2: {
            CharSequence $this$indexOfFirst$iv = $this$indexOfFirst;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length();
            while (n2 < n3) {
                void index$iv;
                char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                boolean bl = false;
                if (it == c) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public static final /* synthetic */ String access$repeatIndent(EditorConfig $receiver, int indentLevel) {
        return IndentationRuleKt.repeatIndent($receiver, indentLevel);
    }

    public static final /* synthetic */ boolean access$isKDocIndent(ASTNode $receiver) {
        return IndentationRuleKt.isKDocIndent($receiver);
    }

    public static final /* synthetic */ Pair access$splitIndentAt(String $receiver, int index) {
        return IndentationRuleKt.splitIndentAt($receiver, index);
    }

    public static final /* synthetic */ boolean access$isIndentBeforeClosingQuote(ASTNode $receiver) {
        return IndentationRuleKt.isIndentBeforeClosingQuote($receiver);
    }

    public static final /* synthetic */ boolean access$isLiteralStringTemplateEntry(ASTNode $receiver) {
        return IndentationRuleKt.isLiteralStringTemplateEntry($receiver);
    }

    public static final /* synthetic */ boolean access$isVariableStringTemplateEntry(ASTNode $receiver) {
        return IndentationRuleKt.isVariableStringTemplateEntry($receiver);
    }

    public static final /* synthetic */ boolean access$isClosingQuote(ASTNode $receiver) {
        return IndentationRuleKt.isClosingQuote($receiver);
    }

    public static final /* synthetic */ boolean access$isFirstNonBlankElementOnLine(ASTNode $receiver) {
        return IndentationRuleKt.isFirstNonBlankElementOnLine($receiver);
    }

    public static final /* synthetic */ ASTNode access$getFirstElementOnSameLine(ASTNode $receiver) {
        return IndentationRuleKt.getFirstElementOnSameLine($receiver);
    }

    public static final /* synthetic */ Pair access$wrongIndentChar(EditorConfig $receiver) {
        return IndentationRuleKt.wrongIndentChar($receiver);
    }

    public static final /* synthetic */ int access$indexOfFirst(String $receiver, char c) {
        return IndentationRuleKt.indexOfFirst($receiver, c);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EditorConfig.IndentStyle.values().length];
            nArray[EditorConfig.IndentStyle.SPACE.ordinal()] = 1;
            nArray[EditorConfig.IndentStyle.TAB.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

