/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.internal.importordering;

import com.pinterest.ktlint.ruleset.standard.internal.importordering.ImportSorter;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.PatternEntry;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/ImportSorter;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lkotlin/Comparator;", "patterns", "", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/PatternEntry;", "(Ljava/util/List;)V", "getPatterns", "()Ljava/util/List;", "compare", "", "import1", "import2", "findImportIndex", "path", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "ktlint-ruleset-standard"})
public final class ImportSorter
implements Comparator<KtImportDirective> {
    @NotNull
    private final List<PatternEntry> patterns;

    public ImportSorter(@NotNull List<PatternEntry> patterns) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        this.patterns = patterns;
    }

    @NotNull
    public final List<PatternEntry> getPatterns() {
        return this.patterns;
    }

    @Override
    public int compare(@NotNull KtImportDirective import1, @NotNull KtImportDirective import2) {
        Intrinsics.checkNotNullParameter((Object)import1, (String)"import1");
        Intrinsics.checkNotNullParameter((Object)import2, (String)"import2");
        ImportPath importPath = import1.getImportPath();
        Intrinsics.checkNotNull((Object)importPath);
        ImportPath importPath2 = importPath;
        Intrinsics.checkNotNullExpressionValue((Object)importPath2, (String)"import1.importPath!!");
        ImportPath importPath1 = importPath2;
        Function1[] function1Array = import2.getImportPath();
        Intrinsics.checkNotNull((Object)function1Array);
        Function1[] function1Array2 = function1Array;
        Intrinsics.checkNotNullExpressionValue((Object)function1Array2, (String)"import2.importPath!!");
        Function1[] importPath22 = function1Array2;
        function1Array2 = new Function1[]{new Function1<ImportPath, Comparable<?>>(this){
            final /* synthetic */ ImportSorter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(@NotNull ImportPath importPath) {
                Intrinsics.checkNotNullParameter((Object)importPath, (String)"import");
                return this.this$0.findImportIndex(importPath);
            }
        }, compare.2.INSTANCE};
        return ComparisonsKt.compareValuesBy((Object)importPath1, (Object)importPath22, (Function1[])function1Array2);
    }

    public final int findImportIndex(@NotNull ImportPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int bestIndex = -1;
        PatternEntry bestEntryMatch = null;
        int allOtherAliasIndex = -1;
        int allOtherIndex = -1;
        Iterator<PatternEntry> iterator = this.patterns.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            PatternEntry entry = iterator.next();
            if (Intrinsics.areEqual((Object)entry, (Object)PatternEntry.Companion.getALL_OTHER_ALIAS_IMPORTS_ENTRY())) {
                allOtherAliasIndex = index;
            }
            if (Intrinsics.areEqual((Object)entry, (Object)PatternEntry.Companion.getALL_OTHER_IMPORTS_ENTRY())) {
                allOtherIndex = index;
            }
            if (!entry.isBetterMatchForPackageThan$ktlint_ruleset_standard(bestEntryMatch, path)) continue;
            bestEntryMatch = entry;
            bestIndex = index;
        }
        if (bestIndex == -1 && path.hasAlias() && allOtherAliasIndex == -1 && allOtherIndex != -1) {
            bestIndex = allOtherIndex;
        }
        return bestIndex;
    }
}

