/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.DefaultEditorConfigProperties;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.ImportOrderingRule;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.ImportLayoutParserKt;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.ImportSorter;
import com.pinterest.ktlint.ruleset.standard.internal.importordering.PatternEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=80, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004Jz\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2K\u0010\f\u001aG\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\rH\u0002\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u00020\u00072\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002Jc\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00072K\u0010\f\u001aG\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\rR\u001b\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ImportOrderingRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "<init>", "()V", "getUniqueImportsAndBlankLines", "Lkotlin/Pair;", "", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "children", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "", "([Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Lkotlin/jvm/functions/Function3;)Lkotlin/Pair;", "hasTooMuchWhitespace", "nodes", "([Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)Z", "importsAreEqual", "actual", "expected", "isCustomLayout", "visit", "node", "autoCorrect", "editorConfigProperties", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "importSorter", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/ImportSorter;", "importsLayout", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/PatternEntry;", "Companion", "ktlint-ruleset-standard"})
public final class ImportOrderingRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<UsesEditorConfigProperties.EditorConfigProperty<?>> editorConfigProperties = CollectionsKt.listOf(ideaImportsLayoutProperty);
    private List<PatternEntry> importsLayout;
    private ImportSorter importSorter;
    @NotNull
    public static final String IDEA_IMPORTS_LAYOUT_PROPERTY_NAME = "ij_kotlin_imports_layout";
    @NotNull
    private static final String PROPERTY_DESCRIPTION = "Defines imports order layout for Kotlin files";
    @NotNull
    private static final List<PatternEntry> ASCII_PATTERN = ImportLayoutParserKt.parseImportsLayout("*");
    @NotNull
    private static final List<PatternEntry> IDEA_PATTERN = ImportLayoutParserKt.parseImportsLayout("*,java.**,javax.**,kotlin.**,^");
    @NotNull
    private static final String IDEA_ERROR_MESSAGE = "Imports must be ordered in lexicographic order without any empty lines in-between with \"java\", \"javax\", \"kotlin\" and aliases in the end";
    @NotNull
    private static final String ASCII_ERROR_MESSAGE = "Imports must be ordered in lexicographic order without any empty lines in-between";
    @NotNull
    private static final String CUSTOM_ERROR_MESSAGE = "Imports must be ordered according to the pattern specified in .editorconfig";
    @NotNull
    private static final Map<List<PatternEntry>, String> errorMessages;
    @NotNull
    private static final Function2<String, String, PropertyType.PropertyValue<List<PatternEntry>>> editorConfigPropertyParser;
    @NotNull
    private static final UsesEditorConfigProperties.EditorConfigProperty<List<PatternEntry>> ideaImportsLayoutProperty;

    public ImportOrderingRule() {
        super("import-ordering", null, 2, null);
    }

    @NotNull
    public final List<UsesEditorConfigProperties.EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    private final Pair<Boolean, List<ASTNode>> getUniqueImportsAndBlankLines(ASTNode[] children, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        boolean autoCorrectDuplicateImports = false;
        List imports = new ArrayList();
        Set importTextSet = new LinkedHashSet();
        ASTNode[] $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ASTNode current;
            block4: {
                block3: {
                    ASTNode element$iv;
                    current = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    boolean isPsiWhiteSpace = current.getPsi() instanceof PsiWhiteSpace;
                    if (!Intrinsics.areEqual((Object)current.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_DIRECTIVE()) && (!isPsiWhiteSpace || current.getTextLength() <= 1)) continue;
                    if (isPsiWhiteSpace) break block3;
                    String string = current.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"current.text");
                    if (!importTextSet.add(string)) break block4;
                }
                ((Collection)imports).add(current);
                continue;
            }
            emit.invoke((Object)current.getStartOffset(), (Object)("Duplicate '" + current.getText() + "' found"), (Object)true);
            autoCorrectDuplicateImports = true;
        }
        return TuplesKt.to((Object)autoCorrectDuplicateImports, (Object)imports);
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (PackageKt.isRoot((ASTNode)node)) {
            this.importsLayout = this.getEditorConfigValue(node, ideaImportsLayoutProperty);
            List<PatternEntry> list = this.importsLayout;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
                list = null;
            }
            this.importSorter = new ImportSorter(list);
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_LIST())) {
            ASTNode[] aSTNodeArray = node.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
            ASTNode[] children = aSTNodeArray;
            if (!(children.length == 0)) {
                ASTNode current;
                void $this$fold$iv;
                boolean bl;
                List imports;
                boolean autoCorrectDuplicateImports;
                block23: {
                    Pair<Boolean, List<ASTNode>> pair = this.getUniqueImportsAndBlankLines(children, emit);
                    autoCorrectDuplicateImports = (Boolean)pair.component1();
                    imports = (List)pair.component2();
                    ASTNode[] $this$any$iv = children;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ASTNode element$iv;
                        ASTNode it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT()))) continue;
                        bl = true;
                        break block23;
                    }
                    bl = false;
                }
                boolean hasComments = bl;
                Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)imports), (Function1)visit.sortedImports.1.INSTANCE);
                ImportSorter importSorter = this.importSorter;
                if (importSorter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                    importSorter = null;
                }
                Sequence sortedImports2 = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)sequence, (Comparator)importSorter), (Function1)visit.sortedImports.2.INSTANCE);
                List sortedImportsWithSpaces = new ArrayList();
                Sequence sequence2 = sortedImports2;
                ASTNode initial$iv = null;
                boolean $i$f$fold = false;
                ASTNode accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    ImportSorter importSorter2;
                    int n;
                    ASTNode aSTNode = (ASTNode)element$iv;
                    ASTNode prev = accumulator$iv;
                    boolean bl3 = false;
                    if (prev == null) {
                        n = -1;
                    } else {
                        int index1;
                        ImportSorter importSorter3 = this.importSorter;
                        if (importSorter3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                            importSorter3 = null;
                        }
                        PsiElement psiElement = prev.getPsi();
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                        ImportPath importPath = ((KtImportDirective)psiElement).getImportPath();
                        Intrinsics.checkNotNull((Object)importPath);
                        n = index1 = importSorter3.findImportIndex(importPath);
                    }
                    if ((importSorter2 = this.importSorter) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                        importSorter2 = null;
                    }
                    PsiElement psiElement = current.getPsi();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                    ImportPath importPath = ((KtImportDirective)psiElement).getImportPath();
                    Intrinsics.checkNotNull((Object)importPath);
                    int index2 = importSorter2.findImportIndex(importPath);
                    boolean hasBlankLines = false;
                    for (int i = index1 + 1; i < index2; ++i) {
                        ImportSorter importSorter4 = this.importSorter;
                        if (importSorter4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importSorter");
                            importSorter4 = null;
                        }
                        if (!Intrinsics.areEqual((Object)importSorter4.getPatterns().get(i), (Object)PatternEntry.Companion.getBLANK_LINE_ENTRY())) continue;
                        hasBlankLines = true;
                        break;
                    }
                    if (hasBlankLines) {
                        ((Collection)sortedImportsWithSpaces).add(new PsiWhiteSpaceImpl((CharSequence)"\n\n"));
                    }
                    ((Collection)sortedImportsWithSpaces).add(current);
                    accumulator$iv = current;
                }
                if (hasComments) {
                    Integer n = node.getStartOffset();
                    StringBuilder stringBuilder = new StringBuilder();
                    List<PatternEntry> list = this.importsLayout;
                    if (list == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
                        list = null;
                    }
                    emit.invoke((Object)n, (Object)stringBuilder.append(errorMessages.getOrDefault(list, CUSTOM_ERROR_MESSAGE)).append(" -- no autocorrection due to comments in the import list").toString(), (Object)false);
                } else {
                    boolean autoCorrectSortOrder;
                    boolean autoCorrectWhitespace = this.hasTooMuchWhitespace(children) && !this.isCustomLayout();
                    boolean bl4 = autoCorrectSortOrder = !this.importsAreEqual(imports, sortedImportsWithSpaces);
                    if (autoCorrectSortOrder || autoCorrectWhitespace) {
                        Integer n = node.getStartOffset();
                        List<PatternEntry> list = this.importsLayout;
                        if (list == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
                            list = null;
                        }
                        emit.invoke((Object)n, (Object)errorMessages.getOrDefault(list, CUSTOM_ERROR_MESSAGE), (Object)true);
                    }
                    if (autoCorrect && (autoCorrectDuplicateImports || autoCorrectSortOrder || autoCorrectWhitespace)) {
                        node.removeRange(node.getFirstChildNode(), node.getLastChildNode().getTreeNext());
                        Iterable $this$reduce$iv = sortedImportsWithSpaces;
                        boolean $i$f$reduce = false;
                        Iterator iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object accumulator$iv2 = iterator$iv.next();
                        while (iterator$iv.hasNext()) {
                            void next;
                            current = (ASTNode)iterator$iv.next();
                            ASTNode current2 = (ASTNode)accumulator$iv2;
                            boolean bl5 = false;
                            node.addChild(current2, null);
                            if (!(current2 instanceof PsiWhiteSpace) && !(next instanceof PsiWhiteSpace)) {
                                node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
                            }
                            accumulator$iv2 = next;
                        }
                        node.addChild((ASTNode)CollectionsKt.last((List)sortedImportsWithSpaces), null);
                    }
                }
            }
        }
    }

    private final boolean importsAreEqual(List<? extends ASTNode> actual, List<? extends ASTNode> expected) {
        boolean bl;
        block4: {
            if (actual.size() != expected.size()) {
                return false;
            }
            List combined = CollectionsKt.zip((Iterable)actual, (Iterable)expected);
            Iterable $this$all$iv = combined;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    ASTNode first = (ASTNode)pair.component1();
                    ASTNode second = (ASTNode)pair.component2();
                    if (first instanceof PsiWhiteSpace && second instanceof PsiWhiteSpace ? Intrinsics.areEqual((Object)((PsiWhiteSpace)first).getText(), (Object)((PsiWhiteSpace)second).getText()) : Intrinsics.areEqual((Object)first, (Object)second)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCustomLayout() {
        List<PatternEntry> list = this.importsLayout;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
            list = null;
        }
        if (Intrinsics.areEqual(list, IDEA_PATTERN)) return false;
        List<PatternEntry> list2 = this.importsLayout;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"importsLayout");
            list2 = null;
        }
        if (Intrinsics.areEqual(list2, ASCII_PATTERN)) return false;
        return true;
    }

    private final boolean hasTooMuchWhitespace(ASTNode[] nodes) {
        boolean bl;
        block1: {
            ASTNode[] $this$any$iv = nodes;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                ASTNode element$iv;
                ASTNode it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it instanceof PsiWhiteSpace && !Intrinsics.areEqual((Object)((PsiWhiteSpace)it).getText(), (Object)"\n"))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public <T> T getEditorConfigValue(@NotNull ASTNode $this$getEditorConfigValue, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, (ASTNode)$this$getEditorConfigValue, editorConfigProperty);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty, @NotNull DefaultEditorConfigProperties.CodeStyleValue codeStyleValue) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, editorConfigProperty, (DefaultEditorConfigProperties.CodeStyleValue)codeStyleValue);
    }

    private static final PropertyType.PropertyValue ideaImportsLayoutProperty$lambda-6(Function2 $tmp0, String p0, String p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PropertyType.PropertyValue)$tmp0.invoke((Object)p0, (Object)p1);
    }

    public static final /* synthetic */ List access$getIDEA_PATTERN$cp() {
        return IDEA_PATTERN;
    }

    public static final /* synthetic */ List access$getASCII_PATTERN$cp() {
        return ASCII_PATTERN;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(IDEA_PATTERN, (Object)IDEA_ERROR_MESSAGE), TuplesKt.to(ASCII_PATTERN, (Object)ASCII_ERROR_MESSAGE)};
        errorMessages = MapsKt.mapOf((Pair[])pairArray);
        editorConfigPropertyParser = Companion.editorConfigPropertyParser.1.INSTANCE;
        ideaImportsLayoutProperty = new UsesEditorConfigProperties.EditorConfigProperty(new PropertyType(IDEA_IMPORTS_LAYOUT_PROPERTY_NAME, PROPERTY_DESCRIPTION, (arg_0, arg_1) -> ImportOrderingRule.ideaImportsLayoutProperty$lambda-6(editorConfigPropertyParser, arg_0, arg_1), new String[0]), IDEA_PATTERN, ASCII_PATTERN, null, (Function1)Companion.ideaImportsLayoutProperty.1.INSTANCE, 8, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=80, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ImportOrderingRule$Companion;", "", "<init>", "()V", "ASCII_ERROR_MESSAGE", "", "ASCII_PATTERN", "", "Lcom/pinterest/ktlint/ruleset/standard/internal/importordering/PatternEntry;", "CUSTOM_ERROR_MESSAGE", "IDEA_ERROR_MESSAGE", "IDEA_IMPORTS_LAYOUT_PROPERTY_NAME", "IDEA_PATTERN", "PROPERTY_DESCRIPTION", "editorConfigPropertyParser", "Lkotlin/Function2;", "Lorg/ec4j/core/model/PropertyType$PropertyValue;", "errorMessages", "", "ideaImportsLayoutProperty", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "getIdeaImportsLayoutProperty", "()Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UsesEditorConfigProperties.EditorConfigProperty<List<PatternEntry>> getIdeaImportsLayoutProperty() {
            return ideaImportsLayoutProperty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

