/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.DefaultEditorConfigProperties;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.MaxLineLengthRuleKt;
import com.pinterest.ktlint.ruleset.standard.ParsedLine;
import com.pinterest.ktlint.ruleset.standard.RangeTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={1, 7, 1}, k=1, xi=80, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002Jc\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062K\u0010\f\u001aG\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\t0\rR\u001b\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/MaxLineLengthRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "<init>", "()V", "isPartOfRawMultiLineString", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "visit", "", "node", "autoCorrect", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "editorConfigProperties", "", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "maxLineLength", "rangeTree", "Lcom/pinterest/ktlint/ruleset/standard/RangeTree;", "Companion", "ktlint-ruleset-standard"})
public final class MaxLineLengthRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<UsesEditorConfigProperties.EditorConfigProperty<?>> editorConfigProperties;
    private int maxLineLength;
    @NotNull
    private RangeTree rangeTree;
    @NotNull
    public static final String KTLINT_IGNORE_BACKTICKED_IDENTIFIER_NAME = "ktlint_ignore_back_ticked_identifier";
    @NotNull
    private static final String PROPERTY_DESCRIPTION = "Defines whether the backticked identifier (``) should be ignored";
    @NotNull
    private static final UsesEditorConfigProperties.EditorConfigProperty<Boolean> ignoreBackTickedIdentifierProperty;

    public MaxLineLengthRule() {
        Object[] objectArray = new Rule.VisitorModifier[]{(Rule.VisitorModifier)new Rule.VisitorModifier.RunAfterRule("trailing-comma", false, false), (Rule.VisitorModifier)Rule.VisitorModifier.RunAsLateAsPossible.INSTANCE};
        super("max-line-length", SetsKt.setOf((Object[])objectArray));
        objectArray = new UsesEditorConfigProperties.EditorConfigProperty[]{DefaultEditorConfigProperties.INSTANCE.getMaxLineLengthProperty(), ignoreBackTickedIdentifierProperty};
        this.editorConfigProperties = CollectionsKt.listOf((Object[])objectArray);
        this.maxLineLength = ((Number)DefaultEditorConfigProperties.INSTANCE.getMaxLineLengthProperty().getDefaultValue()).intValue();
        this.rangeTree = new RangeTree(null, 1, null);
    }

    @NotNull
    public final List<UsesEditorConfigProperties.EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (PackageKt.isRoot((ASTNode)node)) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            boolean ignoreBackTickedIdentifier = this.getEditorConfigValue(node, ignoreBackTickedIdentifierProperty);
            this.maxLineLength = ((Number)this.getEditorConfigValue(node, DefaultEditorConfigProperties.INSTANCE.getMaxLineLengthProperty())).intValue();
            if (this.maxLineLength <= 0) {
                return;
            }
            ArrayList<Integer> errorOffset = new ArrayList<Integer>();
            Iterable iterable = MaxLineLengthRuleKt.access$getElementsPerLine(node);
            boolean $i$f$filter = false;
            void var8_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                ParsedLine it = (ParsedLine)element$iv$iv;
                boolean bl = false;
                if (!(it.lineLength(ignoreBackTickedIdentifier) > this.maxLineLength)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode prevLeaf2;
                ParsedLine parsedLine = (ParsedLine)element$iv;
                boolean bl = false;
                ASTNode el = (ASTNode)CollectionsKt.last(parsedLine.getElements());
                if (PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(KDoc.class)) || this.isPartOfRawMultiLineString(el)) continue;
                if (!PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                    if (PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(KtPackageDirective.class)) || PackageKt.isPartOf((ASTNode)el, (KClass)Reflection.getOrCreateKotlinClass(KtImportDirective.class))) continue;
                    errorOffset.add(parsedLine.getOffset());
                    continue;
                }
                String string = el.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"el.text");
                if (StringsKt.startsWith$default((String)string, (String)"// ktlint-disable", (boolean)false, (int)2, null) || (prevLeaf2 = PackageKt.prevCodeSibling((ASTNode)el)) == null || prevLeaf2.getStartOffset() < parsedLine.getOffset()) continue;
                errorOffset.add(parsedLine.getOffset());
            }
            this.rangeTree = new RangeTree((List<Integer>)errorOffset);
        } else if (!this.rangeTree.isEmpty() && node.getPsi() instanceof LeafPsiElement) {
            void this_$iv;
            RangeTree.ArrayView ignoreBackTickedIdentifier = this.rangeTree.query(node.getStartOffset(), node.getStartOffset() + node.getTextLength());
            boolean $i$f$forEach = false;
            int i$iv = 0;
            while (i$iv < this_$iv.getSize()) {
                int offset = this_$iv.get(i$iv++);
                boolean bl = false;
                emit.invoke((Object)offset, (Object)("Exceeded max line length (" + this.maxLineLength + ')'), (Object)false);
            }
        }
    }

    private final boolean isPartOfRawMultiLineString(ASTNode $this$isPartOfRawMultiLineString) {
        boolean bl;
        ASTNode aSTNode = PackageKt.parent((ASTNode)$this$isPartOfRawMultiLineString, (IElementType)ElementType.INSTANCE.getSTRING_TEMPLATE(), (boolean)false);
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it.getFirstChildNode().getText(), (Object)"\"\"\"") && it.textContains('\n');
        } else {
            bl = false;
        }
        return bl;
    }

    public <T> T getEditorConfigValue(@NotNull ASTNode $this$getEditorConfigValue, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, (ASTNode)$this$getEditorConfigValue, editorConfigProperty);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull UsesEditorConfigProperties.EditorConfigProperty<T> editorConfigProperty, @NotNull DefaultEditorConfigProperties.CodeStyleValue codeStyleValue) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, editorConfigProperty, (DefaultEditorConfigProperties.CodeStyleValue)codeStyleValue);
    }

    static {
        Object[] objectArray = new String[]{"true", "false"};
        ignoreBackTickedIdentifierProperty = new UsesEditorConfigProperties.EditorConfigProperty((PropertyType)new PropertyType.LowerCasingPropertyType(KTLINT_IGNORE_BACKTICKED_IDENTIFIER_NAME, PROPERTY_DESCRIPTION, PropertyType.PropertyValueParser.BOOLEAN_VALUE_PARSER, SetsKt.setOf((Object[])objectArray)), (Object)false, null, null, null, 28, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=80, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/MaxLineLengthRule$Companion;", "", "<init>", "()V", "KTLINT_IGNORE_BACKTICKED_IDENTIFIER_NAME", "", "PROPERTY_DESCRIPTION", "ignoreBackTickedIdentifierProperty", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "", "getIgnoreBackTickedIdentifierProperty", "()Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties$EditorConfigProperty;", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UsesEditorConfigProperties.EditorConfigProperty<Boolean> getIgnoreBackTickedIdentifierProperty() {
            return ignoreBackTickedIdentifierProperty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

