/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=80, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/RangeTree;", "", "seq", "", "", "<init>", "(Ljava/util/List;)V", "isEmpty", "", "query", "Lcom/pinterest/ktlint/ruleset/standard/RangeTree$ArrayView;", "vmin", "vmax", "arr", "", "emptyArrayView", "ArrayView", "ktlint-ruleset-standard"})
public final class RangeTree {
    @NotNull
    private ArrayView emptyArrayView;
    @NotNull
    private int[] arr;

    /*
     * WARNING - void declaration
     */
    public RangeTree(@NotNull List<Integer> seq) {
        Intrinsics.checkNotNullParameter(seq, (String)"seq");
        this.emptyArrayView = new ArrayView(0, 0);
        this.arr = CollectionsKt.toIntArray((Collection)seq);
        if (!(this.arr.length == 0)) {
            int[] $this$reduce$iv = this.arr;
            boolean $i$f$reduce = false;
            if ($this$reduce$iv.length == 0) {
                throw new UnsupportedOperationException("Empty array can't be reduced.");
            }
            int accumulator$iv = $this$reduce$iv[0];
            IntIterator intIterator = new IntRange(1, ArraysKt.getLastIndex((int[])$this$reduce$iv)).iterator();
            while (intIterator.hasNext()) {
                void n;
                int index$iv = intIterator.nextInt();
                int n2 = $this$reduce$iv[index$iv];
                int p2 = accumulator$iv;
                boolean bl = false;
                if (!(p2 <= n)) {
                    boolean bl2 = false;
                    String string = "Input must be sorted";
                    throw new IllegalArgumentException(string.toString());
                }
                accumulator$iv = n;
            }
        }
    }

    public /* synthetic */ RangeTree(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @NotNull
    public final ArrayView query(int vmin, int vmax) {
        int k;
        int r = this.arr.length - 1;
        if (r == -1 || vmax < this.arr[0] || this.arr[r] < vmin) {
            return this.emptyArrayView;
        }
        int l = 0;
        while (l < r) {
            int m = (r + l) / 2;
            if (vmax < this.arr[m]) {
                r = m - 1;
                continue;
            }
            if (this.arr[m] < vmin) {
                l = m + 1;
                continue;
            }
            if (vmin <= this.arr[l]) break;
            ++l;
            r = m;
        }
        if (l > r || this.arr[l] < vmin) {
            return this.emptyArrayView;
        }
        for (k = l; k < this.arr.length && this.arr[k] < vmax; ++k) {
        }
        return new ArrayView(l, k);
    }

    public final boolean isEmpty() {
        return this.arr.length == 0;
    }

    public RangeTree() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=80, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J/\u0010\u0007\u001a\u00020\b2!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\b0\nH\u0086\b\u00f8\u0001\u0000J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/RangeTree$ArrayView;", "", "l", "", "r", "<init>", "(Lcom/pinterest/ktlint/ruleset/standard/RangeTree;II)V", "forEach", "", "cb", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "v", "get", "i", "toString", "", "size", "getSize", "()I", "ktlint-ruleset-standard"})
    public final class ArrayView {
        private int l;
        private final int r;
        private final int size;

        public ArrayView(int l, int r) {
            this.l = l;
            this.r = r;
            this.size = this.r - this.l;
        }

        public final int getSize() {
            return this.size;
        }

        public final int get(int i) {
            if (i < 0 || i >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return RangeTree.this.arr[this.l + i];
        }

        public final void forEach(@NotNull Function1<? super Integer, Unit> cb) {
            Intrinsics.checkNotNullParameter(cb, (String)"cb");
            boolean $i$f$forEach = false;
            int i = 0;
            while (i < this.getSize()) {
                cb.invoke((Object)this.get(i++));
            }
        }

        @NotNull
        public final String toString() {
            if (this.l == this.r) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder("[");
            for (int i = this.l; i < this.r; ++i) {
                sb.append(RangeTree.this.arr[i]).append(", ");
            }
            sb.replace(sb.length() - 2, sb.length(), "");
            sb.append("]");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }
    }
}

