/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.IndentConfig;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.ChainWrappingRule;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u0013j\u0002`\u0015H\u0016Je\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00120\u001cH\u0016J\f\u0010#\u001a\u00020\u001a*\u00020\u0018H\u0002J\f\u0010$\u001a\u00020\u001a*\u00020\u0018H\u0002J\f\u0010%\u001a\u00020\u001a*\u00020\u0018H\u0002R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ChainWrappingRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "()V", "editorConfigProperties", "", "Lcom/pinterest/ktlint/core/api/editorconfig/EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "indent", "", "nextLineTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "noSpaceAroundTokens", "prefixTokens", "sameLineTokens", "beforeFirstNode", "", "", "Lorg/ec4j/core/model/Property;", "Lcom/pinterest/ktlint/core/api/EditorConfigProperties;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "canBeAutoCorrected", "isElvisOperatorAndComment", "isInPrefixPosition", "isPartOfSpread", "ktlint-ruleset-standard"})
public final class ChainWrappingRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    private final List<EditorConfigProperty<?>> editorConfigProperties;
    @Nullable
    private String indent;
    @NotNull
    private final TokenSet sameLineTokens;
    @NotNull
    private final TokenSet prefixTokens;
    @NotNull
    private final TokenSet nextLineTokens;
    @NotNull
    private final TokenSet noSpaceAroundTokens;

    public ChainWrappingRule() {
        super("chain-wrapping", null, 2, null);
        Object[] objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()};
        this.editorConfigProperties = CollectionsKt.listOf((Object[])objectArray);
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getMUL(), ElementType.INSTANCE.getDIV(), ElementType.INSTANCE.getPERC(), ElementType.INSTANCE.getANDAND(), ElementType.INSTANCE.getOROR()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(MUL, DIV, PERC, ANDAND, OROR)");
        this.sameLineTokens = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getPLUS(), ElementType.INSTANCE.getMINUS()};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(PLUS, MINUS)");
        this.prefixTokens = tokenSet2;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS(), ElementType.INSTANCE.getELVIS()};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(DOT, SAFE_ACCESS, ELVIS)");
        this.nextLineTokens = tokenSet3;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS()};
        TokenSet tokenSet4 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"create(DOT, SAFE_ACCESS)");
        this.noSpaceAroundTokens = tokenSet4;
    }

    @NotNull
    public List<EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    public void beforeFirstNode(@NotNull Map<String, ? extends Property> editorConfigProperties) {
        Intrinsics.checkNotNullParameter(editorConfigProperties, (String)"editorConfigProperties");
        Map<String, ? extends Property> $this$beforeFirstNode_u24lambda_u240 = editorConfigProperties;
        boolean bl = false;
        IndentConfig indentConfig = new IndentConfig((PropertyType.IndentStyleValue)this.getEditorConfigValue($this$beforeFirstNode_u24lambda_u240, IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)this.getEditorConfigValue($this$beforeFirstNode_u24lambda_u240, IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
        this.indent = indentConfig.getIndent();
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType elementType = iElementType;
        if (this.nextLineTokens.contains(elementType)) {
            ASTNode nextLeaf2;
            if (PackageKt.isPartOfComment((ASTNode)node)) {
                return;
            }
            ASTNode aSTNode = PackageKt.nextCodeLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
            ASTNode aSTNode2 = nextLeaf2 = aSTNode != null ? PackageKt.prevLeaf$default((ASTNode)aSTNode, (boolean)false, (int)1, null) : null;
            if (PackageKt.isWhiteSpaceWithNewline((ASTNode)nextLeaf2) && !this.isElvisOperatorAndComment(node)) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not end with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getELVIS())) {
                        PackageKt.upsertWhitespaceBeforeMe((ASTNode)node, (String)('\n' + PackageKt.lineIndent((ASTNode)node) + this.indent));
                        PackageKt.upsertWhitespaceAfterMe((ASTNode)node, (String)" ");
                    } else {
                        node.getTreeParent().removeChild(node);
                        Intrinsics.checkNotNull((Object)nextLeaf2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                        ((LeafElement)nextLeaf2).rawInsertAfterMe((TreeElement)((LeafElement)node));
                    }
                }
            }
        } else if (this.sameLineTokens.contains(elementType) || this.prefixTokens.contains(elementType)) {
            ASTNode prevLeaf;
            if (PackageKt.isPartOfComment((ASTNode)node)) {
                return;
            }
            ASTNode aSTNode = prevLeaf = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
            if (!(!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || !prevLeaf.textContains('\n') || Intrinsics.areEqual((Object)elementType, (Object)ElementType.INSTANCE.getMUL()) && this.isPartOfSpread(prevLeaf) || this.prefixTokens.contains(elementType) && this.isInPrefixPosition(node))) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Line must not begin with \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNode nextLeaf3 = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
                    if (nextLeaf3 instanceof PsiWhiteSpace) {
                        ((PsiWhiteSpace)nextLeaf3).getNode().getTreeParent().removeChild(((PsiWhiteSpace)nextLeaf3).getNode());
                    }
                    ASTNode aSTNode3 = PackageKt.prevCodeLeaf$default((ASTNode)prevLeaf, (boolean)false, (int)1, null);
                    Intrinsics.checkNotNull((Object)aSTNode3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    LeafPsiElement insertionPoint = (LeafPsiElement)aSTNode3;
                    ((LeafPsiElement)node).getTreeParent().removeChild(node);
                    insertionPoint.rawInsertAfterMe((TreeElement)node);
                    PackageKt.upsertWhitespaceAfterMe((ASTNode)((ASTNode)insertionPoint), (String)" ");
                }
            }
        }
    }

    private final boolean isPartOfSpread(ASTNode $this$isPartOfSpread) {
        boolean bl;
        ASTNode aSTNode = PackageKt.prevCodeLeaf$default((ASTNode)$this$isPartOfSpread, (boolean)false, (int)1, null);
        if (aSTNode != null) {
            ASTNode leaf = aSTNode;
            boolean bl2 = false;
            IElementType iElementType = leaf.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"leaf.elementType");
            IElementType type = iElementType;
            bl = Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getLPAR()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getCOMMA()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getLBRACE()) || Intrinsics.areEqual((Object)type, (Object)ElementType.INSTANCE.getELSE_KEYWORD()) || KtTokens.OPERATIONS.contains(type);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isInPrefixPosition(ASTNode $this$isInPrefixPosition) {
        ASTNode aSTNode = $this$isInPrefixPosition.getTreeParent();
        return Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getPREFIX_EXPRESSION());
    }

    private final boolean isElvisOperatorAndComment(ASTNode $this$isElvisOperatorAndComment) {
        return Intrinsics.areEqual((Object)$this$isElvisOperatorAndComment.getElementType(), (Object)ElementType.INSTANCE.getELVIS()) && SequencesKt.any((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.leaves$default((ASTNode)$this$isElvisOperatorAndComment, (boolean)false, (int)1, null), (Function1)isElvisOperatorAndComment.1.INSTANCE));
    }

    public <T> T getEditorConfigValue(@NotNull Map<String, ? extends Property> $this$getEditorConfigValue, @NotNull EditorConfigProperty<T> editorConfigProperty) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, $this$getEditorConfigValue, editorConfigProperty);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull EditorConfigProperty<T> editorConfigProperty, @NotNull CodeStyleValue codeStyleValue) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, editorConfigProperty, (CodeStyleValue)codeStyleValue);
    }
}

