/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.IndentConfig;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.ParameterListWrappingRule$hasTypeParameterListInFront$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0012H\u0016Je\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000e0\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Je\u0010 \u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002Je\u0010!\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002Jm\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00152K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010%\u001a\u00020\u0017*\u00020\u0015H\u0002J\f\u0010&\u001a\u00020\u0017*\u00020\u0015H\u0002J\f\u0010'\u001a\u00020\u0017*\u00020\u0015H\u0002R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ParameterListWrappingRule;", "Lcom/pinterest/ktlint/core/Rule;", "Lcom/pinterest/ktlint/core/api/UsesEditorConfigProperties;", "()V", "editorConfigProperties", "", "Lcom/pinterest/ktlint/core/api/editorconfig/EditorConfigProperty;", "getEditorConfigProperties", "()Ljava/util/List;", "indentConfig", "Lcom/pinterest/ktlint/core/IndentConfig;", "maxLineLength", "", "beforeFirstNode", "", "", "", "Lorg/ec4j/core/model/Property;", "Lcom/pinterest/ktlint/core/api/EditorConfigProperties;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "canBeAutoCorrected", "getNewIndentLevel", "wrapNullableType", "wrapParameterList", "wrapParemeterInList", "newIndentLevel", "child", "exceedsMaxLineLength", "hasTypeParameterListInFront", "needToWrapParameterList", "ktlint-ruleset-standard"})
public final class ParameterListWrappingRule
extends Rule
implements UsesEditorConfigProperties {
    @NotNull
    private final List<EditorConfigProperty<?>> editorConfigProperties;
    @NotNull
    private IndentConfig indentConfig;
    private int maxLineLength;

    public ParameterListWrappingRule() {
        super("parameter-list-wrapping", null, 2, null);
        Object[] objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY(), MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY()};
        this.editorConfigProperties = CollectionsKt.listOf((Object[])objectArray);
        this.indentConfig = IndentConfig.Companion.getDEFAULT_INDENT_CONFIG();
        this.maxLineLength = -1;
    }

    @NotNull
    public List<EditorConfigProperty<?>> getEditorConfigProperties() {
        return this.editorConfigProperties;
    }

    public void beforeFirstNode(@NotNull Map<String, ? extends Property> editorConfigProperties) {
        Intrinsics.checkNotNullParameter(editorConfigProperties, (String)"editorConfigProperties");
        this.maxLineLength = ((Number)this.getEditorConfigValue(editorConfigProperties, MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY())).intValue();
        this.indentConfig = new IndentConfig((PropertyType.IndentStyleValue)this.getEditorConfigValue(editorConfigProperties, IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)this.getEditorConfigValue(editorConfigProperties, IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
        if (this.indentConfig.getDisabled()) {
            this.stopTraversalOfAST();
        }
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getNULLABLE_TYPE())) {
            this.wrapNullableType(node, emit, autoCorrect);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST()) && this.needToWrapParameterList(node)) {
            this.wrapParameterList(node, emit, autoCorrect);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void wrapNullableType(ASTNode node, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode aSTNode3;
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getNULLABLE_TYPE())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ASTNode it = aSTNode3 = node;
        boolean bl = false;
        Object object = aSTNode2 = !(this.maxLineLength <= 0 || PackageKt.getColumn((ASTNode)node) - 1 + node.getTextLength() <= this.maxLineLength) ? aSTNode3 : null;
        if (aSTNode2 != null && (aSTNode3 = aSTNode2.findChildByType(ElementType.INSTANCE.getFUNCTION_TYPE())) != null && (aSTNode = aSTNode3.findChildByType(ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) != null) {
            ASTNode aSTNode4;
            ASTNode aSTNode5;
            ASTNode it2 = aSTNode5 = aSTNode;
            boolean bl2 = false;
            Object object2 = aSTNode4 = it2.findChildByType(ElementType.INSTANCE.getVALUE_PARAMETER()) != null ? aSTNode5 : null;
            if (aSTNode4 != null) {
                ASTNode aSTNode6;
                ASTNode it3 = aSTNode6 = aSTNode4;
                boolean bl3 = false;
                Object object3 = aSTNode5 = !it3.textContains('\n') ? aSTNode6 : null;
                if (aSTNode5 != null) {
                    void $this$forEach$iv;
                    it3 = aSTNode5;
                    boolean bl4 = false;
                    Sequence sequence = PsiUtilsKt.children((ASTNode)node);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ASTNode it4 = (ASTNode)element$iv;
                        boolean bl5 = false;
                        IElementType iElementType = it4.getElementType();
                        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
                            emit.invoke((Object)it4.getStartOffset(), (Object)"Parameter of nullable type should be on a separate line (unless the type fits on a single line)", (Object)true);
                            if (!autoCorrect) continue;
                            PackageKt.upsertWhitespaceAfterMe((ASTNode)it4, (String)('\n' + this.indentConfig.getIndent()));
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) continue;
                        emit.invoke((Object)it4.getStartOffset(), (Object)this.errorMessage(it4), (Object)true);
                        if (!autoCorrect) continue;
                        PackageKt.upsertWhitespaceBeforeMe((ASTNode)it4, (String)"\n");
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needToWrapParameterList(ASTNode $this$needToWrapParameterList) {
        ASTNode aSTNode = $this$needToWrapParameterList.getFirstChildNode();
        if (Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeNext()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getRPAR())) return false;
        ASTNode aSTNode2 = $this$needToWrapParameterList.getTreeParent();
        if (Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) return false;
        if (Intrinsics.areEqual((Object)$this$needToWrapParameterList.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_TYPE())) {
            ASTNode aSTNode3 = $this$needToWrapParameterList.getTreeParent();
            if (Intrinsics.areEqual((Object)(aSTNode3 != null && (aSTNode3 = aSTNode3.getTreeParent()) != null ? aSTNode3.getElementType() : null), (Object)ElementType.INSTANCE.getNULLABLE_TYPE())) return false;
        }
        if ($this$needToWrapParameterList.textContains('\n')) return true;
        if (!this.exceedsMaxLineLength($this$needToWrapParameterList)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void wrapParameterList(ASTNode node, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        void $this$forEach$iv;
        int newIndentLevel = this.getNewIndentLevel(node);
        Sequence sequence = PsiUtilsKt.children((ASTNode)node);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode child = (ASTNode)element$iv;
            boolean bl = false;
            this.wrapParemeterInList(newIndentLevel, child, emit, autoCorrect);
        }
    }

    private final int getNewIndentLevel(ASTNode node) {
        int currentIndentLevel = this.indentConfig.indentLevelFrom(PackageKt.lineIndent((ASTNode)node));
        return currentIndentLevel > 0 && this.hasTypeParameterListInFront(node) ? currentIndentLevel - 1 : currentIndentLevel;
    }

    private final void wrapParemeterInList(int newIndentLevel, ASTNode child, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        String indent = '\n' + StringsKt.repeat((CharSequence)this.indentConfig.getIndent(), (int)newIndentLevel);
        IElementType iElementType = child.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            ASTNode prevLeaf = PackageKt.prevLeaf$default((ASTNode)child, (boolean)false, (int)1, null);
            if (prevLeaf instanceof PsiWhiteSpace && prevLeaf.textContains('\n')) {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((PsiWhiteSpace)prevLeaf).delete();
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            String intendedIndent = Intrinsics.areEqual((Object)child.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER()) ? indent + this.indentConfig.getIndent() : indent;
            ASTNode prevLeaf = PackageKt.prevLeaf$default((ASTNode)child, (boolean)false, (int)1, null);
            if (prevLeaf instanceof PsiWhiteSpace) {
                String string = prevLeaf.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prevLeaf.getText()");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    return;
                }
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)prevLeaf).rawReplaceWithText(intendedIndent);
                }
            } else {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    child.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)intendedIndent), child);
                }
            }
        }
    }

    private final boolean exceedsMaxLineLength(ASTNode $this$exceedsMaxLineLength) {
        return this.maxLineLength > -1 && PackageKt.getColumn((ASTNode)$this$exceedsMaxLineLength) - 1 + $this$exceedsMaxLineLength.getTextLength() > this.maxLineLength && !$this$exceedsMaxLineLength.textContains('\n');
    }

    private final String errorMessage(ASTNode node) {
        String string;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            string = "Unnecessary newline before \"(\"";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER())) {
            string = "Parameter should be on a separate line (unless all parameters can fit a single line)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            string = "Missing newline before \")\"";
        } else {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTypeParameterListInFront(ASTNode $this$hasTypeParameterListInFront) {
        boolean bl;
        block9: {
            ASTNode typeParameterList;
            Object object;
            Object object2;
            ASTNode parent;
            block7: {
                parent = $this$hasTypeParameterListInFront.getTreeParent();
                if (Intrinsics.areEqual((Object)parent.getElementType(), (Object)ElementType.INSTANCE.getPRIMARY_CONSTRUCTOR())) {
                    Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"parent");
                    ASTNode $this$prevSibling$iv = parent;
                    boolean $i$f$prevSibling = false;
                    for (Object n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                        Object it = n$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getTYPE_PARAMETER_LIST())) continue;
                        object2 = n$iv;
                        break block7;
                    }
                    object2 = null;
                } else {
                    Object v1;
                    block8: {
                        Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"parent");
                        Sequence $this$firstOrNull$iv = PsiUtilsKt.children((ASTNode)parent);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ASTNode it = (ASTNode)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getTYPE_PARAMETER_LIST())) continue;
                            v1 = element$iv;
                            break block8;
                        }
                        v1 = null;
                    }
                    object2 = v1;
                }
            }
            if ((object = (typeParameterList = object2)) == null) {
                void $this$forEachDescendantOfType$iv$iv$iv$iv;
                void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                PsiElement psiElement = parent.getPsi();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parent.psi");
                PsiElement $this$collectDescendantsOfType_u24default$iv = psiElement;
                Function1 predicate$iv = hasTypeParameterListInFront$$inlined$collectDescendantsOfType$default$1.INSTANCE;
                boolean $i$f$collectDescendantsOfType = false;
                PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
                boolean $i$f$collectDescendantsOfType2 = false;
                PsiElement psiElement2 = $this$collectDescendantsOfType$iv$iv;
                Collection to$iv$iv$iv = new ArrayList();
                boolean $i$f$collectDescendantsOfTypeTo = false;
                void var15_22 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtTypeArgumentList, Unit>(predicate$iv, to$iv$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Collection $to;
                    {
                        this.$predicate = $predicate;
                        this.$to = $to;
                        super(1);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final void invoke(@NotNull PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                            this.$to.add(it);
                        }
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        PsiElement it = element;
                        boolean bl = false;
                        super.visitElement(element);
                        if (element instanceof KtTypeArgumentList) {
                            this.$action.invoke((Object)element);
                        }
                    }
                });
                KtTypeArgumentList ktTypeArgumentList = (KtTypeArgumentList)CollectionsKt.firstOrNull((List)((List)to$iv$iv$iv));
                object = ktTypeArgumentList != null ? ktTypeArgumentList.getNode() : null;
                if (object == null) {
                    return false;
                }
            }
            ASTNode typeListNode = object;
            Sequence $this$any$iv = PsiUtilsKt.children((ASTNode)typeListNode);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl4 = false;
                if (!PackageKt.isWhiteSpaceWithNewline((ASTNode)it)) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    public <T> T getEditorConfigValue(@NotNull Map<String, ? extends Property> $this$getEditorConfigValue, @NotNull EditorConfigProperty<T> editorConfigProperty) {
        return (T)UsesEditorConfigProperties.DefaultImpls.getEditorConfigValue((UsesEditorConfigProperties)this, $this$getEditorConfigValue, editorConfigProperty);
    }

    @NotNull
    public <T> String writeEditorConfigProperty(@NotNull Map<String, ? extends Property> $this$writeEditorConfigProperty, @NotNull EditorConfigProperty<T> editorConfigProperty, @NotNull CodeStyleValue codeStyleValue) {
        return UsesEditorConfigProperties.DefaultImpls.writeEditorConfigProperty((UsesEditorConfigProperties)this, $this$writeEditorConfigProperty, editorConfigProperty, (CodeStyleValue)codeStyleValue);
    }
}

