/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.NoSemicolonsRule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\u00020\b*\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u0015\u001a\u00020\b*\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/NoSemicolonsRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isNoSemicolonRequiredAfter", "doesNotRequirePreSemi", "getLastCodeLeafBeforeClosingOfClassBody", "isLastCodeLeafBeforeClosingOfClassBody", "ktlint-ruleset-standard"})
public final class NoSemicolonsRule
extends Rule {
    public NoSemicolonsRule() {
        super("no-semi", null, 2, null);
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getSEMICOLON())) {
            return;
        }
        ASTNode nextLeaf2 = PackageKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
        ASTNode prevCodeLeaf = PackageKt.prevCodeLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
        if (this.doesNotRequirePreSemi(nextLeaf2) && this.isNoSemicolonRequiredAfter(node)) {
            emit.invoke((Object)node.getStartOffset(), (Object)"Unnecessary semicolon", (Object)true);
            if (autoCorrect) {
                ASTNode prevLeaf = PackageKt.prevLeaf((ASTNode)node, (boolean)true);
                node.getTreeParent().removeChild(node);
                if (PackageKt.isWhiteSpace((ASTNode)prevLeaf) && (nextLeaf2 == null || PackageKt.isWhiteSpace((ASTNode)nextLeaf2))) {
                    ASTNode aSTNode = node.getTreeParent();
                    ASTNode aSTNode2 = prevLeaf;
                    Intrinsics.checkNotNull((Object)aSTNode2);
                    aSTNode.removeChild(aSTNode2);
                }
            }
        } else if (!(nextLeaf2 instanceof PsiWhiteSpace)) {
            ASTNode prevLeaf = PackageKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
            if (prevLeaf instanceof PsiWhiteSpace && prevLeaf.textContains('\n')) {
                return;
            }
            emit.invoke((Object)(node.getStartOffset() + 1), (Object)"Missing spacing after \";\"", (Object)true);
            if (autoCorrect) {
                PackageKt.upsertWhitespaceAfterMe((ASTNode)node, (String)" ");
            }
        }
    }

    private final boolean doesNotRequirePreSemi(ASTNode $this$doesNotRequirePreSemi) {
        if ($this$doesNotRequirePreSemi == null) {
            return true;
        }
        if ($this$doesNotRequirePreSemi instanceof PsiWhiteSpace) {
            ASTNode nextLeaf2 = PackageKt.nextLeaf((ASTNode)$this$doesNotRequirePreSemi, (Function1)doesNotRequirePreSemi.nextLeaf.1.INSTANCE);
            return nextLeaf2 == null || $this$doesNotRequirePreSemi.textContains('\n') && !Intrinsics.areEqual((Object)nextLeaf2.getElementType(), (Object)KtTokens.LBRACE);
        }
        return false;
    }

    private final boolean isNoSemicolonRequiredAfter(ASTNode node) {
        PsiElement parent;
        ASTNode aSTNode = PackageKt.prevCodeLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
        if (aSTNode == null) {
            return true;
        }
        ASTNode prevCodeLeaf = aSTNode;
        if (Intrinsics.areEqual((Object)prevCodeLeaf.getElementType(), (Object)ElementType.INSTANCE.getOBJECT_KEYWORD())) {
            return false;
        }
        ASTNode aSTNode2 = prevCodeLeaf.getTreeParent();
        Object object = parent = aSTNode2 != null ? aSTNode2.getPsi() : null;
        if (parent instanceof KtLoopExpression && !(parent instanceof KtDoWhileExpression) && ((KtLoopExpression)parent).getBody() == null) {
            return false;
        }
        if (parent instanceof KtIfExpression && ((KtIfExpression)parent).getThen() == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getENUM_ENTRY())) {
            return this.isLastCodeLeafBeforeClosingOfClassBody(node);
        }
        return true;
    }

    private final boolean isLastCodeLeafBeforeClosingOfClassBody(ASTNode $this$isLastCodeLeafBeforeClosingOfClassBody) {
        return Intrinsics.areEqual((Object)this.getLastCodeLeafBeforeClosingOfClassBody($this$isLastCodeLeafBeforeClosingOfClassBody), (Object)$this$isLastCodeLeafBeforeClosingOfClassBody);
    }

    private final ASTNode getLastCodeLeafBeforeClosingOfClassBody(ASTNode $this$getLastCodeLeafBeforeClosingOfClassBody) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        return $this$getLastCodeLeafBeforeClosingOfClassBody != null && (aSTNode2 = PackageKt.parent$default((ASTNode)$this$getLastCodeLeafBeforeClosingOfClassBody, (IElementType)ElementType.INSTANCE.getCLASS_BODY(), (boolean)false, (int)2, null)) != null && (aSTNode = PackageKt.lastChildLeafOrSelf((ASTNode)aSTNode2)) != null ? PackageKt.prevCodeLeaf$default((ASTNode)aSTNode, (boolean)false, (int)1, null) : null;
    }
}

