/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J\f\u0010\u0012\u001a\u00020\u000f*\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/SpacingAroundAngleBracketsRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "trimBeforeLastLine", "Companion", "ktlint-ruleset-standard"})
public final class SpacingAroundAngleBracketsRule
extends Rule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    @NotNull
    private static final Set<IElementType> ELEMENT_TYPES_ALLOWING_PRECEDING_WHITESPACE;

    public SpacingAroundAngleBracketsRule() {
        super("spacing-around-angle-brackets", null, 2, null);
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        ASTNode closingBracket;
        String newLineWithIndent;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getTYPE_PARAMETER_LIST()) && !Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getTYPE_ARGUMENT_LIST())) {
            return;
        }
        ASTNode openingBracket = node.getFirstChildNode();
        if (openingBracket != null) {
            ASTNode afterLeftAngle;
            ASTNode beforeLeftAngle;
            ASTNode aSTNode = beforeLeftAngle = PackageKt.prevLeaf$default((ASTNode)openingBracket, (boolean)false, (int)1, null);
            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                ASTNode aSTNode2 = PackageKt.prevLeaf$default((ASTNode)beforeLeftAngle, (boolean)false, (int)1, null);
                if (!CollectionsKt.contains((Iterable)ELEMENT_TYPES_ALLOWING_PRECEDING_WHITESPACE, (Object)(aSTNode2 != null ? aSTNode2.getElementType() : null))) {
                    emit.invoke((Object)beforeLeftAngle.getStartOffset(), (Object)"Unexpected spacing before \"<\"", (Object)true);
                    if (autoCorrect) {
                        beforeLeftAngle.getTreeParent().removeChild(beforeLeftAngle);
                    }
                }
            }
            ASTNode aSTNode3 = afterLeftAngle = PackageKt.nextLeaf$default((ASTNode)openingBracket, (boolean)false, (boolean)false, (int)3, null);
            if (Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                if (PackageKt.isWhiteSpaceWithoutNewline((ASTNode)afterLeftAngle)) {
                    emit.invoke((Object)afterLeftAngle.getStartOffset(), (Object)"Unexpected spacing after \"<\"", (Object)true);
                    if (autoCorrect) {
                        afterLeftAngle.getTreeParent().removeChild(afterLeftAngle);
                    }
                } else {
                    String string = afterLeftAngle.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"afterLeftAngle.text");
                    newLineWithIndent = this.trimBeforeLastLine(string);
                    if (autoCorrect) {
                        Intrinsics.checkNotNull((Object)afterLeftAngle, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                        ((LeafElement)afterLeftAngle).rawReplaceWithText(newLineWithIndent);
                    }
                }
            }
        }
        if ((closingBracket = node.getLastChildNode()) != null) {
            ASTNode beforeRightAngle;
            ASTNode aSTNode = beforeRightAngle = PackageKt.prevLeaf$default((ASTNode)closingBracket, (boolean)false, (int)1, null);
            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                if (PackageKt.isWhiteSpaceWithoutNewline((ASTNode)beforeRightAngle)) {
                    emit.invoke((Object)beforeRightAngle.getStartOffset(), (Object)"Unexpected spacing before \">\"", (Object)true);
                    if (autoCorrect) {
                        beforeRightAngle.getTreeParent().removeChild(beforeRightAngle);
                    }
                } else {
                    String string = beforeRightAngle.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"beforeRightAngle.text");
                    newLineWithIndent = this.trimBeforeLastLine(string);
                    if (autoCorrect) {
                        Intrinsics.checkNotNull((Object)beforeRightAngle, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                        ((LeafElement)beforeRightAngle).rawReplaceWithText(newLineWithIndent);
                    }
                }
            }
        }
    }

    private final String trimBeforeLastLine(String $this$trimBeforeLastLine) {
        String string = $this$trimBeforeLastLine.substring(StringsKt.lastIndexOf$default((CharSequence)$this$trimBeforeLastLine, (char)'\n', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return string;
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getVAL_KEYWORD(), ElementType.INSTANCE.getVAR_KEYWORD(), ElementType.INSTANCE.getFUN_KEYWORD()};
        ELEMENT_TYPES_ALLOWING_PRECEDING_WHITESPACE = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/SpacingAroundAngleBracketsRule$Companion;", "", "()V", "ELEMENT_TYPES_ALLOWING_PRECEDING_WHITESPACE", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getELEMENT_TYPES_ALLOWING_PRECEDING_WHITESPACE", "()Ljava/util/Set;", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<IElementType> getELEMENT_TYPES_ALLOWING_PRECEDING_WHITESPACE() {
            return ELEMENT_TYPES_ALLOWING_PRECEDING_WHITESPACE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

