/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.IndentConfig;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.MultilineExpressionWrapping;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\u0018\u0000 $2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016Je\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2K\u0010\u0010\u001aG\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\b0\u0011H\u0016Je\u0010\u0019\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u0010\u001aG\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\r*\u00020\rH\u0002J\f\u0010\u001b\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u001c\u001a\u00020\u000f*\u00020\rH\u0002J\u000e\u0010\u001d\u001a\u00020\u000f*\u0004\u0018\u00010\rH\u0002J\f\u0010\u001e\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u001f\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010 \u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010!\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\"\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010#\u001a\u00020\u000f*\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/MultilineExpressionWrapping;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule$Experimental;", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule$OfficialCodeStyle;", "()V", "indentConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "visitExpression", "closingParenthesisOfFunctionOrNull", "containsWhitespaceWithNewline", "isAfterArrow", "isElvisOperator", "isLambdaExpression", "isRegularStringPartWithNewline", "isRightHandSideOfBinaryExpression", "isValueArgument", "isValueInAnAssignment", "needToWrapMultilineExpression", "Companion", "ktlint-ruleset-standard"})
@SourceDebugExtension(value={"SMAP\nMultilineExpressionWrapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineExpressionWrapping.kt\ncom/pinterest/ktlint/ruleset/standard/rules/MultilineExpressionWrapping\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,198:1\n1#2:199\n1229#3,2:200\n*S KotlinDebug\n*F\n+ 1 MultilineExpressionWrapping.kt\ncom/pinterest/ktlint/ruleset/standard/rules/MultilineExpressionWrapping\n*L\n122#1:200,2\n*E\n"})
public final class MultilineExpressionWrapping
extends StandardRule
implements Rule.Experimental,
Rule.OfficialCodeStyle {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private IndentConfig indentConfig;
    @NotNull
    private static final Set<IElementType> CHAINABLE_EXPRESSION;

    public MultilineExpressionWrapping() {
        Object[] objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()};
        super("multiline-expression-wrapping", null, SetsKt.setOf((Object[])objectArray), 2, null);
        this.indentConfig = IndentConfig.Companion.getDEFAULT_INDENT_CONFIG();
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.indentConfig = new IndentConfig((PropertyType.IndentStyleValue)editorConfig.get(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)editorConfig.get(IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (CHAINABLE_EXPRESSION.contains(node.getElementType()) && (!CHAINABLE_EXPRESSION.contains(node.getTreeParent().getElementType()) || this.isRightHandSideOfBinaryExpression(node))) {
            this.visitExpression(node, emit, autoCorrect);
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) && !Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) {
            this.visitExpression(node, emit, autoCorrect);
        }
    }

    private final void visitExpression(ASTNode node, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        block4: {
            if (!this.containsWhitespaceWithNewline(node) || !this.needToWrapMultilineExpression(node)) break block4;
            ASTNode prevLeaf2 = ASTNodeExtensionKt.prevLeaf((ASTNode)node, (Function1)visitExpression.1.INSTANCE);
            boolean bl = false;
            if (prevLeaf2 != null && !prevLeaf2.textContains('\n')) {
                emit.invoke((Object)node.getStartOffset(), (Object)"A multiline expression should start on a new line", (Object)true);
                if (autoCorrect) {
                    StringBuilder stringBuilder = new StringBuilder();
                    ASTNode aSTNode = node.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node\n                   \u2026              .treeParent");
                    ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)node, (String)stringBuilder.append(ASTNodeExtensionKt.indent$default((ASTNode)aSTNode, (boolean)false, (int)1, null)).append(this.indentConfig.getIndent()).toString());
                    ASTNode aSTNode2 = ASTNodeExtensionKt.nextLeaf((ASTNode)ASTNodeExtensionKt.lastChildLeafOrSelf((ASTNode)node), (Function1)visitExpression.2.1.INSTANCE);
                    if (aSTNode2 != null) {
                        ASTNode aSTNode3;
                        ASTNode aSTNode4;
                        ASTNode it = aSTNode4 = aSTNode2;
                        boolean bl2 = false;
                        Object object = aSTNode3 = !ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)it) ? aSTNode4 : null;
                        if (aSTNode3 != null) {
                            ASTNode aSTNode5 = node.getTreeParent();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"node.treeParent");
                            ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)aSTNode3, (String)ASTNodeExtensionKt.indent$default((ASTNode)aSTNode5, (boolean)false, (int)1, null));
                        }
                    }
                }
            }
        }
    }

    private final boolean containsWhitespaceWithNewline(ASTNode $this$containsWhitespaceWithNewline) {
        boolean bl;
        block1: {
            ASTNode lastLeaf = ASTNodeExtensionKt.lastChildLeafOrSelf((ASTNode)$this$containsWhitespaceWithNewline);
            Sequence $this$any$iv = SequencesKt.takeWhile((Sequence)ASTNodeExtensionKt.leavesIncludingSelf$default((ASTNode)ASTNodeExtensionKt.firstChildLeafOrSelf((ASTNode)$this$containsWhitespaceWithNewline), (boolean)false, (int)1, null), (Function1)((Function1)new Function1<ASTNode, Boolean>(lastLeaf){
                final /* synthetic */ ASTNode $lastLeaf;
                {
                    this.$lastLeaf = $lastLeaf;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$lastLeaf);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!(ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)it) || this.isRegularStringPartWithNewline(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRegularStringPartWithNewline(ASTNode $this$isRegularStringPartWithNewline) {
        if (!Intrinsics.areEqual((Object)$this$isRegularStringPartWithNewline.getElementType(), (Object)ElementType.INSTANCE.getREGULAR_STRING_PART())) return false;
        String string = $this$isRegularStringPartWithNewline.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        if (!StringsKt.startsWith$default((String)string, (String)"\n", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean needToWrapMultilineExpression(ASTNode $this$needToWrapMultilineExpression) {
        return this.isValueInAnAssignment($this$needToWrapMultilineExpression) || this.isLambdaExpression($this$needToWrapMultilineExpression) || this.isValueArgument($this$needToWrapMultilineExpression) || this.isAfterArrow($this$needToWrapMultilineExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValueInAnAssignment(ASTNode $this$isValueInAnAssignment) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode aSTNode3 = ASTNodeExtensionKt.prevCodeSibling((ASTNode)$this$isValueInAnAssignment);
        if (aSTNode3 == null) return false;
        ASTNode it = aSTNode2 = aSTNode3;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getEQ())) {
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        ASTNode aSTNode4 = aSTNode2;
        ASTNode aSTNode5 = aSTNode4;
        if (aSTNode5 == null) return false;
        ASTNode it2 = aSTNode = aSTNode5;
        boolean bl3 = false;
        if (this.isElvisOperator(it2)) return false;
        ASTNode aSTNode6 = aSTNode;
        aSTNode2 = aSTNode6;
        if (aSTNode2 == null) return false;
        it2 = aSTNode = aSTNode2;
        boolean bl4 = false;
        ASTNode aSTNode7 = this.closingParenthesisOfFunctionOrNull(it2);
        if (ASTNodeExtensionKt.isWhiteSpaceWithNewline(aSTNode7 != null ? ASTNodeExtensionKt.prevLeaf$default((ASTNode)aSTNode7, (boolean)false, (int)1, null) : null)) return false;
        ASTNode aSTNode8 = aSTNode;
        if (aSTNode8 == null) return false;
        return true;
    }

    private final boolean isElvisOperator(ASTNode $this$isElvisOperator) {
        return $this$isElvisOperator != null && Intrinsics.areEqual((Object)$this$isElvisOperator.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE()) && Intrinsics.areEqual((Object)$this$isElvisOperator.getFirstChildNode().getElementType(), (Object)ElementType.INSTANCE.getELVIS());
    }

    private final ASTNode closingParenthesisOfFunctionOrNull(ASTNode $this$closingParenthesisOfFunctionOrNull) {
        Object object;
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode it = aSTNode2 = $this$closingParenthesisOfFunctionOrNull;
        boolean bl = false;
        Object object2 = aSTNode = Intrinsics.areEqual((Object)$this$closingParenthesisOfFunctionOrNull.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFUN()) ? aSTNode2 : null;
        if (aSTNode != null && (aSTNode2 = ASTNodeExtensionKt.prevCodeLeaf$default((ASTNode)aSTNode, (boolean)false, (int)1, null)) != null) {
            ASTNode aSTNode3;
            ASTNode it2 = aSTNode3 = aSTNode2;
            boolean bl2 = false;
            object = Intrinsics.areEqual((Object)it2.getElementType(), (Object)ElementType.INSTANCE.getRPAR()) ? aSTNode3 : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLambdaExpression(ASTNode $this$isLambdaExpression) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode aSTNode3;
        ASTNode it = aSTNode3 = $this$isLambdaExpression.getTreeParent();
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) return false;
        if (!Intrinsics.areEqual((Object)it.getFirstChildNode(), (Object)$this$isLambdaExpression)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        ASTNode aSTNode4 = aSTNode3;
        ASTNode aSTNode5 = aSTNode4;
        if (aSTNode5 == null) return false;
        aSTNode3 = aSTNode5.getTreeParent();
        if (aSTNode3 == null) return false;
        ASTNode it2 = aSTNode2 = aSTNode3;
        boolean bl3 = false;
        if (!Intrinsics.areEqual((Object)it2.getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) return false;
        ASTNode aSTNode6 = aSTNode2;
        ASTNode aSTNode7 = aSTNode6;
        if (aSTNode7 == null) return false;
        aSTNode2 = aSTNode7.getTreeParent();
        if (aSTNode2 == null) return false;
        ASTNode it3 = aSTNode = aSTNode2;
        boolean bl4 = false;
        if (!Intrinsics.areEqual((Object)it3.getElementType(), (Object)ElementType.INSTANCE.getLAMBDA_EXPRESSION())) return false;
        ASTNode aSTNode8 = aSTNode;
        if (aSTNode8 == null) return false;
        return true;
    }

    private final boolean isValueArgument(ASTNode $this$isValueArgument) {
        return Intrinsics.areEqual((Object)$this$isValueArgument.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT());
    }

    private final boolean isAfterArrow(ASTNode $this$isAfterArrow) {
        ASTNode aSTNode = ASTNodeExtensionKt.prevCodeLeaf$default((ASTNode)$this$isAfterArrow, (boolean)false, (int)1, null);
        return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getARROW());
    }

    private final boolean isRightHandSideOfBinaryExpression(ASTNode $this$isRightHandSideOfBinaryExpression) {
        ASTNode aSTNode;
        ASTNode it = aSTNode = $this$isRightHandSideOfBinaryExpression;
        boolean bl = false;
        it = aSTNode = Intrinsics.areEqual((Object)it.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) ? aSTNode : null;
        boolean bl2 = false;
        ASTNode aSTNode2 = it;
        return (Intrinsics.areEqual((Object)(aSTNode2 != null && (aSTNode2 = ASTNodeExtensionKt.prevCodeSibling((ASTNode)aSTNode2)) != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE()) ? aSTNode : null) != null;
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getARRAY_ACCESS_EXPRESSION(), ElementType.INSTANCE.getBINARY_WITH_TYPE(), ElementType.INSTANCE.getCALL_EXPRESSION(), ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION(), ElementType.INSTANCE.getIF(), ElementType.INSTANCE.getIS_EXPRESSION(), ElementType.INSTANCE.getOBJECT_LITERAL(), ElementType.INSTANCE.getPREFIX_EXPRESSION(), ElementType.INSTANCE.getREFERENCE_EXPRESSION(), ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION(), ElementType.INSTANCE.getTRY(), ElementType.INSTANCE.getWHEN()};
        CHAINABLE_EXPRESSION = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/MultilineExpressionWrapping$Companion;", "", "()V", "CHAINABLE_EXPRESSION", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getCHAINABLE_EXPRESSION", "()Ljava/util/Set;", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<IElementType> getCHAINABLE_EXPRESSION() {
            return CHAINABLE_EXPRESSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

