/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.CommentWrappingRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.NoSingleLineBlockCommentRule;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiCommentImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004Je\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2K\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00060\fH\u0016J\u000e\u0010\u0014\u001a\u00020\n*\u0004\u0018\u00010\bH\u0002J\f\u0010\u0015\u001a\u00020\u0006*\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/NoSingleLineBlockCommentRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule$Experimental;", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule$OfficialCodeStyle;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isWhitespaceWithNewlineOrNull", "replaceWithEndOfLineComment", "ktlint-ruleset-standard"})
public final class NoSingleLineBlockCommentRule
extends StandardRule
implements Rule.Experimental,
Rule.OfficialCodeStyle {
    public NoSingleLineBlockCommentRule() {
        Object object = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()};
        Set set = SetsKt.setOf((Object[])object);
        object = SetsKt.setOf((Object)new Rule.VisitorModifier.RunAfterRule(CommentWrappingRuleKt.getCOMMENT_WRAPPING_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED));
        super("no-single-line-block-comment", (Set<? extends Rule.VisitorModifier>)object, set);
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) {
            ASTNode afterBlockComment2;
            ASTNode aSTNode = (ASTNode)SequencesKt.firstOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.leaves$default((ASTNode)node, (boolean)false, (int)1, null), (Function1)beforeVisitChildNodes.afterBlockComment.1.INSTANCE));
            if (aSTNode == null) {
                aSTNode = afterBlockComment2 = ASTNodeExtensionKt.lastChildLeafOrSelf((ASTNode)node);
            }
            if (!node.textContains('\n') && this.isWhitespaceWithNewlineOrNull(ASTNodeExtensionKt.nextLeaf$default((ASTNode)afterBlockComment2, (boolean)false, (boolean)false, (int)3, null))) {
                emit.invoke((Object)node.getStartOffset(), (Object)"Replace the block comment with an EOL comment", (Object)true);
                if (autoCorrect) {
                    this.replaceWithEndOfLineComment(node);
                }
            }
        }
    }

    private final void replaceWithEndOfLineComment(ASTNode $this$replaceWithEndOfLineComment) {
        String string = $this$replaceWithEndOfLineComment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String content = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSurrounding((String)string, (CharSequence)"/*", (CharSequence)"*/"))).toString();
        PsiCommentImpl eolComment = new PsiCommentImpl(ElementType.INSTANCE.getEOL_COMMENT(), (CharSequence)("// " + content));
        Intrinsics.checkNotNull((Object)$this$replaceWithEndOfLineComment, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        ((LeafPsiElement)$this$replaceWithEndOfLineComment).rawInsertBeforeMe((TreeElement)eolComment);
        ((LeafPsiElement)$this$replaceWithEndOfLineComment).rawRemove();
    }

    private final boolean isWhitespaceWithNewlineOrNull(ASTNode $this$isWhitespaceWithNewlineOrNull) {
        return $this$isWhitespaceWithNewlineOrNull == null || ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)$this$isWhitespaceWithNewlineOrNull);
    }
}

