/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.IndentConfig;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.ClassSignatureRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.ValueArgumentCommentRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.WrappingRuleKt;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016Je\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2K\u0010\u0010\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\b0\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002Je\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2K\u0010\u0010\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u001c\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u001d\u001a\u00020\u000f*\u00020\rH\u0002J\u0014\u0010\u001e\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010!\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\"\u001a\u00020\u000f*\u00020\rH\u0002J\u0014\u0010#\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010$\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010\r*\u00020\rH\u0002J\u0014\u0010&\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "editorConfigIndent", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "maxLineLength", "", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "intendedIndent", "child", "needToWrapArgumentList", "wrapArgumentInList", "exceedsMaxLineLength", "hasTypeArgumentListInFront", "isCollectionLiteralContaining", "char", "", "isOnSameLineAsControlFlowKeyword", "isPartOfDotQualifiedAssignmentExpression", "isValueArgumentContaining", "isWhitespaceContaining", "prevWhiteSpaceWithNewLine", "textContainsIgnoringLambda", "ktlint-ruleset-standard"})
@SinceKtlint(version="0.1", status=SinceKtlint.Status.STABLE)
@SourceDebugExtension(value={"SMAP\nArgumentListWrappingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentListWrappingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,296:1\n1313#2,2:297\n1268#2,3:299\n1247#2,2:302\n1247#2,2:304\n179#2,2:306\n1247#2,2:308\n1#3:310\n142#4:311\n*S KotlinDebug\n*F\n+ 1 ArgumentListWrappingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule\n*L\n102#1:297,2\n113#1:299,3\n240#1:302,2\n251#1:304,2\n256#1:306,2\n258#1:308,2\n276#1:311\n*E\n"})
public final class ArgumentListWrappingRule
extends StandardRule {
    @NotNull
    private IndentConfig editorConfigIndent;
    private int maxLineLength;

    public ArgumentListWrappingRule() {
        Object[] objectArray = new Rule.VisitorModifier.RunAfterRule[]{new Rule.VisitorModifier.RunAfterRule(ValueArgumentCommentRuleKt.getVALUE_ARGUMENT_COMMENT_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), new Rule.VisitorModifier.RunAfterRule(WrappingRuleKt.getWRAPPING_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), new Rule.VisitorModifier.RunAfterRule(ClassSignatureRuleKt.getCLASS_SIGNATURE_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED)};
        Set set = SetsKt.setOf((Object[])objectArray);
        objectArray = new EditorConfigProperty[]{IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY(), MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY()};
        super("argument-list-wrapping", set, SetsKt.setOf((Object[])objectArray));
        this.editorConfigIndent = IndentConfig.Companion.getDEFAULT_INDENT_CONFIG();
        this.maxLineLength = ((Number)MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY().getDefaultValue()).intValue();
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.editorConfigIndent = new IndentConfig((PropertyType.IndentStyleValue)editorConfig.get(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)editorConfig.get(IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
        this.maxLineLength = ((Number)editorConfig.get(MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY())).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (this.editorConfigIndent.getDisabled()) {
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST()) && this.needToWrapArgumentList(node)) {
            void $this$forEach$iv;
            Sequence sequence = PsiUtilsKt.children((ASTNode)node);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode child = (ASTNode)element$iv;
                boolean bl = false;
                this.wrapArgumentInList(child, emit, autoCorrect);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needToWrapArgumentList(ASTNode node) {
        ASTNode aSTNode = node.getFirstChildNode();
        if (Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeNext()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getRPAR())) return false;
        ASTNode aSTNode2 = node.getTreeParent();
        if (Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) return false;
        Sequence $this$count$iv = PsiUtilsKt.children((ASTNode)node);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        if (count$iv > 8) return false;
        if (this.textContainsIgnoringLambda(node, '\n')) return true;
        if (!this.exceedsMaxLineLength(node)) return false;
        return true;
    }

    private final boolean exceedsMaxLineLength(ASTNode $this$exceedsMaxLineLength) {
        return ASTNodeExtensionKt.lineLengthWithoutNewlinePrefix((ASTNode)$this$exceedsMaxLineLength) > this.maxLineLength && !$this$exceedsMaxLineLength.textContains('\n');
    }

    private final String intendedIndent(ASTNode child) {
        int n;
        ASTNode aSTNode = child.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
        if (this.hasTypeArgumentListInFront(aSTNode)) {
            n = -1;
        } else {
            ASTNode aSTNode2 = child.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"getTreeParent(...)");
            n = this.isPartOfDotQualifiedAssignmentExpression(aSTNode2) ? -1 : 0;
        }
        int it = n;
        boolean bl = false;
        ASTNode aSTNode3 = child.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"getTreeParent(...)");
        it = this.isOnSameLineAsControlFlowKeyword(aSTNode3) ? it + 1 : it;
        boolean bl2 = false;
        int indentLevelFix = Intrinsics.areEqual((Object)child.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) ? it + 1 : it;
        boolean bl3 = false;
        ASTNode aSTNode4 = child.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"getTreeParent(...)");
        int indentLevel = this.editorConfigIndent.indentLevelFrom(ASTNodeExtensionKt.indent((ASTNode)aSTNode4, (boolean)false)) + indentLevelFix;
        return '\n' + StringsKt.repeat((CharSequence)this.editorConfigIndent.getIndent(), (int)indentLevel);
    }

    private final void wrapArgumentInList(ASTNode child, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        IElementType iElementType = child.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            ASTNode prevLeaf2 = ASTNodeExtensionKt.prevLeaf$default((ASTNode)child, (boolean)false, (int)1, null);
            if (prevLeaf2 instanceof PsiWhiteSpace && prevLeaf2.textContains('\n')) {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((PsiWhiteSpace)prevLeaf2).delete();
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            ASTNode prevLeaf3;
            String intendedIndent = this.intendedIndent(child);
            ASTNode aSTNode = this.prevWhiteSpaceWithNewLine(child);
            if (aSTNode == null) {
                aSTNode = ASTNodeExtensionKt.prevLeaf$default((ASTNode)child, (boolean)false, (int)1, null);
            }
            if ((prevLeaf3 = aSTNode) instanceof PsiWhiteSpace) {
                String string = prevLeaf3.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    return;
                }
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)prevLeaf3).rawReplaceWithText(intendedIndent);
                }
            } else {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    child.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)intendedIndent), child);
                }
            }
        }
    }

    private final String errorMessage(ASTNode node) {
        String string;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            string = "Unnecessary newline before \"(\"";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) {
            string = "Argument should be on a separate line (unless all arguments can fit a single line)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            string = "Missing newline before \")\"";
        } else {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    private final boolean textContainsIgnoringLambda(ASTNode $this$textContainsIgnoringLambda, char c) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = PsiUtilsKt.children((ASTNode)$this$textContainsIgnoringLambda);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode child = (ASTNode)element$iv;
                boolean bl2 = false;
                boolean bl3 = this.isWhitespaceContaining(child, c) || this.isCollectionLiteralContaining(child, c) || this.isValueArgumentContaining(child, c);
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isWhitespaceContaining(ASTNode $this$isWhitespaceContaining, char c) {
        return Intrinsics.areEqual((Object)$this$isWhitespaceContaining.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && $this$isWhitespaceContaining.textContains(c);
    }

    private final boolean isCollectionLiteralContaining(ASTNode $this$isCollectionLiteralContaining, char c) {
        return Intrinsics.areEqual((Object)$this$isCollectionLiteralContaining.getElementType(), (Object)ElementType.INSTANCE.getCOLLECTION_LITERAL_EXPRESSION()) && $this$isCollectionLiteralContaining.textContains(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValueArgumentContaining(ASTNode $this$isValueArgumentContaining, char c) {
        ASTNode it;
        if (!Intrinsics.areEqual((Object)$this$isValueArgumentContaining.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) return false;
        Sequence $this$any$iv = PsiUtilsKt.children((ASTNode)$this$isValueArgumentContaining);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (ASTNode)element$iv;
            boolean bl = false;
        } while (!this.textContainsIgnoringLambda(it, c));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTypeArgumentListInFront(ASTNode $this$hasTypeArgumentListInFront) {
        boolean bl;
        Sequence sequence;
        Object v1;
        block4: {
            ASTNode aSTNode = $this$hasTypeArgumentListInFront.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
            Sequence $this$firstOrNull$iv = PsiUtilsKt.children((ASTNode)aSTNode);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getTYPE_ARGUMENT_LIST())) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        ASTNode aSTNode = v1;
        if (aSTNode != null && (sequence = PsiUtilsKt.children((ASTNode)aSTNode)) != null) {
            boolean bl3;
            block5: {
                void $this$any$iv;
                Sequence $i$f$firstOrNull = sequence;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl4 = false;
                    if (!ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)it)) continue;
                    bl3 = true;
                    break block5;
                }
                bl3 = false;
            }
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfDotQualifiedAssignmentExpression(ASTNode $this$isPartOfDotQualifiedAssignmentExpression) {
        Object v5;
        block1: {
            ASTNode aSTNode = $this$isPartOfDotQualifiedAssignmentExpression.getTreeParent();
            if (!Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) return false;
            ASTNode aSTNode2 = $this$isPartOfDotQualifiedAssignmentExpression.getTreeParent();
            ASTNode aSTNode3 = aSTNode2;
            if (aSTNode2 == null) return false;
            ASTNode aSTNode4 = aSTNode3.getTreeParent();
            aSTNode3 = aSTNode4;
            if (aSTNode4 == null) return false;
            Sequence sequence = PsiUtilsKt.children((ASTNode)aSTNode3);
            aSTNode3 = sequence;
            if (sequence == null) return false;
            ASTNode aSTNode5 = aSTNode3;
            for (Object e : aSTNode5) {
                ASTNode it = (ASTNode)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) continue;
                v5 = e;
                break block1;
            }
            v5 = null;
        }
        ASTNode aSTNode = v5;
        if (aSTNode == null) return false;
        return true;
    }

    private final ASTNode prevWhiteSpaceWithNewLine(ASTNode $this$prevWhiteSpaceWithNewLine) {
        ASTNode prev = ASTNodeExtensionKt.prevLeaf$default((ASTNode)$this$prevWhiteSpaceWithNewLine, (boolean)false, (int)1, null);
        while (prev != null && (ASTNodeExtensionKt.isWhiteSpace((ASTNode)prev) || ASTNodeExtensionKt.isPartOfComment((ASTNode)prev))) {
            if (ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)prev)) {
                return prev;
            }
            prev = ASTNodeExtensionKt.prevLeaf$default((ASTNode)prev, (boolean)false, (int)1, null);
        }
        return null;
    }

    private final boolean isOnSameLineAsControlFlowKeyword(ASTNode $this$isOnSameLineAsControlFlowKeyword) {
        Object object;
        PsiElement psiElement = $this$isOnSameLineAsControlFlowKeyword.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        PsiElement $this$getStrictParentOfType$iv = psiElement;
        boolean $i$f$getStrictParentOfType = false;
        KtContainerNode ktContainerNode = (KtContainerNode)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtContainerNode.class, (boolean)true);
        if (ktContainerNode == null) {
            return false;
        }
        KtContainerNode containerNode = ktContainerNode;
        if (Intrinsics.areEqual((Object)containerNode.getNode().getElementType(), (Object)ElementType.INSTANCE.getELSE())) {
            return false;
        }
        PsiElement parent = containerNode.getParent();
        if (parent instanceof KtIfExpression) {
            object = ((KtIfExpression)parent).getIfKeyword().getNode();
        } else if (parent instanceof KtWhileExpression) {
            object = ((KtWhileExpression)parent).getFirstChild().getNode();
        } else if (parent instanceof KtDoWhileExpression) {
            PsiElement psiElement2 = ((KtDoWhileExpression)parent).getWhileKeyword();
            object = psiElement2 != null ? psiElement2.getNode() : null;
        } else {
            object = null;
        }
        if (object == null) {
            return false;
        }
        ASTNode controlFlowKeyword = object;
        ASTNode aSTNode = ASTNodeExtensionKt.prevLeaf$default((ASTNode)$this$isOnSameLineAsControlFlowKeyword, (boolean)false, (int)1, null);
        if (aSTNode == null) {
            return false;
        }
        ASTNode prevLeaf2 = aSTNode;
        while (!Intrinsics.areEqual((Object)prevLeaf2, (Object)controlFlowKeyword)) {
            if (ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)prevLeaf2)) {
                return false;
            }
            if (ASTNodeExtensionKt.prevLeaf$default((ASTNode)prevLeaf2, (boolean)false, (int)1, null) != null) continue;
            return false;
        }
        return true;
    }
}

