/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.PropertyNamingRule;
import com.pinterest.ktlint.ruleset.standard.rules.internal.RegExIgnoringDiacriticsAndStrokesOnLettersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J]\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0002J]\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0002J]\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0002J]\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00062K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0002J\f\u0010\u0018\u001a\u00020\u000f*\u00020\u0006H\u0002J\f\u0010\u0019\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u001a\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u001b\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u001c\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u001d\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u001e\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u001f\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010 \u001a\u00020\b*\u00020\u0006H\u0002\u00a8\u0006\""}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "visitBackingProperty", "identifier", "visitConstProperty", "visitNonConstProperty", "visitProperty", "property", "capitalizeFirstChar", "containsValKeyword", "hasConstModifier", "hasCustomGetter", "hasNonEmptyParameterList", "isNotPublic", "isObjectValue", "isTokenKeywordBetweenBackticks", "isTopLevelValue", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint.Container(value={@SinceKtlint(version="0.48", status=SinceKtlint.Status.EXPERIMENTAL), @SinceKtlint(version="1.0", status=SinceKtlint.Status.STABLE)})
@SourceDebugExtension(value={"SMAP\nPropertyNamingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,210:1\n1#2:211\n1#2:233\n179#3,2:212\n179#3,2:214\n2159#3,2:216\n1247#3,2:218\n1360#4:220\n1446#4,2:221\n1448#4,3:236\n819#4:239\n847#4:240\n848#4:243\n11383#5,9:223\n13309#5:232\n13310#5:234\n11392#5:235\n1083#6,2:241\n*S KotlinDebug\n*F\n+ 1 PropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule\n*L\n200#1:233\n94#1:212,2\n110#1:214,2\n124#1:216,2\n172#1:218,2\n200#1:220\n200#1:221,2\n200#1:236,3\n201#1:239\n201#1:240\n201#1:243\n200#1:223,9\n200#1:232\n200#1:234\n200#1:235\n204#1:241,2\n*E\n"})
public final class PropertyNamingRule
extends StandardRule {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private static final Regex LOWER_CAMEL_CASE_REGEXP;
    @NotNull
    private static final Regex SCREAMING_SNAKE_CASE_REGEXP;
    @NotNull
    private static final Regex BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP;
    @Deprecated
    @NotNull
    public static final String SERIAL_VERSION_UID_PROPERTY_NAME = "serialVersionUID";
    @NotNull
    private static final Set<String> KEYWORDS;

    public PropertyNamingRule() {
        super("property-naming", null, null, 6, null);
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block0: {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(emit, (String)"emit");
            ASTNode it = aSTNode2 = node;
            boolean bl = false;
            Object object = aSTNode = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY()) ? aSTNode2 : null;
            if (aSTNode == null) break block0;
            ASTNode property = aSTNode;
            boolean bl2 = false;
            this.visitProperty(property, emit);
        }
    }

    private final void visitProperty(ASTNode property, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block2: {
            ASTNode identifier;
            block3: {
                ASTNode aSTNode;
                ASTNode aSTNode2;
                ASTNode aSTNode3 = property.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
                if (aSTNode3 == null) break block2;
                ASTNode it = aSTNode2 = aSTNode3;
                boolean bl = false;
                Object object = aSTNode = !this.isTokenKeywordBetweenBackticks(it) ? aSTNode2 : null;
                if (aSTNode == null) break block2;
                identifier = aSTNode;
                boolean bl2 = false;
                if (!this.hasConstModifier(property)) break block3;
                this.visitConstProperty(identifier, emit);
                break block2;
            }
            if (this.hasCustomGetter(property) || this.isTopLevelValue(property) || this.isObjectValue(property)) break block2;
            String string = identifier.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.startsWith$default((String)string, (String)"_", (boolean)false, (int)2, null)) {
                this.visitBackingProperty(identifier, emit);
            } else {
                this.visitNonConstProperty(identifier, emit);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitBackingProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Sequence sequence;
        Sequence correlatedProperty;
        ASTNode aSTNode;
        Iterator iterator;
        Sequence sequence2;
        Sequence sequence3;
        Sequence sequence4;
        Sequence sequence5;
        String string;
        String string2;
        String it = string2 = identifier.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string3 = string = !BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP.matches((CharSequence)it) ? string2 : null;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property name should start with underscore followed by lower camel case", (Object)false);
        }
        ASTNode aSTNode2 = identifier.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"getTreeParent(...)");
        if (!ASTNodeExtensionKt.hasModifier((ASTNode)aSTNode2, (IElementType)ElementType.INSTANCE.getPRIVATE_KEYWORD())) {
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property name not allowed when 'private' modifier is missing", (Object)false);
        }
        if ((string = identifier.getTreeParent()) != null && (string2 = string.getTreeParent()) != null && (sequence5 = ASTNodeExtensionKt.children((ASTNode)string2)) != null && (sequence4 = SequencesKt.filter((Sequence)sequence5, (Function1)visitBackingProperty.3.INSTANCE)) != null && (sequence3 = SequencesKt.mapNotNull((Sequence)sequence4, (Function1)visitBackingProperty.4.INSTANCE)) != null) {
            Object v4;
            block10: {
                void $this$firstOrNull$iv;
                sequence2 = sequence3;
                boolean $i$f$firstOrNull = false;
                iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    ASTNode it2 = (ASTNode)element$iv;
                    boolean bl3 = false;
                    String string4 = it2.getText();
                    String string5 = identifier.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                    if (!Intrinsics.areEqual((Object)string4, (Object)StringsKt.removePrefix((String)string5, (CharSequence)"_"))) continue;
                    v4 = element$iv;
                    break block10;
                }
                v4 = null;
            }
            aSTNode = v4;
            if (aSTNode != null && (sequence2 = aSTNode.getTreeParent()) != null) {
                correlatedProperty = sequence2;
                boolean bl4 = false;
                if (this.isNotPublic((ASTNode)correlatedProperty)) {
                    return;
                }
            }
        }
        String correlatedFunctionName = "get" + this.capitalizeFirstChar(identifier);
        string2 = identifier.getTreeParent();
        if (string2 != null && (sequence5 = string2.getTreeParent()) != null && (sequence = ASTNodeExtensionKt.children((ASTNode)sequence5)) != null && (sequence3 = SequencesKt.filter((Sequence)sequence, (Function1)visitBackingProperty.7.INSTANCE)) != null && (aSTNode = SequencesKt.filter((Sequence)sequence3, (Function1)((Function1)new Function1<ASTNode, Boolean>(this){
            final /* synthetic */ PropertyNamingRule this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return PropertyNamingRule.access$hasNonEmptyParameterList(this.this$0, it);
            }
        }))) != null && (sequence2 = SequencesKt.mapNotNull((Sequence)aSTNode, (Function1)visitBackingProperty.9.INSTANCE)) != null) {
            Object v5;
            block11: {
                void $this$firstOrNull$iv;
                correlatedProperty = sequence2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ASTNode it3 = (ASTNode)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it3.getText(), (Object)correlatedFunctionName)) continue;
                    v5 = element$iv;
                    break block11;
                }
                v5 = null;
            }
            ASTNode aSTNode3 = v5;
            if (aSTNode3 != null && (iterator = aSTNode3.getTreeParent()) != null) {
                Iterator correlatedFunction = iterator;
                boolean bl6 = false;
                if (this.isNotPublic((ASTNode)correlatedFunction)) {
                    return;
                }
            }
        }
        emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property name is only allowed when a matching public property or function exists", (Object)false);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNonEmptyParameterList(ASTNode $this$hasNonEmptyParameterList) {
        boolean bl;
        block3: {
            Sequence sequence;
            ASTNode aSTNode = $this$hasNonEmptyParameterList.findChildByType(ElementType.INSTANCE.getVALUE_PARAMETER_LIST());
            if (aSTNode != null && (sequence = ASTNodeExtensionKt.children((ASTNode)aSTNode)) != null) {
                void $this$none$iv;
                Sequence sequence2 = sequence;
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String capitalizeFirstChar(ASTNode $this$capitalizeFirstChar) {
        String string;
        String string2 = $this$capitalizeFirstChar.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = StringsKt.removePrefix((String)string2, (CharSequence)"_");
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string4 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string5);
            String string6 = string3;
            int n = 1;
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            string = stringBuilder2.append(string7).toString();
        } else {
            string = string3;
        }
        return string;
    }

    private final void visitConstProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block1: {
            String string;
            String string2;
            String string3;
            String it = string3 = identifier.getText();
            boolean bl = false;
            String string4 = string2 = !Intrinsics.areEqual((Object)it, (Object)SERIAL_VERSION_UID_PROPERTY_NAME) ? string3 : null;
            if (string2 == null) break block1;
            String it2 = string = string2;
            boolean bl2 = false;
            String string5 = string3 = !SCREAMING_SNAKE_CASE_REGEXP.matches((CharSequence)it2) ? string : null;
            if (string3 != null) {
                it2 = string3;
                boolean bl3 = false;
                emit.invoke((Object)identifier.getStartOffset(), (Object)"Property name should use the screaming snake case notation when the value can not be changed", (Object)false);
            }
        }
    }

    private final void visitNonConstProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block0: {
            String string;
            String string2;
            String it = string2 = identifier.getText();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string3 = string = !LOWER_CAMEL_CASE_REGEXP.matches((CharSequence)it) ? string2 : null;
            if (string == null) break block0;
            it = string;
            boolean bl2 = false;
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Property name should start with a lowercase letter and use camel case", (Object)false);
        }
    }

    private final boolean hasCustomGetter(ASTNode $this$hasCustomGetter) {
        ASTNode aSTNode = $this$hasCustomGetter.findChildByType(ElementType.INSTANCE.getPROPERTY_ACCESSOR());
        return (aSTNode != null ? aSTNode.findChildByType(ElementType.INSTANCE.getGET_KEYWORD()) : null) != null;
    }

    private final boolean hasConstModifier(ASTNode $this$hasConstModifier) {
        return ASTNodeExtensionKt.hasModifier((ASTNode)$this$hasConstModifier, (IElementType)ElementType.INSTANCE.getCONST_KEYWORD());
    }

    private final boolean isTopLevelValue(ASTNode $this$isTopLevelValue) {
        return Intrinsics.areEqual((Object)$this$isTopLevelValue.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE()) && this.containsValKeyword($this$isTopLevelValue);
    }

    private final boolean containsValKeyword(ASTNode $this$containsValKeyword) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = ASTNodeExtensionKt.children((ASTNode)$this$containsValKeyword);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVAL_KEYWORD())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isObjectValue(ASTNode $this$isObjectValue) {
        ASTNode aSTNode;
        return Intrinsics.areEqual((Object)$this$isObjectValue.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getCLASS_BODY()) && Intrinsics.areEqual((Object)((aSTNode = $this$isObjectValue.getTreeParent()) != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) && this.containsValKeyword($this$isObjectValue) && !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isObjectValue, (IElementType)ElementType.INSTANCE.getOVERRIDE_KEYWORD());
    }

    private final boolean isNotPublic(ASTNode $this$isNotPublic) {
        return !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isNotPublic, (IElementType)ElementType.INSTANCE.getPRIVATE_KEYWORD()) && !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isNotPublic, (IElementType)ElementType.INSTANCE.getPROTECTED_KEYWORD()) && !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isNotPublic, (IElementType)ElementType.INSTANCE.getINTERNAL_KEYWORD());
    }

    private final boolean isTokenKeywordBetweenBackticks(ASTNode $this$isTokenKeywordBetweenBackticks) {
        ASTNode aSTNode;
        ASTNode it = aSTNode = $this$isTokenKeywordBetweenBackticks;
        boolean bl = false;
        Object object = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER()) ? aSTNode : null;
        String string = object != null ? object.getText() : null;
        if (string == null) {
            string = "";
        }
        String it2 = StringsKt.removeSurrounding((String)string, (CharSequence)"`");
        boolean bl2 = false;
        return KEYWORDS.contains(it2);
    }

    public static final /* synthetic */ boolean access$hasNonEmptyParameterList(PropertyNamingRule $this, ASTNode $receiver) {
        return $this.hasNonEmptyParameterList($receiver);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        LOWER_CAMEL_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("[a-z][a-zA-Z0-9]*");
        SCREAMING_SNAKE_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("[A-Z][_A-Z0-9]*");
        BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("_[a-z][a-zA-Z0-9]*");
        Object[] objectArray = new TokenSet[]{KtTokens.KEYWORDS, KtTokens.SOFT_KEYWORDS};
        Iterable $this$flatMap$iv = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            TokenSet tokenSet = (TokenSet)element$iv$iv;
            boolean bl = false;
            IElementType[] iElementTypeArray = tokenSet.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
            Object[] $this$mapNotNull$iv = iElementTypeArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                String it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl2 = false;
                IElementType it = (IElementType)element$iv$iv2;
                boolean bl3 = false;
                if (it.getDebugName() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$flatMapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            block4: {
                String keyword = (String)element$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)keyword);
                CharSequence $this$any$iv = keyword;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl6 = false;
                    if (!Character.isUpperCase(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KEYWORDS = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u000e\u0010\u0012\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule$Companion;", "", "()V", "BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP", "Lkotlin/text/Regex;", "getBACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP", "()Lkotlin/text/Regex;", "KEYWORDS", "", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "getKEYWORDS", "()Ljava/util/Set;", "LOWER_CAMEL_CASE_REGEXP", "getLOWER_CAMEL_CASE_REGEXP", "SCREAMING_SNAKE_CASE_REGEXP", "getSCREAMING_SNAKE_CASE_REGEXP", "SERIAL_VERSION_UID_PROPERTY_NAME", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getLOWER_CAMEL_CASE_REGEXP() {
            return LOWER_CAMEL_CASE_REGEXP;
        }

        @NotNull
        public final Regex getSCREAMING_SNAKE_CASE_REGEXP() {
            return SCREAMING_SNAKE_CASE_REGEXP;
        }

        @NotNull
        public final Regex getBACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP() {
            return BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP;
        }

        @NotNull
        public final Set<String> getKEYWORDS() {
            return KEYWORDS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

