/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPrefixExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J\f\u0010\u0012\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u0013\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u0014\u001a\u00020\b*\u00020\u0006H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/SpacingAroundOperatorsRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "isImport", "isSpreadOperator", "isUnaryOperator", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint(version="0.1", status=SinceKtlint.Status.STABLE)
public final class SpacingAroundOperatorsRule
extends StandardRule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final TokenSet OPERATORS;

    public SpacingAroundOperatorsRule() {
        super("op-spacing", null, null, 6, null);
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (this.isUnaryOperator(node)) {
            return;
        }
        if (this.isSpreadOperator(node)) {
            return;
        }
        if (this.isImport(node)) {
            return;
        }
        if ((Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getLT()) || Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getGT()) || Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getMUL())) && !Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) {
            return;
        }
        if (OPERATORS.contains(node.getElementType()) || Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER()) && Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) {
            boolean spacingBefore = ASTNodeExtensionKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null) instanceof PsiWhiteSpace;
            boolean spacingAfter = ASTNodeExtensionKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null) instanceof PsiWhiteSpace;
            if (!spacingBefore && !spacingAfter) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Missing spacing around \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)node, (String)" ");
                    ASTNodeExtensionKt.upsertWhitespaceAfterMe((ASTNode)node, (String)" ");
                }
            } else if (!spacingBefore) {
                emit.invoke((Object)node.getStartOffset(), (Object)("Missing spacing before \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)node, (String)" ");
                }
            } else if (!spacingAfter) {
                emit.invoke((Object)(node.getStartOffset() + node.getTextLength()), (Object)("Missing spacing after \"" + node.getText() + '\"'), (Object)true);
                if (autoCorrect) {
                    ASTNodeExtensionKt.upsertWhitespaceAfterMe((ASTNode)node, (String)" ");
                }
            }
        }
    }

    private final boolean isUnaryOperator(ASTNode $this$isUnaryOperator) {
        return ASTNodeExtensionKt.isPartOf((ASTNode)$this$isUnaryOperator, (KClass)Reflection.getOrCreateKotlinClass(KtPrefixExpression.class));
    }

    private final boolean isSpreadOperator(ASTNode $this$isSpreadOperator) {
        return Intrinsics.areEqual((Object)$this$isSpreadOperator.getElementType(), (Object)ElementType.INSTANCE.getMUL()) && Intrinsics.areEqual((Object)$this$isSpreadOperator.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT());
    }

    private final boolean isImport(ASTNode $this$isImport) {
        return ASTNodeExtensionKt.isPartOf((ASTNode)$this$isImport, (KClass)Reflection.getOrCreateKotlinClass(KtImportDirective.class));
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getANDAND(), ElementType.INSTANCE.getARROW(), ElementType.INSTANCE.getDIV(), ElementType.INSTANCE.getDIVEQ(), ElementType.INSTANCE.getELVIS(), ElementType.INSTANCE.getEQ(), ElementType.INSTANCE.getEQEQ(), ElementType.INSTANCE.getEQEQEQ(), ElementType.INSTANCE.getEXCLEQ(), ElementType.INSTANCE.getEXCLEQEQEQ(), ElementType.INSTANCE.getGT(), ElementType.INSTANCE.getGTEQ(), ElementType.INSTANCE.getLT(), ElementType.INSTANCE.getLTEQ(), ElementType.INSTANCE.getMINUS(), ElementType.INSTANCE.getMINUSEQ(), ElementType.INSTANCE.getMUL(), ElementType.INSTANCE.getMULTEQ(), ElementType.INSTANCE.getOROR(), ElementType.INSTANCE.getPERC(), ElementType.INSTANCE.getPERCEQ(), ElementType.INSTANCE.getPLUS(), ElementType.INSTANCE.getPLUSEQ()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        OPERATORS = tokenSet;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/SpacingAroundOperatorsRule$Companion;", "", "()V", "OPERATORS", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

