/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.IndentConfig;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentSizeEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.ArgumentListWrappingRule;
import com.pinterest.ktlint.ruleset.standard.rules.ClassSignatureRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.FunctionSignatureRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.ValueArgumentCommentRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.WrappingRuleKt;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\b\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016Je\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102K\u0010\u0011\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\t0\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002Je\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000e2K\u0010\u0011\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u001d\u001a\u00020\u0010*\u00020\u000eH\u0002J\f\u0010\u001e\u001a\u00020\u0010*\u00020\u000eH\u0002J\u0014\u0010\u001f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020\u0010*\u00020\u000eH\u0002J\f\u0010#\u001a\u00020\u0010*\u00020\u000eH\u0002J\u0014\u0010$\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010%\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002J\u0014\u0010'\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "editorConfigIndent", "Lcom/pinterest/ktlint/rule/engine/core/api/IndentConfig;", "ignoreWhenParameterCountGreaterOrEqualThanProperty", "", "maxLineLength", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "intendedIndent", "child", "needToWrapArgumentList", "wrapArgumentInList", "exceedsMaxLineLength", "hasTypeArgumentListInFront", "isCollectionLiteralContaining", "char", "", "isOnSameLineAsControlFlowKeyword", "isPartOfDotQualifiedAssignmentExpression", "isValueArgumentContaining", "isWhitespaceContaining", "prevWhiteSpaceWithNewLine", "textContainsIgnoringLambda", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint(version="0.1", status=SinceKtlint.Status.STABLE)
@SourceDebugExtension(value={"SMAP\nArgumentListWrappingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentListWrappingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,343:1\n1313#2,2:344\n1268#2,3:346\n1247#2,2:349\n1247#2,2:351\n179#2,2:353\n1247#2,2:355\n1#3:357\n142#4:358\n*S KotlinDebug\n*F\n+ 1 ArgumentListWrappingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule\n*L\n110#1:344,2\n121#1:346,3\n249#1:349,2\n260#1:351,2\n265#1:353,2\n267#1:355,2\n291#1:358\n*E\n"})
public final class ArgumentListWrappingRule
extends StandardRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private IndentConfig editorConfigIndent;
    private int maxLineLength;
    private int ignoreWhenParameterCountGreaterOrEqualThanProperty;
    private static final int UNSET_IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY = Integer.MAX_VALUE;
    @NotNull
    private static final EditorConfigProperty<Integer> IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY;

    public ArgumentListWrappingRule() {
        Object[] objectArray = new Rule.VisitorModifier.RunAfterRule[]{new Rule.VisitorModifier.RunAfterRule(ValueArgumentCommentRuleKt.getVALUE_ARGUMENT_COMMENT_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), new Rule.VisitorModifier.RunAfterRule(WrappingRuleKt.getWRAPPING_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), new Rule.VisitorModifier.RunAfterRule(ClassSignatureRuleKt.getCLASS_SIGNATURE_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), new Rule.VisitorModifier.RunAfterRule(FunctionSignatureRuleKt.getFUNCTION_SIGNATURE_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED)};
        Set set = SetsKt.setOf((Object[])objectArray);
        objectArray = new EditorConfigProperty[]{IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY, IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY(), IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY(), MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY()};
        super("argument-list-wrapping", set, SetsKt.setOf((Object[])objectArray));
        this.editorConfigIndent = IndentConfig.Companion.getDEFAULT_INDENT_CONFIG();
        this.maxLineLength = ((Number)MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY().getDefaultValue()).intValue();
        this.ignoreWhenParameterCountGreaterOrEqualThanProperty = Integer.MAX_VALUE;
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.editorConfigIndent = new IndentConfig((PropertyType.IndentStyleValue)editorConfig.get(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY()), ((Number)editorConfig.get(IndentSizeEditorConfigPropertyKt.getINDENT_SIZE_PROPERTY())).intValue());
        this.maxLineLength = ((Number)editorConfig.get(MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY())).intValue();
        this.ignoreWhenParameterCountGreaterOrEqualThanProperty = ((Number)editorConfig.get(IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (this.editorConfigIndent.getDisabled()) {
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST()) && this.needToWrapArgumentList(node)) {
            void $this$forEach$iv;
            Sequence sequence = PsiUtilsKt.children((ASTNode)node);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode child = (ASTNode)element$iv;
                boolean bl = false;
                this.wrapArgumentInList(child, emit, autoCorrect);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needToWrapArgumentList(ASTNode node) {
        ASTNode aSTNode = node.getFirstChildNode();
        if (Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeNext()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getRPAR())) return false;
        ASTNode aSTNode2 = node.getTreeParent();
        if (Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) return false;
        Sequence $this$count$iv = PsiUtilsKt.children((ASTNode)node);
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        if (count$iv > this.ignoreWhenParameterCountGreaterOrEqualThanProperty) return false;
        if (this.textContainsIgnoringLambda(node, '\n')) return true;
        if (!this.exceedsMaxLineLength(node)) return false;
        return true;
    }

    private final boolean exceedsMaxLineLength(ASTNode $this$exceedsMaxLineLength) {
        return ASTNodeExtensionKt.lineLength((ASTNode)$this$exceedsMaxLineLength, (boolean)true) > this.maxLineLength && !$this$exceedsMaxLineLength.textContains('\n');
    }

    private final String intendedIndent(ASTNode child) {
        int n;
        ASTNode aSTNode = child.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
        if (this.hasTypeArgumentListInFront(aSTNode)) {
            n = -1;
        } else {
            ASTNode aSTNode2 = child.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"getTreeParent(...)");
            n = this.isPartOfDotQualifiedAssignmentExpression(aSTNode2) ? -1 : 0;
        }
        int it = n;
        boolean bl = false;
        ASTNode aSTNode3 = child.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"getTreeParent(...)");
        it = this.isOnSameLineAsControlFlowKeyword(aSTNode3) ? it + 1 : it;
        boolean bl2 = false;
        int indentLevelFix = Intrinsics.areEqual((Object)child.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) ? it + 1 : it;
        boolean bl3 = false;
        ASTNode aSTNode4 = child.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"getTreeParent(...)");
        int indentLevel = this.editorConfigIndent.indentLevelFrom(ASTNodeExtensionKt.indent((ASTNode)aSTNode4, (boolean)false)) + indentLevelFix;
        return '\n' + StringsKt.repeat((CharSequence)this.editorConfigIndent.getIndent(), (int)Math.max(indentLevel, 0));
    }

    private final void wrapArgumentInList(ASTNode child, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrect) {
        IElementType iElementType = child.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            ASTNode prevLeaf2 = ASTNodeExtensionKt.prevLeaf$default((ASTNode)child, (boolean)false, (int)1, null);
            if (prevLeaf2 instanceof PsiWhiteSpace && prevLeaf2.textContains('\n')) {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((PsiWhiteSpace)prevLeaf2).delete();
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            ASTNode prevLeaf3;
            String intendedIndent = this.intendedIndent(child);
            ASTNode aSTNode = this.prevWhiteSpaceWithNewLine(child);
            if (aSTNode == null) {
                aSTNode = ASTNodeExtensionKt.prevLeaf$default((ASTNode)child, (boolean)false, (int)1, null);
            }
            if ((prevLeaf3 = aSTNode) instanceof PsiWhiteSpace) {
                String string = prevLeaf3.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    return;
                }
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)prevLeaf3).rawReplaceWithText(intendedIndent);
                }
            } else {
                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                if (autoCorrect) {
                    child.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)intendedIndent), child);
                }
            }
        }
    }

    private final String errorMessage(ASTNode node) {
        String string;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            string = "Unnecessary newline before \"(\"";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) {
            string = "Argument should be on a separate line (unless all arguments can fit a single line)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            string = "Missing newline before \")\"";
        } else {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    private final boolean textContainsIgnoringLambda(ASTNode $this$textContainsIgnoringLambda, char c) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = PsiUtilsKt.children((ASTNode)$this$textContainsIgnoringLambda);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode child = (ASTNode)element$iv;
                boolean bl2 = false;
                boolean bl3 = this.isWhitespaceContaining(child, c) || this.isCollectionLiteralContaining(child, c) || this.isValueArgumentContaining(child, c);
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isWhitespaceContaining(ASTNode $this$isWhitespaceContaining, char c) {
        return Intrinsics.areEqual((Object)$this$isWhitespaceContaining.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && $this$isWhitespaceContaining.textContains(c);
    }

    private final boolean isCollectionLiteralContaining(ASTNode $this$isCollectionLiteralContaining, char c) {
        return Intrinsics.areEqual((Object)$this$isCollectionLiteralContaining.getElementType(), (Object)ElementType.INSTANCE.getCOLLECTION_LITERAL_EXPRESSION()) && $this$isCollectionLiteralContaining.textContains(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValueArgumentContaining(ASTNode $this$isValueArgumentContaining, char c) {
        ASTNode it;
        if (!Intrinsics.areEqual((Object)$this$isValueArgumentContaining.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) return false;
        Sequence $this$any$iv = PsiUtilsKt.children((ASTNode)$this$isValueArgumentContaining);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (ASTNode)element$iv;
            boolean bl = false;
        } while (!this.textContainsIgnoringLambda(it, c));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasTypeArgumentListInFront(ASTNode $this$hasTypeArgumentListInFront) {
        boolean bl;
        Sequence sequence;
        Object v1;
        block4: {
            ASTNode aSTNode = $this$hasTypeArgumentListInFront.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
            Sequence $this$firstOrNull$iv = PsiUtilsKt.children((ASTNode)aSTNode);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getTYPE_ARGUMENT_LIST())) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        ASTNode aSTNode = v1;
        if (aSTNode != null && (sequence = PsiUtilsKt.children((ASTNode)aSTNode)) != null) {
            boolean bl3;
            block5: {
                void $this$any$iv;
                Sequence $i$f$firstOrNull = sequence;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl4 = false;
                    if (!ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)it)) continue;
                    bl3 = true;
                    break block5;
                }
                bl3 = false;
            }
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfDotQualifiedAssignmentExpression(ASTNode $this$isPartOfDotQualifiedAssignmentExpression) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = $this$isPartOfDotQualifiedAssignmentExpression.getTreeParent();
        if (aSTNode2 == null) return false;
        ASTNode aSTNode3 = aSTNode2.getTreeParent();
        if (aSTNode3 == null) return false;
        ASTNode it = aSTNode = aSTNode3;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) return false;
        ASTNode aSTNode4 = aSTNode;
        ASTNode aSTNode5 = aSTNode4;
        if (aSTNode5 == null) return false;
        ASTNode binaryExpression = aSTNode5;
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)binaryExpression.getFirstChildNode().getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) return false;
        ASTNode aSTNode6 = binaryExpression.findChildByType(ElementType.INSTANCE.getOPERATION_REFERENCE());
        if (!Intrinsics.areEqual((Object)(aSTNode6 != null && (aSTNode6 = aSTNode6.getFirstChildNode()) != null ? aSTNode6.getElementType() : null), (Object)ElementType.INSTANCE.getEQ())) return false;
        return true;
    }

    private final ASTNode prevWhiteSpaceWithNewLine(ASTNode $this$prevWhiteSpaceWithNewLine) {
        ASTNode prev = ASTNodeExtensionKt.prevLeaf$default((ASTNode)$this$prevWhiteSpaceWithNewLine, (boolean)false, (int)1, null);
        while (prev != null && (ASTNodeExtensionKt.isWhiteSpace((ASTNode)prev) || ASTNodeExtensionKt.isPartOfComment((ASTNode)prev))) {
            if (ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)prev)) {
                return prev;
            }
            prev = ASTNodeExtensionKt.prevLeaf$default((ASTNode)prev, (boolean)false, (int)1, null);
        }
        return null;
    }

    private final boolean isOnSameLineAsControlFlowKeyword(ASTNode $this$isOnSameLineAsControlFlowKeyword) {
        Object object;
        PsiElement psiElement = $this$isOnSameLineAsControlFlowKeyword.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        PsiElement $this$getStrictParentOfType$iv = psiElement;
        boolean $i$f$getStrictParentOfType = false;
        KtContainerNode ktContainerNode = (KtContainerNode)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtContainerNode.class, (boolean)true);
        if (ktContainerNode == null) {
            return false;
        }
        KtContainerNode containerNode = ktContainerNode;
        if (Intrinsics.areEqual((Object)containerNode.getNode().getElementType(), (Object)ElementType.INSTANCE.getELSE())) {
            return false;
        }
        PsiElement parent = containerNode.getParent();
        if (parent instanceof KtIfExpression) {
            object = ((KtIfExpression)parent).getIfKeyword().getNode();
        } else if (parent instanceof KtWhileExpression) {
            object = ((KtWhileExpression)parent).getFirstChild().getNode();
        } else if (parent instanceof KtDoWhileExpression) {
            PsiElement psiElement2 = ((KtDoWhileExpression)parent).getWhileKeyword();
            object = psiElement2 != null ? psiElement2.getNode() : null;
        } else {
            object = null;
        }
        if (object == null) {
            return false;
        }
        ASTNode controlFlowKeyword = object;
        ASTNode aSTNode = ASTNodeExtensionKt.prevLeaf$default((ASTNode)$this$isOnSameLineAsControlFlowKeyword, (boolean)false, (int)1, null);
        if (aSTNode == null) {
            return false;
        }
        ASTNode prevLeaf2 = aSTNode;
        while (!Intrinsics.areEqual((Object)prevLeaf2, (Object)controlFlowKeyword)) {
            if (ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)prevLeaf2)) {
                return false;
            }
            if (ASTNodeExtensionKt.prevLeaf$default((ASTNode)prevLeaf2, (boolean)false, (int)1, null) != null) continue;
            return false;
        }
        return true;
    }

    static {
        Object[] objectArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "unset"};
        IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY = new EditorConfigProperty((PropertyType)new PropertyType.LowerCasingPropertyType("ktlint_argument_list_wrapping_ignore_when_parameter_count_greater_or_equal_than", "Do not wrap parameters on separate lines when at least the specified number of parameters are specified. Use 'unset' to always wrap each parameter.", PropertyType.PropertyValueParser.POSITIVE_INT_VALUE_PARSER, SetsKt.setOf((Object[])objectArray)), (Object)8, (Object)Integer.MAX_VALUE, null, null, (Function2)Companion.IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY.1.INSTANCE, (Function1)Companion.IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY.2.INSTANCE, null, null, null, 920, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/ArgumentListWrappingRule$Companion;", "", "()V", "IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "", "getIGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "UNSET_IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorConfigProperty<Integer> getIGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY() {
            return IGNORE_WHEN_PARAMETER_COUNT_GREATER_OR_EQUAL_THAN_PROPERTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

