/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.BackingPropertyNamingRule;
import com.pinterest.ktlint.ruleset.standard.rules.internal.RegExIgnoringDiacriticsAndStrokesOnLettersKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016Je\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00060\u000fH\u0016J]\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000b2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J]\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000b2K\u0010\u000e\u001aG\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\f\u0010\u001b\u001a\u00020\u0014*\u00020\u000bH\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u000b*\u00020\u000bH\u0002J\f\u0010\u001f\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010 \u001a\u00020\r*\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/BackingPropertyNamingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "codeStyle", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "visitBackingProperty", "identifier", "visitProperty", "property", "capitalizeFirstChar", "findCorrelatedFunction", "findCorrelatedProperty", "findCorrelatedPropertyOrFunction", "hasNonEmptyParameterList", "isPublic", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint(version="1.2.0", status=SinceKtlint.Status.EXPERIMENTAL)
@SourceDebugExtension(value={"SMAP\nBackingPropertyNamingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackingPropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/BackingPropertyNamingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,134:1\n1#2:135\n179#3,2:136\n179#3,2:138\n2159#3,2:140\n*S KotlinDebug\n*F\n+ 1 BackingPropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/BackingPropertyNamingRule\n*L\n97#1:136,2\n108#1:138,2\n115#1:140,2\n*E\n"})
public final class BackingPropertyNamingRule
extends StandardRule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private CodeStyleValue codeStyle = (CodeStyleValue)CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY().getDefaultValue();
    @NotNull
    private static final Regex BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("_[a-z][a-zA-Z0-9]*");

    public BackingPropertyNamingRule() {
        super("backing-property-naming", null, SetsKt.setOf((Object)CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY()), 2, null);
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.codeStyle = (CodeStyleValue)editorConfig.get(CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY());
    }

    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block0: {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(emit, (String)"emit");
            ASTNode it = aSTNode2 = node;
            boolean bl = false;
            Object object = aSTNode = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY()) ? aSTNode2 : null;
            if (aSTNode == null) break block0;
            ASTNode property = aSTNode;
            boolean bl2 = false;
            this.visitProperty(property, emit);
        }
    }

    private final void visitProperty(ASTNode property, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block1: {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            ASTNode aSTNode3 = property.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
            if (aSTNode3 == null) break block1;
            ASTNode it = aSTNode2 = aSTNode3;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Object object = aSTNode = StringsKt.startsWith$default((String)string, (String)"_", (boolean)false, (int)2, null) ? aSTNode2 : null;
            if (aSTNode != null) {
                ASTNode identifier = aSTNode;
                boolean bl2 = false;
                this.visitBackingProperty(identifier, emit);
            }
        }
    }

    private final void visitBackingProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        ASTNode correlatedPropertyOrFunction;
        String string;
        String string2;
        String it = string2 = identifier.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string3 = string = !BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP.matches((CharSequence)it) ? string2 : null;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property should start with underscore followed by lower camel case", (Object)false);
        }
        ASTNode aSTNode = identifier.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeParent(...)");
        if (!ASTNodeExtensionKt.hasModifier((ASTNode)aSTNode, (IElementType)ElementType.INSTANCE.getPRIVATE_KEYWORD())) {
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property not allowed when 'private' modifier is missing", (Object)false);
        }
        if ((correlatedPropertyOrFunction = this.findCorrelatedPropertyOrFunction(identifier)) == null) {
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property is only allowed when a matching property or function exists", (Object)false);
        } else {
            if (this.codeStyle == CodeStyleValue.android_studio || this.isPublic(correlatedPropertyOrFunction)) {
                return;
            }
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property is only allowed when the matching property or function is public", (Object)false);
        }
    }

    private final ASTNode findCorrelatedPropertyOrFunction(ASTNode $this$findCorrelatedPropertyOrFunction) {
        ASTNode aSTNode = this.findCorrelatedProperty($this$findCorrelatedPropertyOrFunction);
        if (aSTNode == null) {
            aSTNode = this.findCorrelatedFunction($this$findCorrelatedPropertyOrFunction);
        }
        return aSTNode;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ASTNode findCorrelatedProperty(ASTNode $this$findCorrelatedProperty) {
        Object v2;
        block1: {
            void $this$firstOrNull$iv;
            ASTNode aSTNode = $this$findCorrelatedProperty.getTreeParent();
            if (aSTNode == null) return null;
            ASTNode aSTNode2 = aSTNode.getTreeParent();
            if (aSTNode2 == null) return null;
            Sequence sequence = ASTNodeExtensionKt.children((ASTNode)aSTNode2);
            if (sequence == null) return null;
            Sequence sequence2 = SequencesKt.filter((Sequence)sequence, (Function1)findCorrelatedProperty.1.INSTANCE);
            if (sequence2 == null) return null;
            Sequence sequence3 = SequencesKt.mapNotNull((Sequence)sequence2, (Function1)findCorrelatedProperty.2.INSTANCE);
            if (sequence3 == null) return null;
            Sequence sequence4 = sequence3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                String string = it.getText();
                String string2 = $this$findCorrelatedProperty.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (!Intrinsics.areEqual((Object)string, (Object)StringsKt.removePrefix((String)string2, (CharSequence)"_"))) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        ASTNode aSTNode = v2;
        if (aSTNode == null) return null;
        ASTNode aSTNode3 = aSTNode.getTreeParent();
        return aSTNode3;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ASTNode findCorrelatedFunction(ASTNode $this$findCorrelatedFunction) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            String correlatedFunctionName = "get" + this.capitalizeFirstChar($this$findCorrelatedFunction);
            ASTNode aSTNode = $this$findCorrelatedFunction.getTreeParent();
            if (aSTNode == null) return null;
            ASTNode aSTNode2 = aSTNode.getTreeParent();
            if (aSTNode2 == null) return null;
            Sequence sequence = ASTNodeExtensionKt.children((ASTNode)aSTNode2);
            if (sequence == null) return null;
            Sequence sequence2 = SequencesKt.filter((Sequence)sequence, (Function1)findCorrelatedFunction.1.INSTANCE);
            if (sequence2 == null) return null;
            Sequence sequence3 = SequencesKt.filter((Sequence)sequence2, (Function1)((Function1)new Function1<ASTNode, Boolean>(this){
                final /* synthetic */ BackingPropertyNamingRule this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return BackingPropertyNamingRule.access$hasNonEmptyParameterList(this.this$0, it);
                }
            }));
            if (sequence3 == null) return null;
            Sequence sequence4 = SequencesKt.mapNotNull((Sequence)sequence3, (Function1)findCorrelatedFunction.3.INSTANCE);
            if (sequence4 == null) return null;
            Sequence sequence5 = sequence4;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)correlatedFunctionName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        ASTNode aSTNode = v0;
        if (aSTNode == null) return null;
        ASTNode aSTNode3 = aSTNode.getTreeParent();
        return aSTNode3;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNonEmptyParameterList(ASTNode $this$hasNonEmptyParameterList) {
        boolean bl;
        block3: {
            Sequence sequence;
            ASTNode aSTNode = $this$hasNonEmptyParameterList.findChildByType(ElementType.INSTANCE.getVALUE_PARAMETER_LIST());
            if (aSTNode != null && (sequence = ASTNodeExtensionKt.children((ASTNode)aSTNode)) != null) {
                void $this$none$iv;
                Sequence sequence2 = sequence;
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String capitalizeFirstChar(ASTNode $this$capitalizeFirstChar) {
        String string;
        String string2 = $this$capitalizeFirstChar.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = StringsKt.removePrefix((String)string2, (CharSequence)"_");
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string4 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string5);
            String string6 = string3;
            int n = 1;
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            string = stringBuilder2.append(string7).toString();
        } else {
            string = string3;
        }
        return string;
    }

    private final boolean isPublic(ASTNode $this$isPublic) {
        return !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isPublic, (IElementType)ElementType.INSTANCE.getPRIVATE_KEYWORD()) && !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isPublic, (IElementType)ElementType.INSTANCE.getPROTECTED_KEYWORD()) && !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isPublic, (IElementType)ElementType.INSTANCE.getINTERNAL_KEYWORD());
    }

    public static final /* synthetic */ boolean access$hasNonEmptyParameterList(BackingPropertyNamingRule $this, ASTNode $receiver) {
        return $this.hasNonEmptyParameterList($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/BackingPropertyNamingRule$Companion;", "", "()V", "BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP", "Lkotlin/text/Regex;", "getBACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP", "()Lkotlin/text/Regex;", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getBACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP() {
            return BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

