/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.NoConsecutiveCommentsRule;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003Je\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2K\u0010\n\u001aG\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00050\u000bH\u0016J\f\u0010\u0013\u001a\u00020\u0010*\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\u00020\t*\u0004\u0018\u00010\u0007H\u0002J\u000e\u0010\u0015\u001a\u00020\t*\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/NoConsecutiveCommentsRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule$OfficialCodeStyle;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "commentType", "isEndOfComment", "isStartOfComment", "ktlint-ruleset-standard"})
@SinceKtlint.Container(value={@SinceKtlint(version="0.49", status=SinceKtlint.Status.EXPERIMENTAL), @SinceKtlint(version="1.0", status=SinceKtlint.Status.STABLE)})
@SourceDebugExtension(value={"SMAP\nNoConsecutiveCommentsRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoConsecutiveCommentsRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/NoConsecutiveCommentsRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,166:1\n1#2:167\n1099#3,3:168\n*S KotlinDebug\n*F\n+ 1 NoConsecutiveCommentsRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/NoConsecutiveCommentsRule\n*L\n109#1:168,3\n*E\n"})
public final class NoConsecutiveCommentsRule
extends StandardRule
implements Rule.OfficialCodeStyle {
    public NoConsecutiveCommentsRule() {
        super("no-consecutive-comments", null, null, 6, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        ASTNode it = aSTNode2 = node;
        boolean bl = false;
        ASTNode aSTNode3 = this.isStartOfComment(it) ? aSTNode2 : null;
        if (aSTNode3 == null) return;
        aSTNode2 = ASTNodeExtensionKt.prevLeaf((ASTNode)aSTNode3, (Function1)beforeVisitChildNodes.2.INSTANCE);
        if (aSTNode2 == null) return;
        ASTNode previousNonWhiteSpace = aSTNode = aSTNode2;
        boolean bl2 = false;
        ASTNode aSTNode4 = this.isEndOfComment(previousNonWhiteSpace) ? aSTNode : null;
        if (aSTNode4 == null) return;
        ASTNode previousComment = aSTNode4;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)previousComment.getElementType(), (Object)ElementType.INSTANCE.getKDOC_END()) && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getKDOC_START())) {
            emit.invoke((Object)node.getStartOffset(), (Object)(this.commentType(node) + " may not be preceded by " + this.commentType(previousComment)), (Object)false);
            return;
        }
        if (Intrinsics.areEqual((Object)previousComment.getElementType(), (Object)ElementType.INSTANCE.getKDOC_END()) && !Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getKDOC_START())) {
            emit.invoke((Object)node.getStartOffset(), (Object)(this.commentType(node) + " may not be preceded by " + this.commentType(previousComment) + ". Reversed order is allowed though when separated by a newline."), (Object)false);
            return;
        }
        if (Intrinsics.areEqual((Object)previousComment.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT()) && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) {
            emit.invoke((Object)node.getStartOffset(), (Object)(this.commentType(node) + " may not be preceded by " + this.commentType(previousComment)), (Object)false);
            return;
        }
        if (Intrinsics.areEqual((Object)previousComment.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT()) && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)previousComment.getElementType(), (Object)node.getElementType())) {
            ASTNode aSTNode5;
            ASTNode it2 = aSTNode5 = ASTNodeExtensionKt.prevLeaf$default((ASTNode)node, (boolean)false, (int)1, null);
            boolean bl4 = false;
            Object object = ASTNodeExtensionKt.isWhiteSpace((ASTNode)it2) ? aSTNode5 : null;
            String string = object != null ? object.getText() : null;
            if (string == null) {
                string = "";
            }
            CharSequence charSequence = string;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it3 = element$iv = charSequence.charAt(i);
                boolean bl5 = false;
                if (!(it3 == '\n')) continue;
                ++count$iv;
            }
            if (count$iv > 1) {
                return;
            }
        }
        emit.invoke((Object)node.getStartOffset(), (Object)(this.commentType(node) + " may not be preceded by " + this.commentType(previousComment) + " unless separated by a blank line"), (Object)false);
    }

    private final boolean isStartOfComment(ASTNode $this$isStartOfComment) {
        ASTNode aSTNode = $this$isStartOfComment;
        IElementType iElementType = aSTNode != null ? aSTNode.getElementType() : null;
        return (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEOL_COMMENT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getKDOC_START());
    }

    private final boolean isEndOfComment(ASTNode $this$isEndOfComment) {
        ASTNode aSTNode = $this$isEndOfComment;
        IElementType iElementType = aSTNode != null ? aSTNode.getElementType() : null;
        return (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEOL_COMMENT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getKDOC_END());
    }

    private final String commentType(ASTNode $this$commentType) {
        String string;
        IElementType iElementType = $this$commentType.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEOL_COMMENT())) {
            string = "an EOL comment";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) {
            string = "a block comment";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getKDOC_START()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getKDOC_END())) {
            string = "a KDoc";
        } else {
            String string2 = $this$commentType.getElementType().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        }
        return string;
    }
}

