/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.NoTrailingSpacesRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2K\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\nH\u0016J\f\u0010\u0012\u001a\u00020\b*\u00020\u000fH\u0002J\f\u0010\u0013\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u0014\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/NoTrailingSpacesRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "hasTrailingSpace", "hasTrailingSpacesBeforeNewline", "isPartOfKDoc", "removeTrailingSpacesBeforeNewline", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint(version="0.1", status=SinceKtlint.Status.STABLE)
@SourceDebugExtension(value={"SMAP\nNoTrailingSpacesRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoTrailingSpacesRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/NoTrailingSpacesRule\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n384#2,4:93\n1559#3:97\n1590#3,4:98\n*S KotlinDebug\n*F\n+ 1 NoTrailingSpacesRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/NoTrailingSpacesRule\n*L\n30#1:93,4\n44#1:97\n44#1:98,4\n*E\n"})
public final class NoTrailingSpacesRule
extends StandardRule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex SPACE_OR_TAB_BEFORE_NEWLINE_REGEX = new Regex(" +\\n");

    public NoTrailingSpacesRule() {
        super("no-trailing-spaces", null, null, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public void beforeVisitChildNodes(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (this.isPartOfKDoc(node)) {
            if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && this.hasTrailingSpacesBeforeNewline(node)) {
                String string;
                block13: {
                    String string2 = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    int offsetOfSpaceBeforeNewlineInText = StringsKt.indexOf$default((CharSequence)string2, (String)" \n", (int)0, (boolean)false, (int)6, null);
                    String string3 = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    String string4 = StringsKt.take((String)string3, (int)offsetOfSpaceBeforeNewlineInText);
                    boolean $i$f$dropLastWhile = false;
                    for (int index$iv = StringsKt.getLastIndex((CharSequence)((CharSequence)$this$dropLastWhile$iv)); -1 < index$iv; --index$iv) {
                        void $this$dropLastWhile$iv;
                        char it22 = $this$dropLastWhile$iv.charAt(index$iv);
                        int n = 0;
                        if (it22 == ' ') continue;
                        void it22 = $this$dropLastWhile$iv;
                        n = 0;
                        int n2 = index$iv + 1;
                        String string5 = it22.substring(n, n2);
                        string = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        break block13;
                    }
                    string = "";
                }
                int offsetOfFirstSpaceBeforeNewlineInText = string.length();
                emit.invoke((Object)(node.getStartOffset() + offsetOfFirstSpaceBeforeNewlineInText), (Object)"Trailing space(s)", (Object)true);
                if (autoCorrect) {
                    this.removeTrailingSpacesBeforeNewline(node);
                }
            }
        } else if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || ASTNodeExtensionKt.isPartOfComment((ASTNode)node)) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] offsetOfFirstSpaceBeforeNewlineInText = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)string, (String[])offsetOfFirstSpaceBeforeNewlineInText, (boolean)false, (int)0, (int)6, null);
            boolean violated = false;
            int violationOffset = 0;
            violationOffset = node.getStartOffset();
            Iterable index$iv = lines;
            boolean $i$f$mapIndexed = false;
            void n = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                String string6;
                void line;
                void index;
                int n3;
                if ((n3 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string7 = (String)item$iv$iv;
                int n4 = n3;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT()) && index == lines.size() - 1 && ASTNodeExtensionKt.nextLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null) != null) {
                    string6 = line;
                } else if (this.hasTrailingSpace((String)line)) {
                    String modifiedLine = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)line))).toString();
                    int firstTrailingSpaceOffset = violationOffset + modifiedLine.length();
                    emit.invoke((Object)firstTrailingSpaceOffset, (Object)"Trailing space(s)", (Object)true);
                    violated = true;
                    string6 = modifiedLine;
                } else {
                    string6 = line;
                }
                void modifiedLine = string6;
                violationOffset += line.length() + 1;
                collection.add(modifiedLine);
            }
            List modifiedLines = (List)destination$iv$iv;
            if (violated && autoCorrect) {
                ((LeafPsiElement)node).rawReplaceWithText(CollectionsKt.joinToString$default((Iterable)modifiedLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
        }
    }

    private final boolean isPartOfKDoc(ASTNode $this$isPartOfKDoc) {
        return ASTNodeExtensionKt.parent((ASTNode)$this$isPartOfKDoc, (boolean)false, (Function1)isPartOfKDoc.1.INSTANCE) != null;
    }

    private final boolean hasTrailingSpacesBeforeNewline(ASTNode $this$hasTrailingSpacesBeforeNewline) {
        String string = $this$hasTrailingSpacesBeforeNewline.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        return SPACE_OR_TAB_BEFORE_NEWLINE_REGEX.containsMatchIn(charSequence);
    }

    private final void removeTrailingSpacesBeforeNewline(ASTNode $this$removeTrailingSpacesBeforeNewline) {
        String string = $this$removeTrailingSpacesBeforeNewline.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        Regex regex = SPACE_OR_TAB_BEFORE_NEWLINE_REGEX;
        String string2 = "\n";
        String newText = regex.replace(charSequence, string2);
        Intrinsics.checkNotNull((Object)$this$removeTrailingSpacesBeforeNewline, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        ((LeafPsiElement)$this$removeTrailingSpacesBeforeNewline).rawReplaceWithText(newText);
    }

    private final boolean hasTrailingSpace(String $this$hasTrailingSpace) {
        return Intrinsics.areEqual((Object)StringsKt.takeLast((String)$this$hasTrailingSpace, (int)1), (Object)" ");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/NoTrailingSpacesRule$Companion;", "", "()V", "SPACE_OR_TAB_BEFORE_NEWLINE_REGEX", "Lkotlin/text/Regex;", "getSPACE_OR_TAB_BEFORE_NEWLINE_REGEX", "()Lkotlin/text/Regex;", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSPACE_OR_TAB_BEFORE_NEWLINE_REGEX() {
            return SPACE_OR_TAB_BEFORE_NEWLINE_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

