/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.RuleAutocorrectApproveHandler;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001!B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J]\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u000f\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0010H\u0016J]\u0010\u0019\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u001a\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0010H\u0002J]\u0010\u001b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u001a\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0010H\u0002J\f\u0010\u001c\u001a\u00020\u0007*\u00020\u000eH\u0002J\f\u0010\u001d\u001a\u00020\u0007*\u00020\u000eH\u0002J\f\u0010\u001e\u001a\u00020\u0007*\u00020\u000eH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002J]\u0010 \u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u001a\u001aG\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/BlankLineBetweenWhenConditions;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "Lcom/pinterest/ktlint/rule/engine/core/api/RuleAutocorrectApproveHandler;", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule$Experimental;", "<init>", "()V", "lineBreakAfterWhenCondition", "", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "visitWhenStatement", "emitAndApprove", "addBlankLinesBetweenWhenConditions", "containsBlankLine", "hasAnyMultilineWhenCondition", "isPrecededByComment", "findWhitespaceAfterPreviousCodeSibling", "removeBlankLinesBetweenWhenConditions", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint(version="1.2.0", status=SinceKtlint.Status.EXPERIMENTAL)
@SourceDebugExtension(value={"SMAP\nBlankLineBetweenWhenConditions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlankLineBetweenWhenConditions.kt\ncom/pinterest/ktlint/ruleset/standard/rules/BlankLineBetweenWhenConditions\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 AutocorrectDecision.kt\ncom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecisionKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 ASTNodeExtension.kt\ncom/pinterest/ktlint/rule/engine/core/api/ASTNodeExtensionKt\n*L\n1#1,155:1\n1317#2:156\n1318#2:161\n1251#2,2:165\n1317#2:175\n1318#2:179\n1#3:157\n1#3:160\n1#3:178\n19#4:158\n18#4:159\n19#4:176\n18#4:177\n1104#5,3:162\n132#6,8:167\n*S KotlinDebug\n*F\n+ 1 BlankLineBetweenWhenConditions.kt\ncom/pinterest/ktlint/ruleset/standard/rules/BlankLineBetweenWhenConditions\n*L\n80#1:156\n80#1:161\n100#1:165,2\n118#1:175\n118#1:179\n89#1:160\n127#1:178\n89#1:158\n89#1:159\n127#1:176\n127#1:177\n96#1:162,3\n102#1:167,8\n*E\n"})
public final class BlankLineBetweenWhenConditions
extends StandardRule
implements RuleAutocorrectApproveHandler,
Rule.Experimental {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean lineBreakAfterWhenCondition = (Boolean)LINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY.getDefaultValue();
    @NotNull
    private static final Set<String> BOOLEAN_VALUES_SET;
    @NotNull
    private static final EditorConfigProperty<Boolean> LINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY;

    public BlankLineBetweenWhenConditions() {
        super("blank-line-between-when-conditions", null, SetsKt.setOf(LINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY), 2, null);
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.lineBreakAfterWhenCondition = (Boolean)editorConfig.get(LINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY);
    }

    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, @NotNull Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHEN())) {
            this.visitWhenStatement(node, emit);
        }
    }

    private final void visitWhenStatement(ASTNode node, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emitAndApprove) {
        boolean hasMultilineWhenCondition = this.hasAnyMultilineWhenCondition(node);
        if (hasMultilineWhenCondition && this.lineBreakAfterWhenCondition) {
            this.addBlankLinesBetweenWhenConditions(node, emitAndApprove);
        } else {
            this.removeBlankLinesBetweenWhenConditions(node, emitAndApprove);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addBlankLinesBetweenWhenConditions(ASTNode node, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emitAndApprove) {
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)SequencesKt.filter((Sequence)ASTNodeExtensionKt.children((ASTNode)node), BlankLineBetweenWhenConditions::addBlankLinesBetweenWhenConditions$lambda$0), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$ifAutocorrectAllowed$iv;
            ASTNode aSTNode;
            ASTNode whenEntry = (ASTNode)element$iv;
            boolean bl = false;
            ASTNode aSTNode2 = this.findWhitespaceAfterPreviousCodeSibling(whenEntry);
            if (aSTNode2 == null) continue;
            ASTNode it = aSTNode = aSTNode2;
            boolean bl2 = false;
            Object object = !this.containsBlankLine(it) ? aSTNode : null;
            if (object == null) continue;
            ASTNode whitespaceBeforeWhenEntry = object;
            boolean bl3 = false;
            AutocorrectDecision autocorrectDecision = (AutocorrectDecision)emitAndApprove.invoke((Object)(whitespaceBeforeWhenEntry.getStartOffset() + 1), (Object)"Add a blank line between all when-conditions in case at least one multiline when-condition is found in the statement", (Object)true);
            boolean $i$f$ifAutocorrectAllowed = false;
            void var16_16 = $this$ifAutocorrectAllowed$iv;
            Object it$iv = var16_16;
            boolean bl4 = false;
            Object object2 = $this$ifAutocorrectAllowed$iv == AutocorrectDecision.ALLOW_AUTOCORRECT ? var16_16 : null;
            if (object2 == null) continue;
            it$iv = object2;
            boolean bl5 = false;
            boolean bl6 = false;
            ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)whitespaceBeforeWhenEntry, (String)('\n' + ASTNodeExtensionKt.indent$default((ASTNode)whenEntry, (boolean)false, (int)1, null)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsBlankLine(ASTNode $this$containsBlankLine) {
        if (!Intrinsics.areEqual((Object)$this$containsBlankLine.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) return false;
        String string = $this$containsBlankLine.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence $this$count$iv = string;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        if (count$iv <= true) return false;
        return true;
    }

    private final boolean hasAnyMultilineWhenCondition(ASTNode $this$hasAnyMultilineWhenCondition) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = ASTNodeExtensionKt.children((ASTNode)$this$hasAnyMultilineWhenCondition);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHEN_ENTRY()) && (it.textContains('\n') || this.isPrecededByComment(it)))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isPrecededByComment(ASTNode $this$isPrecededByComment) {
        ASTNode aSTNode;
        block1: {
            ASTNode $this$prevSibling$iv = $this$isPrecededByComment;
            boolean $i$f$prevSibling = false;
            for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                ASTNode it = n$iv;
                boolean bl = false;
                if (!(!ASTNodeExtensionKt.isWhiteSpace((ASTNode)it))) continue;
                aSTNode = n$iv;
                break block1;
            }
            aSTNode = null;
        }
        return aSTNode != null ? ASTNodeExtensionKt.isPartOfComment(aSTNode) : false;
    }

    private final ASTNode findWhitespaceAfterPreviousCodeSibling(ASTNode $this$findWhitespaceAfterPreviousCodeSibling) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = ASTNodeExtensionKt.prevCodeSibling((ASTNode)$this$findWhitespaceAfterPreviousCodeSibling);
        return aSTNode2 != null && (aSTNode = ASTNodeExtensionKt.lastChildLeafOrSelf((ASTNode)aSTNode2)) != null ? ASTNodeExtensionKt.nextLeaf((ASTNode)aSTNode, BlankLineBetweenWhenConditions::findWhitespaceAfterPreviousCodeSibling$lambda$8) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeBlankLinesBetweenWhenConditions(ASTNode node, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emitAndApprove) {
        Sequence $this$forEach$iv = SequencesKt.drop((Sequence)SequencesKt.filter((Sequence)ASTNodeExtensionKt.children((ASTNode)node), BlankLineBetweenWhenConditions::removeBlankLinesBetweenWhenConditions$lambda$9), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$ifAutocorrectAllowed$iv;
            ASTNode aSTNode;
            ASTNode whenEntry = (ASTNode)element$iv;
            boolean bl = false;
            ASTNode aSTNode2 = this.findWhitespaceAfterPreviousCodeSibling(whenEntry);
            if (aSTNode2 == null) continue;
            ASTNode it = aSTNode = aSTNode2;
            boolean bl2 = false;
            Object object = this.containsBlankLine(it) ? aSTNode : null;
            if (object == null) continue;
            ASTNode whitespaceBeforeWhenEntry = object;
            boolean bl3 = false;
            AutocorrectDecision autocorrectDecision = (AutocorrectDecision)emitAndApprove.invoke((Object)(whitespaceBeforeWhenEntry.getStartOffset() + 1), (Object)"Unexpected blank lines between when-condition if all when-conditions are single lines", (Object)true);
            boolean $i$f$ifAutocorrectAllowed = false;
            void var16_16 = $this$ifAutocorrectAllowed$iv;
            Object it$iv = var16_16;
            boolean bl4 = false;
            Object object2 = $this$ifAutocorrectAllowed$iv == AutocorrectDecision.ALLOW_AUTOCORRECT ? var16_16 : null;
            if (object2 == null) continue;
            it$iv = object2;
            boolean bl5 = false;
            boolean bl6 = false;
            ASTNodeExtensionKt.upsertWhitespaceBeforeMe((ASTNode)whitespaceBeforeWhenEntry, (String)('\n' + ASTNodeExtensionKt.indent((ASTNode)whenEntry, (boolean)false)));
        }
    }

    private static final boolean addBlankLinesBetweenWhenConditions$lambda$0(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHEN_ENTRY());
    }

    private static final boolean findWhitespaceAfterPreviousCodeSibling$lambda$8(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ASTNodeExtensionKt.isWhiteSpace((ASTNode)it);
    }

    private static final boolean removeBlankLinesBetweenWhenConditions$lambda$9(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHEN_ENTRY());
    }

    static {
        Object[] objectArray = new String[]{"true", "false"};
        BOOLEAN_VALUES_SET = SetsKt.setOf((Object[])objectArray);
        LINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY = new EditorConfigProperty((PropertyType)new PropertyType.LowerCasingPropertyType("ij_kotlin_line_break_after_multiline_when_entry", "Defines whether a blank line is to be added after a when entry. Contrary to default IDEA formatting, ktlint adds the blank line between all when-conditions if the when-statement contains at least one multiline when-condition. Or, it removes all blank lines between the when-conditions if the when-statement does not contain any multiline when-condition.", PropertyType.PropertyValueParser.BOOLEAN_VALUE_PARSER, BOOLEAN_VALUES_SET), (Object)true, null, null, null, null, null, null, null, null, 1020, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/BlankLineBetweenWhenConditions$Companion;", "", "<init>", "()V", "BOOLEAN_VALUES_SET", "", "", "LINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "", "getLINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorConfigProperty<Boolean> getLINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY() {
            return LINE_BREAK_AFTER_WHEN_CONDITION_PROPERTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

