/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.MaxLineLengthEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.MaxLineLengthRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.TrailingCommaOnCallSiteRuleKt;
import com.pinterest.ktlint.ruleset.standard.rules.TrailingCommaOnDeclarationSiteRuleKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.ec4j.core.model.PropertyType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J]\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2K\u0010\u000f\u001aG\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0010H\u0016J\f\u0010\u0018\u001a\u00020\u0005*\u00020\u000eH\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u000eH\u0002J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u000eH\u0002J\f\u0010\u001b\u001a\u00020\u0007*\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/MaxLineLengthRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "<init>", "()V", "maxLineLength", "", "ignoreBackTickedIdentifier", "", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "lineLength", "isPartOfRawMultiLineString", "isLineOnlyContainingSingleTemplateString", "isLineOnlyContainingComment", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint(version="0.9", status=SinceKtlint.Status.STABLE)
@SourceDebugExtension(value={"SMAP\nMaxLineLengthRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxLineLengthRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/MaxLineLengthRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class MaxLineLengthRule
extends StandardRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int maxLineLength;
    private boolean ignoreBackTickedIdentifier;
    @NotNull
    private static final EditorConfigProperty<Boolean> IGNORE_BACKTICKED_IDENTIFIER_PROPERTY;
    @NotNull
    private static final Regex BACKTICKED_IDENTIFIER_REGEX;

    public MaxLineLengthRule() {
        Object[] objectArray = new Rule.VisitorModifier[]{new Rule.VisitorModifier.RunAfterRule(TrailingCommaOnCallSiteRuleKt.getTRAILING_COMMA_ON_CALL_SITE_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), new Rule.VisitorModifier.RunAfterRule(TrailingCommaOnDeclarationSiteRuleKt.getTRAILING_COMMA_ON_DECLARATION_SITE_RULE_ID(), Rule.VisitorModifier.RunAfterRule.Mode.REGARDLESS_WHETHER_RUN_AFTER_RULE_IS_LOADED_OR_DISABLED), Rule.VisitorModifier.RunAsLateAsPossible.INSTANCE};
        Set set = SetsKt.setOf((Object[])objectArray);
        objectArray = new EditorConfigProperty[]{MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY(), IGNORE_BACKTICKED_IDENTIFIER_PROPERTY};
        super("max-line-length", set, SetsKt.setOf((Object[])objectArray));
        this.maxLineLength = ((Number)MaxLineLengthEditorConfigPropertyKt.getMAX_LINE_LENGTH_PROPERTY().getDefaultValue()).intValue();
        this.ignoreBackTickedIdentifier = (Boolean)IGNORE_BACKTICKED_IDENTIFIER_PROPERTY.getDefaultValue();
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.ignoreBackTickedIdentifier = (Boolean)editorConfig.get(IGNORE_BACKTICKED_IDENTIFIER_PROPERTY);
        this.maxLineLength = MaxLineLengthRuleKt.maxLineLength(editorConfig);
        if (this.maxLineLength == Integer.MAX_VALUE) {
            this.stopTraversalOfAST();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, @NotNull Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode aSTNode3;
        ASTNode aSTNode4;
        ASTNode aSTNode5;
        ASTNode aSTNode6;
        ASTNode aSTNode7;
        ASTNode aSTNode8;
        ASTNode aSTNode9;
        ASTNode aSTNode10;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        if (ASTNodeExtensionKt.isWhiteSpace((ASTNode)node)) {
            return;
        }
        ASTNode it = aSTNode10 = node;
        boolean bl = false;
        if (!(it instanceof LeafPsiElement)) return;
        ASTNode aSTNode11 = aSTNode10;
        ASTNode aSTNode12 = aSTNode11;
        if (aSTNode12 == null) return;
        ASTNode it2 = aSTNode9 = aSTNode12;
        boolean bl2 = false;
        if (ASTNodeExtensionKt.nextLeaf$default((ASTNode)it2, (boolean)false, (boolean)false, (int)3, null) != null) {
            if (!ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)ASTNodeExtensionKt.nextLeaf$default((ASTNode)it2, (boolean)false, (boolean)false, (int)3, null))) return;
        }
        boolean bl3 = true;
        if (!bl3) return;
        ASTNode aSTNode13 = aSTNode9;
        aSTNode10 = aSTNode13;
        if (aSTNode10 == null) return;
        ASTNode it3 = aSTNode8 = aSTNode10;
        boolean bl4 = false;
        if (this.lineLength(it3) <= this.maxLineLength) return;
        boolean bl5 = true;
        if (!bl5) return;
        ASTNode aSTNode14 = aSTNode8;
        aSTNode9 = aSTNode14;
        if (aSTNode9 == null) return;
        ASTNode it4 = aSTNode7 = aSTNode9;
        boolean bl6 = false;
        if (ASTNodeExtensionKt.isPartOf((ASTNode)it4, (KClass)Reflection.getOrCreateKotlinClass(KtPackageDirective.class))) return;
        ASTNode aSTNode15 = aSTNode7;
        aSTNode8 = aSTNode15;
        if (aSTNode8 == null) return;
        ASTNode it5 = aSTNode6 = aSTNode8;
        boolean bl7 = false;
        if (ASTNodeExtensionKt.isPartOf((ASTNode)it5, (KClass)Reflection.getOrCreateKotlinClass(KtImportDirective.class))) return;
        ASTNode aSTNode16 = aSTNode6;
        aSTNode7 = aSTNode16;
        if (aSTNode7 == null) return;
        ASTNode it6 = aSTNode5 = aSTNode7;
        boolean bl8 = false;
        if (ASTNodeExtensionKt.isPartOf((ASTNode)it6, (KClass)Reflection.getOrCreateKotlinClass(KDoc.class))) return;
        ASTNode aSTNode17 = aSTNode5;
        aSTNode6 = aSTNode17;
        if (aSTNode6 == null) return;
        ASTNode it7 = aSTNode4 = aSTNode6;
        boolean bl9 = false;
        if (this.isPartOfRawMultiLineString(it7)) return;
        ASTNode aSTNode18 = aSTNode4;
        aSTNode5 = aSTNode18;
        if (aSTNode5 == null) return;
        ASTNode it8 = aSTNode3 = aSTNode5;
        boolean bl10 = false;
        if (this.isLineOnlyContainingSingleTemplateString(it8)) return;
        ASTNode aSTNode19 = aSTNode3;
        aSTNode4 = aSTNode19;
        if (aSTNode4 == null) return;
        ASTNode it9 = aSTNode2 = aSTNode4;
        boolean bl11 = false;
        if (Intrinsics.areEqual((Object)it9.getElementType(), (Object)ElementType.INSTANCE.getCOMMA())) {
            ASTNode aSTNode20 = ASTNodeExtensionKt.prevLeaf$default((ASTNode)it9, (boolean)false, (int)1, null);
            if (aSTNode20 != null ? this.isLineOnlyContainingSingleTemplateString(aSTNode20) : false) {
                return;
            }
        }
        boolean bl12 = false;
        if (bl12) return;
        ASTNode aSTNode21 = aSTNode2;
        aSTNode3 = aSTNode21;
        if (aSTNode3 == null) return;
        ASTNode it10 = aSTNode = aSTNode3;
        boolean bl13 = false;
        if (this.isLineOnlyContainingComment(it10)) return;
        ASTNode aSTNode22 = aSTNode;
        aSTNode2 = aSTNode22;
        if (aSTNode2 == null) return;
        it10 = aSTNode2;
        boolean bl14 = false;
        int offset = ((ASTNode)SequencesKt.first((Sequence)ASTNodeExtensionKt.leavesOnLine((ASTNode)node, (boolean)false))).getStartOffset() + (this.maxLineLength + 1);
        AutocorrectDecision cfr_ignored_0 = (AutocorrectDecision)emit.invoke((Object)offset, (Object)("Exceeded max line length (" + this.maxLineLength + ')'), (Object)false);
    }

    private final int lineLength(ASTNode $this$lineLength) {
        return ASTNodeExtensionKt.lineLengthWithoutNewlinePrefix((Sequence)SequencesKt.filterNot((Sequence)ASTNodeExtensionKt.leavesOnLine((ASTNode)$this$lineLength, (boolean)false), arg_0 -> MaxLineLengthRule.lineLength$lambda$11(this, arg_0)));
    }

    private final boolean isPartOfRawMultiLineString(ASTNode $this$isPartOfRawMultiLineString) {
        boolean bl;
        ASTNode aSTNode = ASTNodeExtensionKt.parent((ASTNode)$this$isPartOfRawMultiLineString, (IElementType)ElementType.INSTANCE.getSTRING_TEMPLATE(), (boolean)false);
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)it.getFirstChildNode().getText(), (Object)"\"\"\"") && it.textContains('\n');
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLineOnlyContainingSingleTemplateString(ASTNode $this$isLineOnlyContainingSingleTemplateString) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = $this$isLineOnlyContainingSingleTemplateString.getTreeParent();
        if (aSTNode2 == null) return false;
        ASTNode it = aSTNode = aSTNode2;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) return false;
        ASTNode aSTNode3 = aSTNode;
        ASTNode aSTNode4 = aSTNode3;
        if (aSTNode4 == null) return false;
        ASTNode stringTemplate = aSTNode4;
        boolean bl2 = false;
        ASTNode leafBeforeStringTemplate = ASTNodeExtensionKt.prevLeaf$default((ASTNode)stringTemplate, (boolean)false, (int)1, null);
        boolean bl3 = false;
        if (leafBeforeStringTemplate == null) return true;
        if (!ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)leafBeforeStringTemplate)) return false;
        return true;
    }

    private final boolean isLineOnlyContainingComment(ASTNode $this$isLineOnlyContainingComment) {
        return ASTNodeExtensionKt.isPartOf((ASTNode)$this$isLineOnlyContainingComment, (KClass)Reflection.getOrCreateKotlinClass(PsiComment.class)) && (ASTNodeExtensionKt.prevLeaf$default((ASTNode)$this$isLineOnlyContainingComment, (boolean)false, (int)1, null) == null || ASTNodeExtensionKt.isWhiteSpaceWithNewline((ASTNode)ASTNodeExtensionKt.prevLeaf$default((ASTNode)$this$isLineOnlyContainingComment, (boolean)false, (int)1, null)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean lineLength$lambda$11(MaxLineLengthRule this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.ignoreBackTickedIdentifier) return false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER())) return false;
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        if (!BACKTICKED_IDENTIFIER_REGEX.matches(charSequence)) return false;
        return true;
    }

    static {
        Object[] objectArray = new String[]{"true", "false"};
        IGNORE_BACKTICKED_IDENTIFIER_PROPERTY = new EditorConfigProperty((PropertyType)new PropertyType.LowerCasingPropertyType("ktlint_ignore_back_ticked_identifier", "Defines whether the backticked identifier (``) should be ignored", PropertyType.PropertyValueParser.BOOLEAN_VALUE_PARSER, SetsKt.setOf((Object[])objectArray)), (Object)false, null, null, null, null, null, null, null, null, 1020, null);
        BACKTICKED_IDENTIFIER_REGEX = new Regex("`.*`");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/MaxLineLengthRule$Companion;", "", "<init>", "()V", "IGNORE_BACKTICKED_IDENTIFIER_PROPERTY", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "", "getIGNORE_BACKTICKED_IDENTIFIER_PROPERTY", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "BACKTICKED_IDENTIFIER_REGEX", "Lkotlin/text/Regex;", "ktlint-ruleset-standard"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorConfigProperty<Boolean> getIGNORE_BACKTICKED_IDENTIFIER_PROPERTY() {
            return IGNORE_BACKTICKED_IDENTIFIER_PROPERTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

