/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.internal.RegExIgnoringDiacriticsAndStrokesOnLettersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J]\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072K\u0010\b\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\tH\u0016J]\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00072K\u0010\b\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\tH\u0002J]\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00072K\u0010\b\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\tH\u0002J]\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00072K\u0010\b\u001aG\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\tH\u0002J\f\u0010\u0018\u001a\u00020\u0010*\u00020\u0007H\u0002J\f\u0010\u0019\u001a\u00020\u0010*\u00020\u0007H\u0002J\f\u0010\u001a\u001a\u00020\u0010*\u00020\u0007H\u0002J\f\u0010\u001b\u001a\u00020\u0010*\u00020\u0007H\u0002J\f\u0010\u001c\u001a\u00020\u0010*\u00020\u0007H\u0002J\f\u0010\u001d\u001a\u00020\u0010*\u00020\u0007H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "<init>", "()V", "beforeVisitChildNodes", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "visitProperty", "property", "visitConstProperty", "identifier", "visitNonConstProperty", "hasCustomGetter", "hasConstModifier", "isTopLevelValue", "containsValKeyword", "isObjectValue", "isTokenKeywordBetweenBackticks", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint.Container(value={@SinceKtlint(version="0.48", status=SinceKtlint.Status.EXPERIMENTAL), @SinceKtlint(version="1.0", status=SinceKtlint.Status.STABLE)})
@SourceDebugExtension(value={"SMAP\nPropertyNamingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,140:1\n1#2:141\n1#2:157\n1251#3,2:142\n1368#4:144\n1454#4,2:145\n1456#4,3:160\n827#4:163\n855#4:164\n856#4:167\n11483#5,9:147\n13409#5:156\n13410#5:158\n11492#5:159\n1088#6,2:165\n*S KotlinDebug\n*F\n+ 1 PropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule\n*L\n130#1:157\n108#1:142,2\n130#1:144\n130#1:145,2\n130#1:160,3\n131#1:163\n131#1:164\n131#1:167\n130#1:147,9\n130#1:156\n130#1:158\n130#1:159\n134#1:165,2\n*E\n"})
public final class PropertyNamingRule
extends StandardRule {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private static final Regex LOWER_CAMEL_CASE_REGEXP;
    @NotNull
    private static final Regex SCREAMING_SNAKE_CASE_REGEXP;
    @Deprecated
    @NotNull
    public static final String SERIAL_VERSION_UID_PROPERTY_NAME = "serialVersionUID";
    @NotNull
    private static final Set<String> KEYWORDS;

    public PropertyNamingRule() {
        super("property-naming", null, null, 6, null);
    }

    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, @NotNull Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        block0: {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(emit, (String)"emit");
            ASTNode it = aSTNode2 = node;
            boolean bl = false;
            Object object = aSTNode = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY()) ? aSTNode2 : null;
            if (aSTNode == null) break block0;
            ASTNode property = aSTNode;
            boolean bl2 = false;
            this.visitProperty(property, emit);
        }
    }

    private final void visitProperty(ASTNode property, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        block0: {
            ASTNode identifier;
            block1: {
                ASTNode aSTNode;
                ASTNode aSTNode2;
                ASTNode aSTNode3 = property.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
                if (aSTNode3 == null) break block0;
                ASTNode it = aSTNode2 = aSTNode3;
                boolean bl = false;
                Object object = aSTNode = !this.isTokenKeywordBetweenBackticks(it) ? aSTNode2 : null;
                if (aSTNode == null) break block0;
                identifier = aSTNode;
                boolean bl2 = false;
                if (!this.hasConstModifier(property)) break block1;
                this.visitConstProperty(identifier, emit);
                break block0;
            }
            if (this.hasCustomGetter(property) || this.isTopLevelValue(property) || this.isObjectValue(property)) break block0;
            this.visitNonConstProperty(identifier, emit);
        }
    }

    private final void visitConstProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        block1: {
            String string;
            String string2;
            String string3;
            String it = string3 = identifier.getText();
            boolean bl = false;
            String string4 = string2 = !Intrinsics.areEqual((Object)it, (Object)SERIAL_VERSION_UID_PROPERTY_NAME) ? string3 : null;
            if (string2 == null) break block1;
            String it2 = string = string2;
            boolean bl2 = false;
            String string5 = string3 = !SCREAMING_SNAKE_CASE_REGEXP.matches((CharSequence)it2) ? string : null;
            if (string3 != null) {
                it2 = string3;
                boolean bl3 = false;
                AutocorrectDecision cfr_ignored_0 = (AutocorrectDecision)emit.invoke((Object)identifier.getStartOffset(), (Object)"Property name should use the screaming snake case notation when the value can not be changed", (Object)false);
            }
        }
    }

    private final void visitNonConstProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        block1: {
            String string;
            String string2;
            String string3;
            String it = string3 = identifier.getText();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string4 = string2 = !LOWER_CAMEL_CASE_REGEXP.matches((CharSequence)it) ? string3 : null;
            if (string2 == null) break block1;
            String it2 = string = string2;
            boolean bl2 = false;
            String string5 = string3 = !StringsKt.startsWith$default((String)it2, (String)"_", (boolean)false, (int)2, null) ? string : null;
            if (string3 != null) {
                it2 = string3;
                boolean bl3 = false;
                AutocorrectDecision cfr_ignored_0 = (AutocorrectDecision)emit.invoke((Object)identifier.getStartOffset(), (Object)"Property name should start with a lowercase letter and use camel case", (Object)false);
            }
        }
    }

    private final boolean hasCustomGetter(ASTNode $this$hasCustomGetter) {
        ASTNode aSTNode = $this$hasCustomGetter.findChildByType(ElementType.INSTANCE.getPROPERTY_ACCESSOR());
        return (aSTNode != null ? aSTNode.findChildByType(ElementType.INSTANCE.getGET_KEYWORD()) : null) != null;
    }

    private final boolean hasConstModifier(ASTNode $this$hasConstModifier) {
        return ASTNodeExtensionKt.hasModifier((ASTNode)$this$hasConstModifier, (IElementType)ElementType.INSTANCE.getCONST_KEYWORD());
    }

    private final boolean isTopLevelValue(ASTNode $this$isTopLevelValue) {
        return Intrinsics.areEqual((Object)$this$isTopLevelValue.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE()) && this.containsValKeyword($this$isTopLevelValue);
    }

    private final boolean containsValKeyword(ASTNode $this$containsValKeyword) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = ASTNodeExtensionKt.children((ASTNode)$this$containsValKeyword);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVAL_KEYWORD())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isObjectValue(ASTNode $this$isObjectValue) {
        ASTNode aSTNode;
        return Intrinsics.areEqual((Object)$this$isObjectValue.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getCLASS_BODY()) && Intrinsics.areEqual((Object)((aSTNode = $this$isObjectValue.getTreeParent()) != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) && this.containsValKeyword($this$isObjectValue) && !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isObjectValue, (IElementType)ElementType.INSTANCE.getOVERRIDE_KEYWORD());
    }

    private final boolean isTokenKeywordBetweenBackticks(ASTNode $this$isTokenKeywordBetweenBackticks) {
        ASTNode aSTNode;
        ASTNode it = aSTNode = $this$isTokenKeywordBetweenBackticks;
        boolean bl = false;
        Object object = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER()) ? aSTNode : null;
        String string = object != null ? object.getText() : null;
        if (string == null) {
            string = "";
        }
        String it2 = StringsKt.removeSurrounding((String)string, (CharSequence)"`");
        boolean bl2 = false;
        return KEYWORDS.contains(it2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        LOWER_CAMEL_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("[a-z][a-zA-Z0-9]*");
        SCREAMING_SNAKE_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("[A-Z][_A-Z0-9]*");
        Object[] objectArray = new TokenSet[]{KtTokens.KEYWORDS, KtTokens.SOFT_KEYWORDS};
        Iterable $this$flatMap$iv = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            TokenSet tokenSet = (TokenSet)element$iv$iv;
            boolean bl = false;
            IElementType[] iElementTypeArray = tokenSet.getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
            Object[] $this$mapNotNull$iv = iElementTypeArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                String it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl2 = false;
                IElementType it = (IElementType)element$iv$iv2;
                boolean bl3 = false;
                if (it.getDebugName() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$flatMapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            block4: {
                String keyword = (String)element$iv$iv;
                boolean bl5 = false;
                CharSequence $this$any$iv = keyword;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl6 = false;
                    if (!Character.isUpperCase(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KEYWORDS = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0012\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/PropertyNamingRule$Companion;", "", "<init>", "()V", "LOWER_CAMEL_CASE_REGEXP", "Lkotlin/text/Regex;", "getLOWER_CAMEL_CASE_REGEXP", "()Lkotlin/text/Regex;", "SCREAMING_SNAKE_CASE_REGEXP", "getSCREAMING_SNAKE_CASE_REGEXP", "SERIAL_VERSION_UID_PROPERTY_NAME", "", "KEYWORDS", "", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "getKEYWORDS", "()Ljava/util/Set;", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getLOWER_CAMEL_CASE_REGEXP() {
            return LOWER_CAMEL_CASE_REGEXP;
        }

        @NotNull
        public final Regex getSCREAMING_SNAKE_CASE_REGEXP() {
            return SCREAMING_SNAKE_CASE_REGEXP;
        }

        @NotNull
        public final Set<String> getKEYWORDS() {
            return KEYWORDS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

