/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules;

import com.pinterest.ktlint.rule.engine.core.api.ASTNodeExtensionKt;
import com.pinterest.ktlint.rule.engine.core.api.AutocorrectDecision;
import com.pinterest.ktlint.rule.engine.core.api.ElementType;
import com.pinterest.ktlint.rule.engine.core.api.SinceKtlint;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.ruleset.standard.StandardRule;
import com.pinterest.ktlint.ruleset.standard.rules.internal.RegExIgnoringDiacriticsAndStrokesOnLettersKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J]\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2K\u0010\r\u001aG\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u000eH\u0016J]\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\f2K\u0010\r\u001aG\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u000eH\u0002J]\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\f2K\u0010\r\u001aG\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u000eH\u0002J\f\u0010\u001c\u001a\u00020\u0015*\u00020\fH\u0002J\f\u0010\u001d\u001a\u00020\u0015*\u00020\fH\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\f*\u00020\fH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\f*\u00020\fH\u0002J\u0016\u0010 \u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\u000e\u0010!\u001a\u0004\u0018\u00010\f*\u00020\fH\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010\f*\u00020\fH\u0002J\u0016\u0010#\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\f\u0010$\u001a\u00020\u0015*\u00020\fH\u0002J\f\u0010%\u001a\u00020\u0013*\u00020\fH\u0002J\f\u0010&\u001a\u00020\u0015*\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/BackingPropertyNamingRule;", "Lcom/pinterest/ktlint/ruleset/standard/StandardRule;", "<init>", "()V", "codeStyle", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "beforeFirstNode", "", "editorConfig", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "beforeVisitChildNodes", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "Lcom/pinterest/ktlint/rule/engine/core/api/AutocorrectDecision;", "visitProperty", "property", "visitBackingProperty", "identifier", "hasPrivateModifierInPropertyDeclaration", "isDeclaredInPrivateCompanionObject", "findCorrelatedPropertyOrFunction", "findCorrelatedProperty", "findPropertyWithName", "findCompanionObject", "findCorrelatedFunction", "findFunctionWithName", "hasNonEmptyParameterList", "capitalizeFirstChar", "isPublic", "Companion", "ktlint-ruleset-standard"})
@SinceKtlint(version="1.2.0", status=SinceKtlint.Status.STABLE)
@SourceDebugExtension(value={"SMAP\nBackingPropertyNamingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackingPropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/BackingPropertyNamingRule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ASTNodeExtension.kt\ncom/pinterest/ktlint/rule/engine/core/api/ASTNodeExtensionKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,184:1\n1#2:185\n325#3:186\n325#3:187\n325#3:188\n325#3:189\n325#3:190\n325#3:191\n325#3:194\n325#3:195\n325#3:200\n183#4,2:192\n183#4,2:196\n183#4,2:198\n2275#4,2:201\n*S KotlinDebug\n*F\n+ 1 BackingPropertyNamingRule.kt\ncom/pinterest/ktlint/ruleset/standard/rules/BackingPropertyNamingRule\n*L\n65#1:186\n99#1:187\n103#1:188\n104#1:189\n106#1:190\n107#1:191\n131#1:194\n134#1:195\n160#1:200\n130#1:192,2\n138#1:196,2\n159#1:198,2\n165#1:201,2\n*E\n"})
public final class BackingPropertyNamingRule
extends StandardRule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private CodeStyleValue codeStyle = (CodeStyleValue)CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY().getDefaultValue();
    @NotNull
    private static final Regex BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP = RegExIgnoringDiacriticsAndStrokesOnLettersKt.regExIgnoringDiacriticsAndStrokesOnLetters("_[a-z][a-zA-Z0-9]*");

    public BackingPropertyNamingRule() {
        super("backing-property-naming", null, SetsKt.setOf((Object)CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY()), 2, null);
    }

    public void beforeFirstNode(@NotNull EditorConfig editorConfig) {
        Intrinsics.checkNotNullParameter((Object)editorConfig, (String)"editorConfig");
        this.codeStyle = (CodeStyleValue)editorConfig.get(CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY());
    }

    @Override
    public void beforeVisitChildNodes(@NotNull ASTNode node, @NotNull Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        block0: {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(emit, (String)"emit");
            ASTNode it = aSTNode2 = node;
            boolean bl = false;
            Object object = aSTNode = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY()) ? aSTNode2 : null;
            if (aSTNode == null) break block0;
            ASTNode property = aSTNode;
            boolean bl2 = false;
            this.visitProperty(property, emit);
        }
    }

    private final void visitProperty(ASTNode property, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        block2: {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            ASTNode aSTNode3 = property.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
            if (aSTNode3 == null) break block2;
            ASTNode it = aSTNode2 = aSTNode3;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Object object = aSTNode = StringsKt.startsWith$default((String)string, (String)"_", (boolean)false, (int)2, null) ? aSTNode2 : null;
            if (aSTNode != null) {
                ASTNode aSTNode4;
                ASTNode it2 = aSTNode4 = aSTNode;
                boolean bl2 = false;
                ASTNode $this$parent$iv = it2;
                boolean $i$f$getParent = false;
                ASTNode aSTNode5 = $this$parent$iv.getTreeParent();
                Intrinsics.checkNotNull((Object)aSTNode5);
                Object object2 = aSTNode2 = !ASTNodeExtensionKt.hasModifier((ASTNode)aSTNode5, (IElementType)ElementType.INSTANCE.getOVERRIDE_KEYWORD()) ? aSTNode4 : null;
                if (aSTNode2 != null) {
                    ASTNode identifier = aSTNode2;
                    boolean bl3 = false;
                    this.visitBackingProperty(identifier, emit);
                }
            }
        }
    }

    private final void visitBackingProperty(ASTNode identifier, Function3<? super Integer, ? super String, ? super Boolean, ? extends AutocorrectDecision> emit) {
        AutocorrectDecision autocorrectDecision;
        ASTNode correlatedPropertyOrFunction;
        String string;
        String string2;
        String it = string2 = identifier.getText();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string3 = string = !BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP.matches((CharSequence)it) ? string2 : null;
        if (string != null) {
            it = string;
            boolean bl2 = false;
            AutocorrectDecision cfr_ignored_0 = (AutocorrectDecision)emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property should start with underscore followed by lower camel case", (Object)false);
        }
        if (!this.hasPrivateModifierInPropertyDeclaration(identifier) && !this.isDeclaredInPrivateCompanionObject(identifier)) {
            emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property not allowed when 'private' modifier is missing", (Object)false);
        }
        if ((correlatedPropertyOrFunction = this.findCorrelatedPropertyOrFunction(identifier)) == null) {
            autocorrectDecision = (AutocorrectDecision)emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property is only allowed when a matching property or function exists", (Object)false);
        } else {
            if (this.codeStyle == CodeStyleValue.android_studio || this.isPublic(correlatedPropertyOrFunction)) {
                return;
            }
            autocorrectDecision = (AutocorrectDecision)emit.invoke((Object)identifier.getStartOffset(), (Object)"Backing property is only allowed when the matching property or function is public", (Object)false);
        }
    }

    private final boolean hasPrivateModifierInPropertyDeclaration(ASTNode $this$hasPrivateModifierInPropertyDeclaration) {
        ASTNode $this$parent$iv = $this$hasPrivateModifierInPropertyDeclaration;
        boolean $i$f$getParent = false;
        ASTNode aSTNode = $this$parent$iv.getTreeParent();
        Intrinsics.checkNotNull((Object)aSTNode);
        return ASTNodeExtensionKt.hasModifier((ASTNode)aSTNode, (IElementType)ElementType.INSTANCE.getPRIVATE_KEYWORD());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDeclaredInPrivateCompanionObject(ASTNode $this$isDeclaredInPrivateCompanionObject) {
        void $this$parent$iv;
        void $this$parent$iv2;
        void $this$parent$iv3;
        ASTNode $this$parent$iv4 = $this$isDeclaredInPrivateCompanionObject;
        boolean $i$f$getParent22 = false;
        ASTNode aSTNode = $this$parent$iv4.getTreeParent();
        if (aSTNode == null) return false;
        ASTNode $i$f$getParent22 = aSTNode;
        boolean $i$f$getParent = false;
        ASTNode aSTNode2 = $this$parent$iv3.getTreeParent();
        if (aSTNode2 == null) return false;
        ASTNode aSTNode3 = this.findCompanionObject(aSTNode2);
        if (aSTNode3 == null) return false;
        ASTNode aSTNode4 = aSTNode3;
        boolean $i$f$getParent32 = false;
        ASTNode aSTNode5 = $this$parent$iv2.getTreeParent();
        if (aSTNode5 == null) return false;
        ASTNode $i$f$getParent32 = aSTNode5;
        boolean $i$f$getParent4 = false;
        aSTNode4 = $this$parent$iv.getTreeParent();
        if (aSTNode4 == null) return false;
        if (true != ASTNodeExtensionKt.hasModifier((ASTNode)aSTNode4, (IElementType)ElementType.INSTANCE.getPRIVATE_KEYWORD())) return false;
        return true;
    }

    private final ASTNode findCorrelatedPropertyOrFunction(ASTNode $this$findCorrelatedPropertyOrFunction) {
        ASTNode aSTNode = this.findCorrelatedProperty($this$findCorrelatedPropertyOrFunction);
        if (aSTNode == null) {
            aSTNode = this.findCorrelatedFunction($this$findCorrelatedPropertyOrFunction);
        }
        return aSTNode;
    }

    private final ASTNode findCorrelatedProperty(ASTNode $this$findCorrelatedProperty) {
        Object object;
        String string = $this$findCorrelatedProperty.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String propertyName = StringsKt.removePrefix((String)string, (CharSequence)"_");
        ASTNode aSTNode = ASTNodeExtensionKt.findParentByType((ASTNode)$this$findCorrelatedProperty, (IElementType)ElementType.INSTANCE.getCLASS_BODY());
        if (aSTNode != null) {
            ASTNode classBody = aSTNode;
            boolean bl = false;
            object = this.findPropertyWithName(classBody, propertyName);
            if (object == null) {
                ASTNode aSTNode2;
                ASTNode aSTNode3 = this.findCompanionObject(classBody);
                object = aSTNode3 != null && (aSTNode2 = ASTNodeExtensionKt.findParentByType((ASTNode)aSTNode3, (IElementType)ElementType.INSTANCE.getCLASS_BODY())) != null ? this.findPropertyWithName(aSTNode2, propertyName) : null;
            }
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final ASTNode findPropertyWithName(ASTNode $this$findPropertyWithName, String name) {
        ASTNode aSTNode;
        Object v0;
        ASTNode $this$firstOrNull$iv;
        block3: {
            Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ASTNodeExtensionKt.getChildren20((ASTNode)$this$findPropertyWithName), BackingPropertyNamingRule::findPropertyWithName$lambda$8), BackingPropertyNamingRule::findPropertyWithName$lambda$9);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)name)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ASTNode aSTNode2 = v0;
        if (aSTNode2 != null) {
            void $this$parent$iv;
            $this$firstOrNull$iv = aSTNode2;
            boolean $i$f$getParent = false;
            aSTNode = $this$parent$iv.getTreeParent();
        } else {
            aSTNode = null;
        }
        return aSTNode;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ASTNode findCompanionObject(ASTNode $this$findCompanionObject) {
        Object v1;
        block1: {
            void $this$firstOrNull$iv;
            ASTNode aSTNode;
            ASTNode $this$parent$iv = $this$findCompanionObject;
            boolean $i$f$getParent = false;
            ASTNode aSTNode2 = $this$parent$iv.getTreeParent();
            if (aSTNode2 == null) return null;
            ASTNode it = aSTNode = aSTNode2;
            boolean $i$a$-takeIf-BackingPropertyNamingRule$findCompanionObject$22 = false;
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getOBJECT_DECLARATION())) return null;
            ASTNode aSTNode3 = aSTNode;
            ASTNode aSTNode4 = aSTNode3;
            if (aSTNode4 == null) return null;
            aSTNode = aSTNode4.findChildByType(ElementType.INSTANCE.getMODIFIER_LIST());
            if (aSTNode == null) return null;
            Sequence sequence = ASTNodeExtensionKt.getChildren20((ASTNode)aSTNode);
            if (sequence == null) return null;
            Sequence $i$a$-takeIf-BackingPropertyNamingRule$findCompanionObject$22 = sequence;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it2 = (ASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getElementType(), (Object)ElementType.INSTANCE.getCOMPANION_KEYWORD())) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        ASTNode aSTNode = v1;
        return aSTNode;
    }

    private final ASTNode findCorrelatedFunction(ASTNode $this$findCorrelatedFunction) {
        Object object;
        String correlatedFunctionName = "get" + this.capitalizeFirstChar($this$findCorrelatedFunction);
        ASTNode aSTNode = ASTNodeExtensionKt.findParentByType((ASTNode)$this$findCorrelatedFunction, (IElementType)ElementType.INSTANCE.getCLASS_BODY());
        if (aSTNode != null) {
            ASTNode classBody = aSTNode;
            boolean bl = false;
            object = this.findFunctionWithName(classBody, correlatedFunctionName);
            if (object == null) {
                ASTNode aSTNode2;
                ASTNode aSTNode3 = this.findCompanionObject(classBody);
                object = aSTNode3 != null && (aSTNode2 = ASTNodeExtensionKt.findParentByType((ASTNode)aSTNode3, (IElementType)ElementType.INSTANCE.getCLASS_BODY())) != null ? this.findFunctionWithName(aSTNode2, correlatedFunctionName) : null;
            }
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final ASTNode findFunctionWithName(ASTNode $this$findFunctionWithName, String name) {
        ASTNode aSTNode;
        Object v0;
        ASTNode $this$firstOrNull$iv;
        block3: {
            Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)ASTNodeExtensionKt.getChildren20((ASTNode)$this$findFunctionWithName), BackingPropertyNamingRule::findFunctionWithName$lambda$14), arg_0 -> BackingPropertyNamingRule.findFunctionWithName$lambda$15(this, arg_0)), BackingPropertyNamingRule::findFunctionWithName$lambda$16);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getText(), (Object)name)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        ASTNode aSTNode2 = v0;
        if (aSTNode2 != null) {
            void $this$parent$iv;
            $this$firstOrNull$iv = aSTNode2;
            boolean $i$f$getParent = false;
            aSTNode = $this$parent$iv.getTreeParent();
        } else {
            aSTNode = null;
        }
        return aSTNode;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasNonEmptyParameterList(ASTNode $this$hasNonEmptyParameterList) {
        boolean bl;
        block3: {
            Sequence sequence;
            ASTNode aSTNode = $this$hasNonEmptyParameterList.findChildByType(ElementType.INSTANCE.getVALUE_PARAMETER_LIST());
            if (aSTNode != null && (sequence = ASTNodeExtensionKt.getChildren20((ASTNode)aSTNode)) != null) {
                void $this$none$iv;
                Sequence sequence2 = sequence;
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final String capitalizeFirstChar(ASTNode $this$capitalizeFirstChar) {
        String string;
        String string2 = $this$capitalizeFirstChar.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = StringsKt.removePrefix((String)string2, (CharSequence)"_");
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string4 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
            String string5 = string4.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string5);
            String string6 = string3;
            int n = 1;
            String string7 = string6.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            string = stringBuilder2.append(string7).toString();
        } else {
            string = string3;
        }
        return string;
    }

    private final boolean isPublic(ASTNode $this$isPublic) {
        return !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isPublic, (IElementType)ElementType.INSTANCE.getPRIVATE_KEYWORD()) && !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isPublic, (IElementType)ElementType.INSTANCE.getPROTECTED_KEYWORD()) && !ASTNodeExtensionKt.hasModifier((ASTNode)$this$isPublic, (IElementType)ElementType.INSTANCE.getINTERNAL_KEYWORD());
    }

    private static final boolean findPropertyWithName$lambda$8(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY());
    }

    private static final ASTNode findPropertyWithName$lambda$9(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
    }

    private static final boolean findFunctionWithName$lambda$14(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getFUN());
    }

    private static final boolean findFunctionWithName$lambda$15(BackingPropertyNamingRule this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.hasNonEmptyParameterList(it);
    }

    private static final ASTNode findFunctionWithName$lambda$16(ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/BackingPropertyNamingRule$Companion;", "", "<init>", "()V", "BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP", "Lkotlin/text/Regex;", "getBACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP", "()Lkotlin/text/Regex;", "ktlint-ruleset-standard"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getBACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP() {
            return BACKING_PROPERTY_LOWER_CAMEL_CASE_REGEXP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

