/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard.rules.internal.importordering;

import com.pinterest.ktlint.ruleset.standard.rules.internal.importordering.PatternEntry;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/rules/internal/importordering/ImportSorter;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lkotlin/Comparator;", "patterns", "", "Lcom/pinterest/ktlint/ruleset/standard/rules/internal/importordering/PatternEntry;", "<init>", "(Ljava/util/List;)V", "getPatterns", "()Ljava/util/List;", "compare", "", "import1", "import2", "findImportIndex", "path", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "ktlint-ruleset-standard"})
public final class ImportSorter
implements Comparator<KtImportDirective> {
    @NotNull
    private final List<PatternEntry> patterns;

    public ImportSorter(@NotNull List<PatternEntry> patterns) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        this.patterns = patterns;
    }

    @NotNull
    public final List<PatternEntry> getPatterns() {
        return this.patterns;
    }

    @Override
    public int compare(@NotNull KtImportDirective import1, @NotNull KtImportDirective import2) {
        Intrinsics.checkNotNullParameter((Object)import1, (String)"import1");
        Intrinsics.checkNotNullParameter((Object)import2, (String)"import2");
        ImportPath importPath = import1.getImportPath();
        Intrinsics.checkNotNull((Object)importPath);
        ImportPath importPath1 = importPath;
        ImportPath importPath2 = import2.getImportPath();
        Intrinsics.checkNotNull((Object)importPath2);
        ImportPath importPath22 = importPath2;
        Function1[] function1Array = new Function1[]{arg_0 -> ImportSorter.compare$lambda$0(this, arg_0), ImportSorter::compare$lambda$1};
        return ComparisonsKt.compareValuesBy((Object)importPath1, (Object)importPath22, (Function1[])function1Array);
    }

    public final int findImportIndex(@NotNull ImportPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int bestIndex = -1;
        PatternEntry bestEntryMatch = null;
        int allOtherAliasIndex = -1;
        int allOtherIndex = -1;
        Iterator iterator = ((Iterable)this.patterns).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            PatternEntry entry = (PatternEntry)iterator.next();
            if (Intrinsics.areEqual((Object)entry, (Object)PatternEntry.Companion.getALL_OTHER_ALIAS_IMPORTS_ENTRY())) {
                allOtherAliasIndex = index;
            }
            if (Intrinsics.areEqual((Object)entry, (Object)PatternEntry.Companion.getALL_OTHER_IMPORTS_ENTRY())) {
                allOtherIndex = index;
            }
            if (!entry.isBetterMatchForPackageThan$ktlint_ruleset_standard(bestEntryMatch, path)) continue;
            bestEntryMatch = entry;
            bestIndex = index;
        }
        if (bestIndex == -1 && path.hasAlias() && allOtherAliasIndex == -1 && allOtherIndex != -1) {
            bestIndex = allOtherIndex;
        }
        return bestIndex;
    }

    private static final Comparable compare$lambda$0(ImportSorter this$0, ImportPath importPath) {
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"import");
        return Integer.valueOf(this$0.findImportIndex(importPath));
    }

    private static final Comparable compare$lambda$1(ImportPath importPath) {
        Intrinsics.checkNotNullParameter((Object)importPath, (String)"import");
        return (Comparable)((Object)StringsKt.replace$default((String)importPath.toString(), (String)"`", (String)"", (boolean)false, (int)4, null));
    }
}

