/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import com.pivovarit.collectors.BatchingStream;
import com.pivovarit.collectors.Dispatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class AsyncParallelCollector<T, R, C>
implements Collector<T, Stream.Builder<CompletableFuture<R>>, CompletableFuture<C>> {
    private final Dispatcher<R> dispatcher;
    private final Function<T, R> mapper;
    private final Function<Stream<R>, C> processor;
    private final CompletableFuture<C> result = new CompletableFuture();

    private AsyncParallelCollector(Function<T, R> mapper, Dispatcher<R> dispatcher, Function<Stream<R>, C> processor) {
        this.dispatcher = dispatcher;
        this.processor = processor;
        this.mapper = mapper;
    }

    @Override
    public Supplier<Stream.Builder<CompletableFuture<R>>> supplier() {
        return Stream::builder;
    }

    @Override
    public BinaryOperator<Stream.Builder<CompletableFuture<R>>> combiner() {
        return (left, right) -> {
            throw new UnsupportedOperationException();
        };
    }

    @Override
    public BiConsumer<Stream.Builder<CompletableFuture<R>>, T> accumulator() {
        return (acc, e) -> {
            if (!this.dispatcher.isRunning()) {
                this.dispatcher.start();
            }
            acc.add(this.dispatcher.enqueue(() -> this.mapper.apply(e)));
        };
    }

    @Override
    public Function<Stream.Builder<CompletableFuture<R>>, CompletableFuture<C>> finisher() {
        return futures -> {
            this.dispatcher.stop();
            return ((CompletableFuture)((CompletableFuture)AsyncParallelCollector.toCombined(futures.build()).thenApply(this.processor)).handle((c, ex) -> ex == null ? this.result.complete(c) : this.result.completeExceptionally((Throwable)ex))).thenCompose(__ -> this.result);
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    private static <T> CompletableFuture<Stream<T>> toCombined(Stream<CompletableFuture<T>> futures) {
        CompletableFuture[] futuresArray = (CompletableFuture[])futures.toArray(CompletableFuture[]::new);
        CompletionStage combined = CompletableFuture.allOf(futuresArray).thenApply(__ -> Arrays.stream(futuresArray).map(CompletableFuture::join));
        for (CompletableFuture f : futuresArray) {
            f.exceptionally(arg_0 -> AsyncParallelCollector.lambda$toCombined$8((CompletableFuture)combined, arg_0));
        }
        return combined;
    }

    static <T, R> Collector<T, ?, CompletableFuture<Stream<R>>> collectingToStream(Function<T, R> mapper, Executor executor) {
        return AsyncParallelCollector.collectingToStream(mapper, executor, Dispatcher.getDefaultParallelism());
    }

    static <T, R> Collector<T, ?, CompletableFuture<Stream<R>>> collectingToStream(Function<T, R> mapper, Executor executor, int parallelism) {
        Objects.requireNonNull(executor, "executor can't be null");
        Objects.requireNonNull(mapper, "mapper can't be null");
        AsyncParallelCollector.requireValidParallelism(parallelism);
        return parallelism == 1 ? AsyncParallelCollector.asyncCollector(mapper, executor, i -> i) : new AsyncParallelCollector<T, R, Stream>(mapper, Dispatcher.limiting(executor, parallelism), t -> t);
    }

    static <T, R, RR> Collector<T, ?, CompletableFuture<RR>> collectingWithCollector(Collector<R, ?, RR> collector, Function<T, R> mapper, Executor executor) {
        return AsyncParallelCollector.collectingWithCollector(collector, mapper, executor, Dispatcher.getDefaultParallelism());
    }

    static <T, R, RR> Collector<T, ?, CompletableFuture<RR>> collectingWithCollector(Collector<R, ?, RR> collector, Function<T, R> mapper, Executor executor, int parallelism) {
        Objects.requireNonNull(collector, "collector can't be null");
        Objects.requireNonNull(executor, "executor can't be null");
        Objects.requireNonNull(mapper, "mapper can't be null");
        AsyncParallelCollector.requireValidParallelism(parallelism);
        return parallelism == 1 ? AsyncParallelCollector.asyncCollector(mapper, executor, s -> s.collect(collector)) : new AsyncParallelCollector<T, R, Object>(mapper, Dispatcher.limiting(executor, parallelism), s -> s.collect(collector));
    }

    static void requireValidParallelism(int parallelism) {
        if (parallelism < 1) {
            throw new IllegalArgumentException("Parallelism can't be lower than 1");
        }
    }

    static <T, R, RR> Collector<T, ?, CompletableFuture<RR>> asyncCollector(Function<T, R> mapper, Executor executor, Function<Stream<R>, RR> finisher) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> CompletableFuture.supplyAsync(() -> {
            Stream.Builder acc = Stream.builder();
            for (Object t : list) {
                acc.add(mapper.apply(t));
            }
            return finisher.apply(acc.build());
        }, executor));
    }

    private static /* synthetic */ Object lambda$toCombined$8(CompletableFuture combined, Throwable ex) {
        combined.completeExceptionally(ex);
        return null;
    }

    static final class BatchingCollectors {
        private BatchingCollectors() {
        }

        static <T, R, RR> Collector<T, ?, CompletableFuture<RR>> collectingWithCollector(Collector<R, ?, RR> collector, Function<T, R> mapper, Executor executor, int parallelism) {
            Objects.requireNonNull(collector, "collector can't be null");
            Objects.requireNonNull(executor, "executor can't be null");
            Objects.requireNonNull(mapper, "mapper can't be null");
            AsyncParallelCollector.requireValidParallelism(parallelism);
            return parallelism == 1 ? AsyncParallelCollector.asyncCollector(mapper, executor, s -> s.collect(collector)) : BatchingCollectors.batchingCollector(mapper, executor, parallelism, s -> s.collect(collector));
        }

        static <T, R> Collector<T, ?, CompletableFuture<Stream<R>>> collectingToStream(Function<T, R> mapper, Executor executor, int parallelism) {
            Objects.requireNonNull(executor, "executor can't be null");
            Objects.requireNonNull(mapper, "mapper can't be null");
            AsyncParallelCollector.requireValidParallelism(parallelism);
            return parallelism == 1 ? AsyncParallelCollector.asyncCollector(mapper, executor, i -> i) : BatchingCollectors.batchingCollector(mapper, executor, parallelism, s -> s);
        }

        private static <T, R, RR> Collector<T, ?, CompletableFuture<RR>> batchingCollector(Function<T, R> mapper, Executor executor, int parallelism, Function<Stream<R>, RR> finisher) {
            return Collectors.collectingAndThen(Collectors.toList(), list -> (CompletableFuture)BatchingStream.partitioned(list, parallelism).collect(new AsyncParallelCollector(BatchingStream.batching(mapper), Dispatcher.of(executor), listStream -> finisher.apply(listStream.flatMap(Collection::stream)))));
        }
    }
}

