/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class BatchingStream<T>
implements Spliterator<List<T>> {
    private final List<T> source;
    private final int size;
    private final int maxChunks;
    private int chunks;
    private int chunkSize;
    private int leftElements;
    private int i;

    private BatchingStream(List<T> list, int numberOfParts) {
        this.source = list;
        this.size = list.size();
        this.chunks = numberOfParts;
        this.maxChunks = numberOfParts;
        this.chunkSize = (int)Math.ceil((double)this.size / (double)numberOfParts);
        this.leftElements = this.size;
    }

    static <T> Stream<List<T>> partitioned(List<T> list, int numberOfParts) {
        int size = list.size();
        if (size == numberOfParts) {
            return BatchingStream.asSingletonListStream(list);
        }
        if (size == 0) {
            return Stream.empty();
        }
        if (numberOfParts == 1) {
            return Stream.of(list);
        }
        return StreamSupport.stream(new BatchingStream<T>(list, numberOfParts), false);
    }

    private static <T> Stream<List<T>> asSingletonListStream(List<T> list) {
        Stream.Builder<List<T>> acc = Stream.builder();
        for (T t : list) {
            acc.add(Collections.singletonList(t));
        }
        return acc.build();
    }

    static <T, R> Function<List<T>, List<R>> batching(Function<T, R> mapper) {
        return batch -> {
            ArrayList list = new ArrayList(batch.size());
            for (Object t : batch) {
                list.add(mapper.apply(t));
            }
            return list;
        };
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<T>> action) {
        if (this.i < this.size && this.chunks != 0) {
            List<T> batch = this.source.subList(this.i, this.i + this.chunkSize);
            this.i += this.chunkSize;
            this.leftElements -= this.chunkSize;
            this.chunkSize = (int)Math.ceil((double)this.leftElements / (double)(--this.chunks));
            action.accept(batch);
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<List<T>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.maxChunks;
    }

    @Override
    public int characteristics() {
        return 80;
    }
}

