/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

final class Dispatcher<T> {
    private static final Runnable POISON_PILL = () -> System.out.println("Why so serious?");
    private final CompletableFuture<Void> completionSignaller = new CompletableFuture();
    private final BlockingQueue<Runnable> workingQueue = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService dispatcher = Dispatcher.newLazySingleThreadExecutor();
    private final Executor executor;
    private final Semaphore limiter;
    private volatile boolean started = false;
    private volatile boolean shortCircuited = false;

    private Dispatcher(Executor executor, int permits) {
        this.executor = executor;
        this.limiter = new Semaphore(permits);
    }

    static <T> Dispatcher<T> limiting(Executor executor, int permits) {
        return new Dispatcher<T>(executor, permits);
    }

    static <R> Dispatcher<List<R>> of(Executor executor) {
        return Dispatcher.limiting(executor, Integer.MAX_VALUE);
    }

    void start() {
        this.started = true;
        this.dispatcher.execute(() -> {
            try {
                Runnable task;
                while ((task = this.workingQueue.take()) != POISON_PILL) {
                    this.limiter.acquire();
                    this.executor.execute(Dispatcher.withFinally(task, this.limiter::release));
                }
            }
            catch (Throwable e) {
                this.handle(e);
            }
        });
    }

    void stop() {
        try {
            this.workingQueue.put(POISON_PILL);
        }
        catch (InterruptedException e) {
            this.completionSignaller.completeExceptionally(e);
        }
        finally {
            this.dispatcher.shutdown();
        }
    }

    boolean isRunning() {
        return this.started;
    }

    CompletableFuture<T> enqueue(Supplier<T> supplier) {
        InterruptibleCompletableFuture future = new InterruptibleCompletableFuture();
        this.workingQueue.add(this.completionTask(supplier, future));
        this.completionSignaller.exceptionally((Function)Dispatcher.shortcircuit(future));
        return future;
    }

    private FutureTask<Void> completionTask(Supplier<T> supplier, InterruptibleCompletableFuture<T> future) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            try {
                if (!this.shortCircuited) {
                    future.complete(supplier.get());
                }
            }
            catch (Throwable e) {
                this.handle(e);
            }
        }, null);
        ((InterruptibleCompletableFuture)future).completedBy(task);
        return task;
    }

    private void handle(Throwable e) {
        this.shortCircuited = true;
        this.completionSignaller.completeExceptionally(e);
        this.dispatcher.shutdownNow();
    }

    private static Function<Throwable, Void> shortcircuit(InterruptibleCompletableFuture<?> future) {
        return throwable -> {
            future.completeExceptionally((Throwable)throwable);
            future.cancel(true);
            return null;
        };
    }

    private static Runnable withFinally(Runnable task, Runnable finisher) {
        return () -> {
            try {
                task.run();
            }
            finally {
                finisher.run();
            }
        };
    }

    static int getDefaultParallelism() {
        return Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
    }

    private static ThreadPoolExecutor newLazySingleThreadExecutor() {
        return new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), task -> {
            Thread thread = Executors.defaultThreadFactory().newThread(task);
            thread.setName("parallel-collector-" + thread.getName());
            thread.setDaemon(false);
            return thread;
        });
    }

    static final class InterruptibleCompletableFuture<T>
    extends CompletableFuture<T> {
        private volatile FutureTask<?> backingTask;

        InterruptibleCompletableFuture() {
        }

        private void completedBy(FutureTask<Void> task) {
            this.backingTask = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.backingTask != null) {
                this.backingTask.cancel(mayInterruptIfRunning);
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

