/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import com.pivovarit.collectors.AsyncParallelCollector;
import com.pivovarit.collectors.BatchingStream;
import com.pivovarit.collectors.CompletionOrderSpliterator;
import com.pivovarit.collectors.Dispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class ParallelStreamCollector<T, R>
implements Collector<T, Stream.Builder<CompletableFuture<R>>, Stream<R>> {
    private static final EnumSet<Collector.Characteristics> UNORDERED = EnumSet.of(Collector.Characteristics.UNORDERED);
    private final Dispatcher<R> dispatcher;
    private final Function<T, R> function;
    private final Function<Stream<CompletableFuture<R>>, Stream<R>> processor;
    private final Set<Collector.Characteristics> characteristics;

    private ParallelStreamCollector(Function<T, R> function, Function<Stream<CompletableFuture<R>>, Stream<R>> processor, Set<Collector.Characteristics> characteristics, Dispatcher<R> dispatcher) {
        this.processor = processor;
        this.characteristics = characteristics;
        this.dispatcher = dispatcher;
        this.function = function;
    }

    private void startConsuming() {
        if (!this.dispatcher.isRunning()) {
            this.dispatcher.start();
        }
    }

    @Override
    public Supplier<Stream.Builder<CompletableFuture<R>>> supplier() {
        return Stream::builder;
    }

    @Override
    public BiConsumer<Stream.Builder<CompletableFuture<R>>, T> accumulator() {
        return (acc, e) -> {
            this.startConsuming();
            acc.add(this.dispatcher.enqueue(() -> this.function.apply(e)));
        };
    }

    @Override
    public BinaryOperator<Stream.Builder<CompletableFuture<R>>> combiner() {
        return (left, right) -> {
            throw new UnsupportedOperationException();
        };
    }

    @Override
    public Function<Stream.Builder<CompletableFuture<R>>, Stream<R>> finisher() {
        return acc -> {
            this.dispatcher.stop();
            return this.processor.apply(acc.build());
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return this.characteristics;
    }

    static <T, R> Collector<T, ?, Stream<R>> streaming(Function<T, R> mapper, Executor executor) {
        return ParallelStreamCollector.streaming(mapper, executor, Dispatcher.getDefaultParallelism());
    }

    static <T, R> Collector<T, ?, Stream<R>> streaming(Function<T, R> mapper, Executor executor, int parallelism) {
        Objects.requireNonNull(executor, "executor can't be null");
        Objects.requireNonNull(mapper, "mapper can't be null");
        AsyncParallelCollector.requireValidParallelism(parallelism);
        return parallelism == 1 ? BatchingCollectors.syncCollector(mapper) : new ParallelStreamCollector<T, R>(mapper, ParallelStreamCollector.streamInCompletionOrderStrategy(), UNORDERED, Dispatcher.limiting(executor, parallelism));
    }

    static <T, R> Collector<T, ?, Stream<R>> streamingOrdered(Function<T, R> mapper, Executor executor) {
        return ParallelStreamCollector.streamingOrdered(mapper, executor, Dispatcher.getDefaultParallelism());
    }

    static <T, R> Collector<T, ?, Stream<R>> streamingOrdered(Function<T, R> mapper, Executor executor, int parallelism) {
        Objects.requireNonNull(executor, "executor can't be null");
        Objects.requireNonNull(mapper, "mapper can't be null");
        AsyncParallelCollector.requireValidParallelism(parallelism);
        return parallelism == 1 ? BatchingCollectors.syncCollector(mapper) : new ParallelStreamCollector<T, R>(mapper, ParallelStreamCollector.streamOrderedStrategy(), Collections.emptySet(), Dispatcher.limiting(executor, parallelism));
    }

    private static <R> Function<Stream<CompletableFuture<R>>, Stream<R>> streamInCompletionOrderStrategy() {
        return futures -> StreamSupport.stream(new CompletionOrderSpliterator(futures), false);
    }

    private static <R> Function<Stream<CompletableFuture<R>>, Stream<R>> streamOrderedStrategy() {
        return futures -> futures.map(CompletableFuture::join);
    }

    static final class BatchingCollectors {
        private BatchingCollectors() {
        }

        static <T, R> Collector<T, ?, Stream<R>> streaming(Function<T, R> mapper, Executor executor, int parallelism) {
            Objects.requireNonNull(executor, "executor can't be null");
            Objects.requireNonNull(mapper, "mapper can't be null");
            AsyncParallelCollector.requireValidParallelism(parallelism);
            return parallelism == 1 ? BatchingCollectors.syncCollector(mapper) : BatchingCollectors.batched(new ParallelStreamCollector<List<T>, List<R>>(BatchingStream.batching(mapper), ParallelStreamCollector.streamInCompletionOrderStrategy(), UNORDERED, Dispatcher.of(executor)), parallelism);
        }

        static <T, R> Collector<T, ?, Stream<R>> streamingOrdered(Function<T, R> mapper, Executor executor, int parallelism) {
            Objects.requireNonNull(executor, "executor can't be null");
            Objects.requireNonNull(mapper, "mapper can't be null");
            AsyncParallelCollector.requireValidParallelism(parallelism);
            return parallelism == 1 ? BatchingCollectors.syncCollector(mapper) : BatchingCollectors.batched(new ParallelStreamCollector<List<T>, List<R>>(BatchingStream.batching(mapper), ParallelStreamCollector.streamOrderedStrategy(), Collections.emptySet(), Dispatcher.of(executor)), parallelism);
        }

        private static <T, R> Collector<T, ?, Stream<R>> batched(ParallelStreamCollector<List<T>, List<R>> downstream, int parallelism) {
            return Collectors.collectingAndThen(Collectors.toList(), list -> BatchingStream.partitioned(list, parallelism).collect(Collectors.collectingAndThen(downstream, s -> s.flatMap(Collection::stream))));
        }

        private static <T, R> Collector<T, Stream.Builder<R>, Stream<R>> syncCollector(Function<T, R> mapper) {
            return Collector.of(Stream::builder, (rs, t) -> rs.add(mapper.apply(t)), (rs, rs2) -> {
                throw new UnsupportedOperationException();
            }, Stream.Builder::build, new Collector.Characteristics[0]);
        }
    }
}

