/*
 * Decompiled with CFR 0.152.
 */
package com.pivovarit.collectors;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;

final class Dispatcher<T> {
    private static final Runnable POISON_PILL = () -> System.out.println("Why so serious?");
    private final CompletableFuture<Void> completionSignaller = new CompletableFuture();
    private final BlockingQueue<Runnable> workingQueue = new LinkedBlockingQueue<Runnable>();
    private final Executor executor;
    private final Semaphore limiter;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile boolean shortCircuited = false;

    private Dispatcher() {
        this.executor = Dispatcher.defaultExecutorService();
        this.limiter = null;
    }

    private Dispatcher(Executor executor, int permits) {
        Dispatcher.requireValidExecutor(executor);
        this.executor = executor;
        this.limiter = new Semaphore(permits);
    }

    private Dispatcher(int permits) {
        this.executor = Dispatcher.defaultExecutorService();
        this.limiter = new Semaphore(permits);
    }

    static <T> Dispatcher<T> from(Executor executor, int permits) {
        return new Dispatcher<T>(executor, permits);
    }

    static <T> Dispatcher<T> virtual() {
        return new Dispatcher<T>();
    }

    static <T> Dispatcher<T> virtual(int permits) {
        return new Dispatcher<T>(permits);
    }

    void start() {
        if (!this.started.getAndSet(true)) {
            Thread.ofVirtual().start(() -> {
                try {
                    while (true) {
                        try {
                            if (this.limiter != null) {
                                this.limiter.acquire();
                            }
                        }
                        catch (InterruptedException e) {
                            this.handle(e);
                        }
                        Runnable task = this.workingQueue.take();
                        if (task != POISON_PILL) {
                            Dispatcher.retry(() -> this.executor.execute(() -> {
                                try {
                                    task.run();
                                }
                                finally {
                                    if (this.limiter != null) {
                                        this.limiter.release();
                                    }
                                }
                            }));
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    this.handle(e);
                }
            });
        }
    }

    void stop() {
        try {
            this.workingQueue.put(POISON_PILL);
        }
        catch (InterruptedException e) {
            this.completionSignaller.completeExceptionally(e);
        }
    }

    boolean isRunning() {
        return this.started.get();
    }

    CompletableFuture<T> enqueue(Supplier<T> supplier) {
        InterruptibleCompletableFuture future = new InterruptibleCompletableFuture();
        this.workingQueue.add(this.completionTask(supplier, future));
        this.completionSignaller.exceptionally((Function)Dispatcher.shortcircuit(future));
        return future;
    }

    private FutureTask<Void> completionTask(Supplier<T> supplier, InterruptibleCompletableFuture<T> future) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            try {
                if (!this.shortCircuited) {
                    future.complete(supplier.get());
                }
            }
            catch (Throwable e) {
                this.handle(e);
            }
        }, null);
        future.completedBy(task);
        return task;
    }

    private void handle(Throwable e) {
        this.shortCircuited = true;
        this.completionSignaller.completeExceptionally(e);
    }

    private static Function<Throwable, Void> shortcircuit(InterruptibleCompletableFuture<?> future) {
        return throwable -> {
            future.completeExceptionally((Throwable)throwable);
            future.cancel(true);
            return null;
        };
    }

    private static ExecutorService defaultExecutorService() {
        return Executors.newVirtualThreadPerTaskExecutor();
    }

    private static void requireValidExecutor(Executor executor) {
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
            RejectedExecutionHandler rejectedExecutionHandler = tpe.getRejectedExecutionHandler();
            Objects.requireNonNull(rejectedExecutionHandler);
            RejectedExecutionHandler rejectedExecutionHandler2 = rejectedExecutionHandler;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ThreadPoolExecutor.DiscardPolicy.class, ThreadPoolExecutor.DiscardOldestPolicy.class}, (Object)rejectedExecutionHandler2, n)) {
                case 0: {
                    ThreadPoolExecutor.DiscardPolicy __ = (ThreadPoolExecutor.DiscardPolicy)rejectedExecutionHandler2;
                    throw new IllegalArgumentException("Executor's RejectedExecutionHandler can't discard tasks");
                }
                case 1: {
                    ThreadPoolExecutor.DiscardOldestPolicy __ = (ThreadPoolExecutor.DiscardOldestPolicy)rejectedExecutionHandler2;
                    throw new IllegalArgumentException("Executor's RejectedExecutionHandler can't discard tasks");
                }
            }
        }
    }

    private static void retry(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (RejectedExecutionException e) {
            Thread.onSpinWait();
            runnable.run();
        }
    }

    static final class InterruptibleCompletableFuture<T>
    extends CompletableFuture<T> {
        private volatile FutureTask<?> backingTask;

        InterruptibleCompletableFuture() {
        }

        private void completedBy(FutureTask<Void> task) {
            this.backingTask = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.backingTask != null) {
                this.backingTask.cancel(mayInterruptIfRunning);
            }
            return super.cancel(mayInterruptIfRunning);
        }
    }
}

