/*
 * Decompiled with CFR 0.152.
 */
package com.pkslow.ai;

import com.pkslow.ai.AIClient;
import com.pkslow.ai.domain.Answer;
import com.pkslow.ai.domain.AnswerStatus;
import com.pkslow.ai.domain.BardRequest;
import com.pkslow.ai.domain.BardResponse;
import com.pkslow.ai.util.BardUtils;
import com.pkslow.ai.util.WebUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBardClient
implements AIClient {
    private static final Logger log = LoggerFactory.getLogger(GoogleBardClient.class);
    private final String token;
    private final OkHttpClient httpClient;
    private final BardRequest bardRequest = BardRequest.DEFAULT_REQUEST;

    public GoogleBardClient(String token) {
        this(token, Duration.ofMinutes(5L));
    }

    public GoogleBardClient(String token, Duration timeout) {
        this.token = token;
        this.httpClient = WebUtils.okHttpClientWithTimeout(timeout);
    }

    @Override
    public Answer ask(String question) {
        Answer answer;
        try {
            if (GoogleBardClient.isEmpty(this.bardRequest.getStrSNlM0e())) {
                this.bardRequest.setStrSNlM0e(this.callBardToGetSNlM0e());
            }
            this.bardRequest.setQuestion(question);
            String response = this.callBardToAsk(this.bardRequest);
            answer = this.processAskResult(response);
        }
        catch (Throwable e) {
            e.printStackTrace();
            Answer.AnswerBuilder builder = Answer.AnswerBuilder.anAnswer();
            return builder.status(AnswerStatus.ERROR).build();
        }
        return answer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String callBardToGetSNlM0e() {
        Call call = this.httpClient.newCall(BardUtils.createRequestForSNlM0e(this.token));
        try (Response response = call.execute();){
            log.info("getSNlM0e Response code: " + response.code());
            String responseString = Objects.requireNonNull(response.body()).string();
            String string = BardUtils.fetchSNlM0eFromBody(responseString);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String callBardToAsk(BardRequest bardRequest) {
        log.info("calling Bard with request {}", (Object)bardRequest);
        Request request = BardUtils.createPostRequestForAsk(this.token, bardRequest);
        Call call = this.httpClient.newCall(request);
        try (Response response = call.execute();){
            int statusCode = response.code();
            log.info("Ask Response code: " + statusCode);
            String responseString = Objects.requireNonNull(response.body()).string();
            if (statusCode != 200) {
                throw new IllegalStateException("Can't get the answer");
            }
            String result = responseString.split("\\n")[3];
            log.debug("Raw answers length: {}", (Object)result.length());
            String string = result;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Answer processAskResult(String content) {
        BardResponse bardResponse = BardUtils.createBardResponseFromResponse(content);
        this.bardRequest.setConversationId(bardResponse.getConversationId());
        this.bardRequest.setResponseId(bardResponse.getResponseId());
        this.bardRequest.setChoiceId(bardResponse.getChoiceId());
        return bardResponse.getAnswer();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

