/*
 * Decompiled with CFR 0.152.
 */
package com.pkslow.ai;

import com.pkslow.ai.GoogleBardClient;
import com.pkslow.ai.domain.Answer;
import com.pkslow.ai.domain.AnswerStatus;
import com.pkslow.ai.util.NetworkUtils;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBardExample {
    private static final Logger log = LoggerFactory.getLogger(GoogleBardExample.class);

    public static void main(String[] args) {
        NetworkUtils.setUpProxy("localhost", "7890");
        String token = args[0];
        GoogleBardClient client = new GoogleBardClient(token, Duration.ofMinutes(10L));
        Answer answer = client.ask("What is the population of London?");
        GoogleBardExample.printChosenAnswer(answer);
        answer = client.ask("How about Beijing?");
        GoogleBardExample.printChosenAnswer(answer);
        answer = client.ask("How about Hong Kong?");
        GoogleBardExample.printChosenAnswer(answer);
    }

    private static void printChosenAnswer(Answer answer) {
        StringBuilder sb = new StringBuilder();
        if (answer.status() == AnswerStatus.OK) {
            sb.append("\n### Chosen Answer\n");
            sb.append(answer.chosenAnswer());
            log.info("Output: \n {}", (Object)sb);
        }
    }

    private static void printAnswer(Answer answer) {
        StringBuilder sb = new StringBuilder();
        if (answer.status() == AnswerStatus.OK) {
            sb.append("\n### Chosen Answer\n");
            sb.append(answer.chosenAnswer());
            for (int i = 0; i < answer.draftAnswers().size(); ++i) {
                sb.append("\n### Draft Answer ").append(i).append("\n");
                sb.append(answer.draftAnswers().get(i));
            }
            log.info("Output: \n {}", (Object)sb);
        }
    }
}

