/*
 * Decompiled with CFR 0.152.
 */
package com.pkslow.ai.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.pkslow.ai.domain.Answer;
import com.pkslow.ai.domain.AnswerStatus;
import com.pkslow.ai.domain.BardRequest;
import com.pkslow.ai.domain.BardResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BardUtils {
    private static final Logger log = LoggerFactory.getLogger(BardUtils.class);

    public static Request.Builder createBuilderWithBardHeader(String token) {
        return new Request.Builder().addHeader("Host", "bard.google.com").addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8").addHeader("X-Same-Domain", "1").addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36").addHeader("Origin", "https://bard.google.com/").addHeader("Referer", "https://bard.google.com/").addHeader("Cookie", "__Secure-1PSID=" + token);
    }

    public static Request createRequestForSNlM0e(String token) {
        Request.Builder headerBuilder = BardUtils.createBuilderWithBardHeader(token);
        return headerBuilder.url("https://bard.google.com/").build();
    }

    public static String fetchSNlM0eFromBody(String input) {
        Pattern p = Pattern.compile("SNlM0e\":\"(.*?)\"");
        Matcher m = p.matcher(input);
        if (m.find()) {
            String result = m.group();
            result = result.substring(9, result.length() - 1);
            return result;
        }
        return null;
    }

    @NotNull
    public static Map<String, String> genQueryStringParamsForAsk() {
        int randonNum = ThreadLocalRandom.current().nextInt(0, 10000);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bl", "boq_assistant-bard-web-server_20230514.20_p0");
        params.put("_reqid", String.valueOf(randonNum += 100000));
        params.put("rt", "c");
        return params;
    }

    @NotNull
    public static HttpUrl.Builder createHttpBuilderForAsk() {
        Map<String, String> params = BardUtils.genQueryStringParamsForAsk();
        HttpUrl.Builder httpBuilder = Objects.requireNonNull(HttpUrl.parse((String)"https://bard.google.com/_/BardChatUi/data/assistant.lamda.BardFrontendService/StreamGenerate")).newBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            httpBuilder.addQueryParameter(param.getKey(), param.getValue());
        }
        return httpBuilder;
    }

    public static String removeBackslash(String answerStr) {
        answerStr = answerStr.replace("\\\\n", "\n");
        answerStr = answerStr.replace("\\", "\"");
        return answerStr;
    }

    @NotNull
    public static Request createPostRequestForAsk(String token, BardRequest bardRequest) {
        HttpUrl.Builder httpBuilder = BardUtils.createHttpBuilderForAsk();
        RequestBody body = BardUtils.buildRequestBodyForAsk(bardRequest);
        Request.Builder headerBuilder = BardUtils.createBuilderWithBardHeader(token);
        return headerBuilder.url(httpBuilder.build()).method("POST", body).build();
    }

    @NotNull
    public static RequestBody buildRequestBodyForAsk(BardRequest bardRequest) {
        return new FormBody.Builder().add("f.req", String.format("[null,\"[[\\\"%s\\\"],null,[\\\"%s\\\",\\\"%s\\\",\\\"%s\\\"]]\"]", bardRequest.getQuestion(), bardRequest.getConversationId(), bardRequest.getResponseId(), bardRequest.getChoiceId())).add("at", bardRequest.getStrSNlM0e()).build();
    }

    public static BardResponse createBardResponseFromResponse(String content) {
        JsonArray jsonArray = (JsonArray)new Gson().fromJson(content, JsonArray.class);
        JsonElement element3 = ((JsonArray)jsonArray.get(0)).get(2);
        String content3 = element3.getAsString();
        JsonArray jsonArray3 = (JsonArray)new Gson().fromJson(content3, JsonArray.class);
        ArrayList<String> results = new ArrayList<String>();
        String conversationId = ((JsonArray)jsonArray3.get(1)).get(0).getAsString();
        String responseId = ((JsonArray)jsonArray3.get(1)).get(1).getAsString();
        String chosenAnswer = ((JsonArray)jsonArray3.get(0)).get(0).getAsString();
        chosenAnswer = BardUtils.removeBackslash(chosenAnswer);
        Answer.AnswerBuilder builder = Answer.AnswerBuilder.anAnswer();
        builder.chosenAnswer(chosenAnswer);
        String choiceId = ((JsonArray)((JsonArray)jsonArray3.get(4)).get(0)).get(0).getAsString();
        try {
            for (int i = 0; i < 3; ++i) {
                String oneDraftAnswer = ((JsonArray)((JsonArray)jsonArray3.get(4)).get(i)).get(1).getAsString();
                oneDraftAnswer = BardUtils.removeBackslash(oneDraftAnswer);
                results.add(oneDraftAnswer);
            }
        }
        catch (Exception e) {
            log.error("No right answer...");
            builder.status(AnswerStatus.NO_ANSWER);
            Answer answer = builder.build();
            return new BardResponse(conversationId, responseId, choiceId, answer);
        }
        builder.draftAnswers(results);
        builder.status(AnswerStatus.OK);
        Answer answer = builder.build();
        return new BardResponse(conversationId, responseId, choiceId, answer);
    }
}

