/*
 * Decompiled with CFR 0.152.
 */
package com.pkslow.ai;

import com.pkslow.ai.AIClient;
import com.pkslow.ai.domain.Answer;
import com.pkslow.ai.domain.AnswerStatus;
import com.pkslow.ai.domain.BardRequest;
import com.pkslow.ai.domain.BardResponse;
import com.pkslow.ai.util.BardUtils;
import com.pkslow.ai.util.WebUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBardClient
implements AIClient {
    private static final Logger log = LoggerFactory.getLogger(GoogleBardClient.class);
    private final String token;
    private final OkHttpClient httpClient;
    private final BardRequest bardRequest = BardRequest.newEmptyBardRequest();

    public GoogleBardClient(String token) {
        this(token, Duration.ofMinutes(5L));
    }

    public GoogleBardClient(String token, Duration timeout) {
        this.token = token;
        this.httpClient = WebUtils.okHttpClientWithTimeout(timeout);
    }

    public GoogleBardClient(String token, OkHttpClient httpClient) {
        this.token = token;
        this.httpClient = httpClient;
    }

    @Override
    public Answer ask(String question) {
        question = question.replaceAll("\\s+", " ");
        try {
            if (BardUtils.isEmpty(this.bardRequest.getStrSNlM0e())) {
                String strSNlM0e = this.callBardToGetSNlM0e();
                if (BardUtils.isEmpty(strSNlM0e)) {
                    throw new RuntimeException("Failed to get SNlM0e, it may be token issue");
                }
                this.bardRequest.setStrSNlM0e(strSNlM0e);
            }
            this.bardRequest.setQuestion(question);
            return this.processAskResult(this.callBardToAsk(this.bardRequest));
        }
        catch (Throwable e) {
            log.error("Failed to get answer: ", e);
            return Answer.builder().status(AnswerStatus.ERROR).build();
        }
    }

    @Override
    public void reset() {
        this.bardRequest.setStrSNlM0e("");
        this.bardRequest.setConversationId("");
        this.bardRequest.setResponseId("");
        this.bardRequest.setChoiceId("");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String callBardToGetSNlM0e() {
        Call call = this.httpClient.newCall(BardUtils.createRequestForSNlM0e(this.token));
        try (Response response = call.execute();){
            log.info("getSNlM0e Response code: " + response.code());
            String string = BardUtils.fetchSNlM0eFromBody(Objects.requireNonNull(response.body()).string());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String callBardToAsk(BardRequest bardRequest) {
        log.info("calling Bard with request {}", (Object)bardRequest);
        Call call = this.httpClient.newCall(BardUtils.createPostRequestForAsk(this.token, bardRequest));
        try (Response response = call.execute();){
            int statusCode = response.code();
            log.info("Ask Response code: " + statusCode);
            if (statusCode != 200) {
                throw new IllegalStateException("Can't get the answer");
            }
            String result = Objects.requireNonNull(response.body()).string().split("\\n")[3];
            log.debug("Result for ask: {}", (Object)result);
            log.debug("Raw answers length: {}", (Object)result.length());
            String string = result;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Answer processAskResult(String content) {
        BardResponse bardResponse = BardUtils.renderBardResponseFromResponse(content);
        this.bardRequest.setConversationId(bardResponse.getConversationId());
        this.bardRequest.setResponseId(bardResponse.getResponseId());
        this.bardRequest.setChoiceId(bardResponse.getChoiceId());
        return bardResponse.getAnswer();
    }
}

