/*
 * Decompiled with CFR 0.152.
 */
package com.pkslow.ai.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.pkslow.ai.domain.Answer;
import com.pkslow.ai.domain.AnswerStatus;
import com.pkslow.ai.domain.BardRequest;
import com.pkslow.ai.domain.BardResponse;
import com.pkslow.ai.domain.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BardUtils {
    private static final Logger log = LoggerFactory.getLogger(BardUtils.class);

    public static Request.Builder createBuilderWithBardHeader(String token) {
        String[] tokens = token.split(";");
        if (tokens.length < 2) {
            throw new RuntimeException("Please provide the correct token:__Secure-1PSID;__Secure-1PSIDTS");
        }
        String token1PSID = tokens[0];
        String token1PSIDTS = tokens[1];
        return new Request.Builder().addHeader("Host", "bard.google.com").addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8").addHeader("X-Same-Domain", "1").addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36").addHeader("Origin", "https://bard.google.com/").addHeader("Referer", "https://bard.google.com/").addHeader("Cookie", "__Secure-1PSID=" + token1PSID + ";" + "__Secure-1PSIDTS" + "=" + token1PSIDTS);
    }

    public static Request createRequestForSNlM0e(String token) {
        Request.Builder headerBuilder = BardUtils.createBuilderWithBardHeader(token);
        return headerBuilder.url("https://bard.google.com/").build();
    }

    public static String fetchSNlM0eFromBody(String input) {
        Matcher matcher = Pattern.compile("SNlM0e\":\"(.*?)\"").matcher(input);
        if (matcher.find()) {
            String result = matcher.group();
            return result.substring(9, result.length() - 1);
        }
        return null;
    }

    @NotNull
    public static Map<String, String> genQueryStringParamsForAsk() {
        int randomNumber = ThreadLocalRandom.current().nextInt(0, 10000) + 100000;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bl", "boq_assistant-bard-web-server_20230808.09_p0");
        params.put("_reqid", String.valueOf(randomNumber));
        params.put("rt", "c");
        return params;
    }

    @NotNull
    public static HttpUrl.Builder createHttpBuilderForAsk() {
        HttpUrl.Builder httpBuilder = Objects.requireNonNull(HttpUrl.parse((String)"https://bard.google.com/_/BardChatUi/data/assistant.lamda.BardFrontendService/StreamGenerate")).newBuilder();
        for (Map.Entry<String, String> param : BardUtils.genQueryStringParamsForAsk().entrySet()) {
            httpBuilder.addQueryParameter(param.getKey(), param.getValue());
        }
        return httpBuilder;
    }

    public static String removeBackslash(String answerStr) {
        return answerStr.replace("\\\\n", "\n").replace("\\", "\"");
    }

    @NotNull
    public static Request createPostRequestForAsk(String token, BardRequest bardRequest) {
        return BardUtils.createBuilderWithBardHeader(token).url(BardUtils.createHttpBuilderForAsk().build()).method("POST", BardUtils.buildRequestBodyForAsk(bardRequest)).build();
    }

    @NotNull
    public static RequestBody buildRequestBodyForAsk(BardRequest bardRequest) {
        String question = bardRequest.getQuestion().replace("\"", "\\\\\\\"");
        return new FormBody.Builder().add("f.req", String.format("[null,\"[[\\\"%s\\\"],null,[\\\"%s\\\",\\\"%s\\\",\\\"%s\\\"]]\"]", question, bardRequest.getConversationId(), bardRequest.getResponseId(), bardRequest.getChoiceId())).add("at", bardRequest.getStrSNlM0e()).build();
    }

    public static BardResponse renderBardResponseFromResponse(String content) {
        Answer.AnswerBuilder builder = Answer.builder();
        String conversationId = "";
        String responseId = "";
        String choiceId = "";
        try {
            JsonArray chatData = BardUtils.getChatData(content);
            builder.chosenAnswer(BardUtils.getChosenAnswer(chatData));
            conversationId = ((JsonArray)chatData.get(1)).get(0).getAsString();
            responseId = ((JsonArray)chatData.get(1)).get(1).getAsString();
            choiceId = ((JsonArray)((JsonArray)chatData.get(4)).get(0)).get(0).getAsString();
            ArrayList<Image> images = new ArrayList();
            try {
                images = BardUtils.getImages(chatData);
            }
            catch (Exception e) {
                log.info("No image");
            }
            builder.images(images);
            return new BardResponse(conversationId, responseId, choiceId, builder.status(AnswerStatus.OK).build());
        }
        catch (Exception e) {
            return new BardResponse(conversationId, responseId, choiceId, builder.status(AnswerStatus.NO_ANSWER).build());
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static JsonArray getChatData(String content) {
        JsonArray contentJsonArray = (JsonArray)new Gson().fromJson(content, JsonArray.class);
        String element3content = ((JsonArray)contentJsonArray.get(0)).get(2).getAsString();
        return (JsonArray)new Gson().fromJson(element3content, JsonArray.class);
    }

    private static String getChosenAnswer(JsonArray chatData) {
        return BardUtils.removeBackslash(((JsonArray)((JsonArray)chatData.get(4)).get(0)).get(1).getAsString());
    }

    private static List<Image> getImages(JsonArray chatData) {
        ArrayList<Image> images = new ArrayList<Image>();
        JsonArray imagesJson = (JsonArray)((JsonArray)((JsonArray)chatData.get(4)).get(0)).get(4);
        for (JsonElement jsonElement : imagesJson) {
            JsonArray imageJson = (JsonArray)jsonElement;
            String url = ((JsonArray)((JsonArray)imageJson.get(0)).get(0)).get(0).getAsString();
            String markdownLabel = imageJson.get(2).getAsString();
            String articleURL = ((JsonArray)((JsonArray)imageJson.get(1)).get(0)).get(0).getAsString();
            Image image = new Image(url, markdownLabel, articleURL);
            images.add(image);
        }
        return images;
    }
}

