/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Carrier;

import com.placetopay.java_placetopay.Carrier.Authentication;
import com.placetopay.java_placetopay.Contracts.Carrier;
import com.placetopay.java_placetopay.Contracts.Configuration;
import com.placetopay.java_placetopay.Entities.Models.CollectRequest;
import com.placetopay.java_placetopay.Entities.Models.RedirectInformation;
import com.placetopay.java_placetopay.Entities.Models.RedirectRequest;
import com.placetopay.java_placetopay.Entities.Models.RedirectResponse;
import com.placetopay.java_placetopay.Entities.Models.ReverseResponse;
import com.placetopay.java_placetopay.Entities.Status;
import com.placetopay.java_placetopay.Exceptions.PlaceToPayException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class RestCarrier
extends Carrier {
    public RestCarrier(Authentication auth, Configuration config) {
        super(auth, config);
        if (config.getUrl() == null) {
            throw new PlaceToPayException("Base URL not found for this");
        }
    }

    @Override
    public RedirectResponse request(RedirectRequest redirectRequest) {
        try {
            String response = this.makeRequest("POST", this.url("api/session"), redirectRequest.toJsonObject());
            JSONObject jsonResponse = new JSONObject(response);
            this.cleanResponse(jsonResponse);
            return new RedirectResponse(jsonResponse);
        }
        catch (IOException ex) {
            return new RedirectResponse(new Status("ERROR", "WR", PlaceToPayException.readException(ex), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date())));
        }
    }

    @Override
    public RedirectInformation query(String requestId) {
        try {
            String response = this.makeRequest("POST", this.url("api/session/" + requestId), new JSONObject());
            JSONObject jsonResponse = new JSONObject(response);
            this.cleanResponse(jsonResponse);
            return new RedirectInformation(jsonResponse);
        }
        catch (IOException ex) {
            return new RedirectInformation(new Status("ERROR", "WR", PlaceToPayException.readException(ex), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date())));
        }
    }

    @Override
    public RedirectInformation collect(CollectRequest collectRequest) {
        try {
            String response = this.makeRequest("POST", this.url("api/collect"), collectRequest.toJsonObject());
            JSONObject jsonResponse = new JSONObject(response);
            this.cleanResponse(jsonResponse);
            return new RedirectInformation(jsonResponse);
        }
        catch (IOException ex) {
            return new RedirectInformation(new Status("ERROR", "WR", PlaceToPayException.readException(ex), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date())));
        }
    }

    @Override
    public ReverseResponse reverse(String internalReference) {
        try {
            JSONObject object = new JSONObject();
            object.put("internalReference", (Object)internalReference);
            String response = this.makeRequest("POST", this.url("api/reverse"), object);
            JSONObject jsonResponse = new JSONObject(response);
            this.cleanResponse(jsonResponse);
            return new ReverseResponse(jsonResponse);
        }
        catch (IOException ex) {
            return new ReverseResponse(new Status("ERROR", "WR", PlaceToPayException.readException(ex), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date())));
        }
    }

    public String makeRequest(String method, String urlString, JSONObject arguments) throws MalformedURLException, ProtocolException, IOException {
        String line;
        arguments.put("auth", (Object)this.auth.toJsonObject());
        URL url = new URL(urlString);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setDoOutput(true);
        httpConnection.setRequestMethod(method);
        httpConnection.setRequestProperty("User-Agent", "Java/" + System.getProperty("java.version"));
        httpConnection.setRequestProperty("Content-Type", "application/json");
        httpConnection.setRequestProperty("Accept", "application/json");
        DataOutputStream wr = new DataOutputStream(httpConnection.getOutputStream());
        wr.write(arguments.toString().getBytes());
        Integer responseCode = httpConnection.getResponseCode();
        BufferedReader bufferedReader = responseCode > 199 && responseCode < 300 ? new BufferedReader(new InputStreamReader(httpConnection.getInputStream())) : new BufferedReader(new InputStreamReader(httpConnection.getErrorStream()));
        StringBuilder content = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            content.append(line).append("\n");
        }
        bufferedReader.close();
        return content.toString();
    }

    private String url(String endPoint) {
        return this.config.getUrl() + endPoint;
    }

    private void cleanResponse(Object response) {
        block4: {
            block3: {
                if (!(response instanceof JSONObject)) break block3;
                JSONObject object = (JSONObject)response;
                HashSet keys = new HashSet(object.keySet());
                for (String key : keys) {
                    if (object.isNull(key)) {
                        object.remove(key);
                        continue;
                    }
                    Object value = object.get(key);
                    if (!(value instanceof JSONObject) && !(value instanceof JSONArray)) continue;
                    this.cleanResponse(value);
                }
                break block4;
            }
            if (!(response instanceof JSONArray)) break block4;
            JSONArray array = (JSONArray)response;
            for (int i = 0; i < array.length(); ++i) {
                this.cleanResponse(array.get(i));
            }
        }
    }
}

