/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Carrier;

import com.placetopay.java_placetopay.Carrier.Authentication;
import com.placetopay.java_placetopay.Contracts.Carrier;
import com.placetopay.java_placetopay.Contracts.Configuration;
import com.placetopay.java_placetopay.Entities.Models.CollectRequest;
import com.placetopay.java_placetopay.Entities.Models.RedirectInformation;
import com.placetopay.java_placetopay.Entities.Models.RedirectRequest;
import com.placetopay.java_placetopay.Entities.Models.RedirectResponse;
import com.placetopay.java_placetopay.Entities.Models.ReverseResponse;
import com.placetopay.java_placetopay.Entities.Status;
import com.placetopay.java_placetopay.Exceptions.BadPlaceToPayException;
import com.placetopay.java_placetopay.Exceptions.PlaceToPayException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

public class SoapCarrier
extends Carrier {
    private static final String WSDL_LOCATION = "http://placetopay.com/soap/redirect/";
    private static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private final SOAPConnectionFactory conFactory;

    public SoapCarrier(Authentication auth, Configuration config) {
        super(auth, config);
        try {
            this.conFactory = SOAPConnectionFactory.newInstance();
        }
        catch (Exception ex) {
            throw new PlaceToPayException("Failed to create SOAP connection: " + ex.getMessage());
        }
    }

    public SoapCarrier(Authentication auth, Configuration config, Map<String, String> soapSettings) {
        super(auth, config);
        try {
            this.conFactory = SOAPConnectionFactory.newInstance();
        }
        catch (Exception ex) {
            throw new PlaceToPayException("Failed to create SOAP connection: " + ex.getMessage());
        }
    }

    private SOAPMessage createSoapMessage() throws SOAPException {
        MessageFactory messageFactory = MessageFactory.newInstance((String)(this.config.getSoapVersion() == 2 ? "SOAP 1.2 Protocol" : "SOAP 1.1 Protocol"));
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration("p2p", WSDL_LOCATION);
        envelope.addNamespaceDeclaration("xsi", XSI);
        this.auth.addSoapHeader(envelope);
        return soapMessage;
    }

    @Override
    public RedirectResponse request(RedirectRequest redirectRequest) {
        try {
            SOAPConnection connection = this.conFactory.createConnection();
            SOAPMessage message = this.createSoapMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPElement functionElement = body.addChildElement("createRequest");
            functionElement.setPrefix("p2p");
            SOAPElement payload = functionElement.addChildElement("payload");
            JSONObject jsonPayload = redirectRequest.toJsonObject();
            this.appendJsonToSoap(payload, jsonPayload);
            MimeHeaders header = message.getMimeHeaders();
            header.addHeader("SOAPAction", "http://placetopay.com/soap/redirect//createRequest");
            message.saveChanges();
            SOAPMessage response = connection.call(message, (Object)this.config.getLocation());
            JSONObject responseBody = this.extractBody(response, "createRequestResult");
            this.cleanResponse(responseBody);
            connection.close();
            return new RedirectResponse(responseBody);
        }
        catch (Exception ex) {
            return new RedirectResponse(new Status("ERROR", "WR", PlaceToPayException.readException(ex), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date())));
        }
    }

    @Override
    public RedirectInformation query(String requestId) {
        try {
            SOAPConnection connection = this.conFactory.createConnection();
            SOAPMessage message = this.createSoapMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPElement functionElement = body.addChildElement("getRequestInformation");
            functionElement.setPrefix("p2p");
            SOAPElement requestIdElement = functionElement.addChildElement("requestId");
            requestIdElement.addTextNode(requestId);
            MimeHeaders header = message.getMimeHeaders();
            header.addHeader("SOAPAction", "http://placetopay.com/soap/redirect//getRequestInformation");
            message.saveChanges();
            SOAPMessage response = connection.call(message, (Object)this.config.getLocation());
            JSONObject responseBody = this.extractBody(response, "getRequestInformationResult");
            this.cleanResponse(responseBody);
            connection.close();
            return new RedirectInformation(responseBody);
        }
        catch (Exception ex) {
            return new RedirectInformation(new Status("ERROR", "WR", PlaceToPayException.readException(ex), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date())));
        }
    }

    @Override
    public RedirectInformation collect(CollectRequest collectRequest) {
        try {
            SOAPConnection connection = this.conFactory.createConnection();
            SOAPMessage message = this.createSoapMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPElement functionElement = body.addChildElement("collect");
            functionElement.setPrefix("p2p");
            SOAPElement payload = functionElement.addChildElement("payload");
            JSONObject jsonPayload = collectRequest.toJsonObject();
            this.appendJsonToSoap(payload, jsonPayload);
            MimeHeaders header = message.getMimeHeaders();
            header.addHeader("SOAPAction", "http://placetopay.com/soap/redirect//collect");
            message.saveChanges();
            SOAPMessage response = connection.call(message, (Object)this.config.getLocation());
            JSONObject responseBody = this.extractBody(response, "collectResult");
            this.cleanResponse(responseBody);
            connection.close();
            return new RedirectInformation(responseBody);
        }
        catch (Exception ex) {
            return new RedirectInformation(new Status("ERROR", "WR", PlaceToPayException.readException(ex), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date())));
        }
    }

    @Override
    public ReverseResponse reverse(String internalReference) {
        try {
            SOAPConnection connection = this.conFactory.createConnection();
            SOAPMessage message = this.createSoapMessage();
            SOAPBody body = message.getSOAPBody();
            SOAPElement functionElement = body.addChildElement("reversePayment");
            functionElement.setPrefix("p2p");
            SOAPElement requestIdElement = functionElement.addChildElement("internalReference");
            requestIdElement.addTextNode(internalReference);
            MimeHeaders header = message.getMimeHeaders();
            header.addHeader("SOAPAction", "http://placetopay.com/soap/redirect//reversePayment");
            message.saveChanges();
            SOAPMessage response = connection.call(message, (Object)this.config.getLocation());
            JSONObject responseBody = this.extractBody(response, "reversePaymentResult");
            this.cleanResponse(responseBody);
            connection.close();
            return new ReverseResponse(responseBody);
        }
        catch (Exception ex) {
            return new ReverseResponse(new Status("ERROR", "WR", PlaceToPayException.readException(ex), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date())));
        }
    }

    private void appendJsonToSoap(SOAPElement msg, JSONObject jsonPayload) throws SOAPException {
        for (String key : jsonPayload.keySet()) {
            Object value = jsonPayload.get(key);
            if (value instanceof JSONObject) {
                this.appendJsonToSoap(msg.addChildElement(key), jsonPayload.getJSONObject(key));
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object arrayElement = jsonArray.get(i);
                    if (arrayElement instanceof JSONObject) {
                        this.appendJsonToSoap(msg.addChildElement(key), (JSONObject)arrayElement);
                        continue;
                    }
                    msg.addChildElement(key).addTextNode(arrayElement.toString());
                }
                continue;
            }
            msg.addChildElement(key).addTextNode(value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject extractBody(SOAPMessage response, String elementName) throws SOAPException, BadPlaceToPayException, IOException {
        try (ByteArrayOutputStream baos = null;){
            baos = new ByteArrayOutputStream();
            response.writeTo((OutputStream)baos);
            String result = baos.toString();
            JSONObject object = XML.toJSONObject((String)result, (boolean)false);
            JSONObject body = object.getJSONObject("SOAP-ENV:Envelope").getJSONObject("SOAP-ENV:Body");
            JSONObject jSONObject = body.getJSONObject((String)body.keys().next()).getJSONObject(elementName);
            return jSONObject;
        }
    }

    private boolean cleanResponse(Object response) {
        block4: {
            block3: {
                if (!(response instanceof JSONObject)) break block3;
                JSONObject object = (JSONObject)response;
                HashSet keys = new HashSet(object.keySet());
                for (String key : keys) {
                    if (key.equals("xsi:nil") && object.getBoolean(key)) {
                        return true;
                    }
                    boolean result = this.cleanResponse(object.get(key));
                    if (!result) continue;
                    object.remove(key);
                }
                break block4;
            }
            if (!(response instanceof JSONArray)) break block4;
            JSONArray array = (JSONArray)response;
            for (int i = 0; i < array.length(); ++i) {
                this.cleanResponse(array.get(i));
            }
        }
        return false;
    }
}

