/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Contracts;

import com.placetopay.java_placetopay.Exceptions.PlaceToPayException;
import com.placetopay.java_placetopay.Interfaces.HasValidator;
import com.placetopay.java_placetopay.validators.BaseValidator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class Entity
implements HasValidator {
    private BaseValidator validatorInstance;
    private Class validatorClass;

    @Override
    public BaseValidator getValidator() {
        try {
            if (this.validatorInstance == null) {
                this.validatorInstance = (BaseValidator)this.validatorClass.newInstance();
            }
            return this.validatorInstance;
        }
        catch (Exception ex) {
            throw new PlaceToPayException("Failed to load validator: " + ex.getMessage());
        }
    }

    public void setValidator(String validatorName) throws ClassNotFoundException {
        this.validatorClass = Class.forName("com.placetopay.java_placetopay.validators." + validatorName);
    }

    @Override
    public boolean isValid(List<String> fields) {
        return this.isValid(fields, true);
    }

    @Override
    public boolean isValid(List<String> fields, boolean silent) {
        return this.getValidator().isValid(this, fields, silent);
    }

    @Override
    public List<String> checkMissingFields(List<String> requiredFields) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public abstract JSONObject toJsonObject();

    public static JSONObject filterJSONObject(JSONObject object) {
        JSONObject result = new JSONObject();
        for (String key : object.keySet()) {
            Object value = object.get(key);
            if (value != null && (value instanceof String && value.equals("") || value instanceof JSONObject && ((JSONObject)value).length() == 0 || value instanceof JSONArray && ((JSONArray)value).length() == 0)) continue;
            result.put(key, value);
        }
        return result;
    }
}

