/*
 * Decompiled with CFR 0.152.
 */
package com.placetopay.java_placetopay.Contracts;

import com.placetopay.java_placetopay.Carrier.Authentication;
import com.placetopay.java_placetopay.Contracts.Carrier;
import com.placetopay.java_placetopay.Contracts.Configuration;
import com.placetopay.java_placetopay.Entities.Models.CollectRequest;
import com.placetopay.java_placetopay.Entities.Models.Notification;
import com.placetopay.java_placetopay.Entities.Models.RedirectInformation;
import com.placetopay.java_placetopay.Entities.Models.RedirectRequest;
import com.placetopay.java_placetopay.Entities.Models.RedirectResponse;
import com.placetopay.java_placetopay.Entities.Models.ReverseResponse;
import com.placetopay.java_placetopay.Exceptions.BadPlaceToPayException;
import com.placetopay.java_placetopay.Exceptions.PlaceToPayException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

public abstract class Gateway {
    public static final String TP_SOAP = "soap";
    public static final String TP_REST = "rest";
    protected String type = "rest";
    protected Carrier carrier = null;
    protected final Configuration config;

    public Gateway(String login, String trankey, URL url) {
        this(login, trankey, url, TP_REST);
    }

    public Gateway(String login, String trankey, URL url, String type) {
        this(login, trankey, url, type, new HashMap<String, String>());
    }

    public Gateway(String login, String trankey, URL url, String type, Map<String, String> additional) {
        this(login, trankey, url, type, null, additional);
    }

    public Gateway(String login, String tranKey, URL url, String type, Authentication.Parameter AuthParameters, Map<String, String> additional) {
        if (login == null || tranKey == null) {
            throw new PlaceToPayException("No login or tranKey provided on gateway");
        }
        if (url == null) {
            throw new PlaceToPayException("No service URL provided on gateway");
        }
        List<String> types = Arrays.asList(TP_SOAP, TP_REST);
        if (types.contains(type)) {
            this.type = type;
        }
        this.config = new Configuration(login, tranKey, url, type, additional, AuthParameters);
    }

    public abstract RedirectResponse request(RedirectRequest var1);

    public abstract RedirectInformation query(String var1);

    public abstract RedirectInformation collect(CollectRequest var1);

    public abstract ReverseResponse reverse(String var1);

    public void using(String type) {
        List<String> types = Arrays.asList(TP_SOAP, TP_REST);
        if (!types.contains(type)) {
            throw new PlaceToPayException("The only connection methods are SOAP or REST");
        }
        this.type = type;
        this.carrier = null;
    }

    public Notification readNotification(String content) throws BadPlaceToPayException {
        if (content == null) {
            throw new BadPlaceToPayException("The notification content is empty");
        }
        try {
            return new Notification(content, this.config.getTranKey());
        }
        catch (JSONException ex) {
            throw new BadPlaceToPayException("The notification content is bad :" + ex.getMessage());
        }
    }

    public Gateway addAuthenticationHeader(Map<String, String> data) {
        if (this.config.getAdditional().isEmpty()) {
            this.config.setAdditional(data);
        } else {
            this.config.getAdditional().putAll(data);
        }
        return this;
    }
}

